/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.msg;

import cn.omisheep.authz.annotation.RateLimit;
import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.Rule;
import cn.omisheep.authz.core.oauth.OpenAuthDict;
import cn.omisheep.commons.util.NamingUtils;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AuthzModifier {
    private Operate operate;
    private Target target;
    private String method;
    private String api;
    private Object value;
    private Integer index;
    private Role role;
    private String controller;
    private Permission permission;
    private Set<String> range;
    private Set<String> resources;
    private String className;
    private String fieldName;
    private String condition;
    private Rule rule;
    private Map<String, List<String>> argsMap;
    private RateLimitInfo rateLimit;
    private BlacklistInfo blacklistInfo;
    private OpenAuthDict.OAuthInfo oauth;

    public AuthzModifier setMethod(String method) {
        try {
            this.method = method.toUpperCase(Locale.ROOT);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this;
    }

    public AuthzModifier setParamName(String paramName) {
        this.value = paramName;
        return this;
    }

    public PermRolesMeta build() {
        PermRolesMeta permRolesMeta = new PermRolesMeta();
        if (this.role != null) {
            permRolesMeta.setRoles(this.role.require, this.role.exclude);
        }
        if (this.permission != null) {
            permRolesMeta.setPermissions(this.permission.require, this.permission.exclude);
        }
        if (permRolesMeta.non()) {
            return null;
        }
        return permRolesMeta;
    }

    public void setRequireRoles(Set<Set<String>> requireRoles) {
        if (this.role == null) {
            this.role = new Role();
        }
        this.role.require = requireRoles;
    }

    public void setExcludeRoles(Set<Set<String>> excludeRoles) {
        if (this.role == null) {
            this.role = new Role();
        }
        this.role.exclude = excludeRoles;
    }

    public void setRequirePermissions(Set<Set<String>> requirePermissions) {
        if (this.permission == null) {
            this.permission = new Permission();
        }
        this.permission.require = requirePermissions;
    }

    public void setExcludePermissions(Set<Set<String>> excludePermissions) {
        if (this.permission == null) {
            this.permission = new Permission();
        }
        this.permission.exclude = excludePermissions;
    }

    public Operate getOperate() {
        return this.operate;
    }

    public Target getTarget() {
        return this.target;
    }

    public String getMethod() {
        return this.method;
    }

    public String getApi() {
        return this.api;
    }

    public Object getValue() {
        return this.value;
    }

    public Integer getIndex() {
        return this.index;
    }

    public Role getRole() {
        return this.role;
    }

    public String getController() {
        return this.controller;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public Set<String> getRange() {
        return this.range;
    }

    public Set<String> getResources() {
        return this.resources;
    }

    public String getClassName() {
        return this.className;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getCondition() {
        return this.condition;
    }

    public Rule getRule() {
        return this.rule;
    }

    public Map<String, List<String>> getArgsMap() {
        return this.argsMap;
    }

    public RateLimitInfo getRateLimit() {
        return this.rateLimit;
    }

    public BlacklistInfo getBlacklistInfo() {
        return this.blacklistInfo;
    }

    public OpenAuthDict.OAuthInfo getOauth() {
        return this.oauth;
    }

    public AuthzModifier setOperate(Operate operate) {
        this.operate = operate;
        return this;
    }

    public AuthzModifier setTarget(Target target) {
        this.target = target;
        return this;
    }

    public AuthzModifier setApi(String api) {
        this.api = api;
        return this;
    }

    public AuthzModifier setValue(Object value) {
        this.value = value;
        return this;
    }

    public AuthzModifier setIndex(Integer index) {
        this.index = index;
        return this;
    }

    public AuthzModifier setRole(Role role) {
        this.role = role;
        return this;
    }

    public AuthzModifier setController(String controller) {
        this.controller = controller;
        return this;
    }

    public AuthzModifier setPermission(Permission permission) {
        this.permission = permission;
        return this;
    }

    public AuthzModifier setRange(Set<String> range) {
        this.range = range;
        return this;
    }

    public AuthzModifier setResources(Set<String> resources) {
        this.resources = resources;
        return this;
    }

    public AuthzModifier setClassName(String className) {
        this.className = className;
        return this;
    }

    public AuthzModifier setFieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public AuthzModifier setCondition(String condition) {
        this.condition = condition;
        return this;
    }

    public AuthzModifier setRule(Rule rule) {
        this.rule = rule;
        return this;
    }

    public AuthzModifier setArgsMap(Map<String, List<String>> argsMap) {
        this.argsMap = argsMap;
        return this;
    }

    public AuthzModifier setRateLimit(RateLimitInfo rateLimit) {
        this.rateLimit = rateLimit;
        return this;
    }

    public AuthzModifier setBlacklistInfo(BlacklistInfo blacklistInfo) {
        this.blacklistInfo = blacklistInfo;
        return this;
    }

    public AuthzModifier setOauth(OpenAuthDict.OAuthInfo oauth) {
        this.oauth = oauth;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthzModifier)) {
            return false;
        }
        AuthzModifier other = (AuthzModifier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$index = this.getIndex();
        Integer other$index = other.getIndex();
        if (this$index == null ? other$index != null : !((Object)this$index).equals(other$index)) {
            return false;
        }
        Operate this$operate = this.getOperate();
        Operate other$operate = other.getOperate();
        if (this$operate == null ? other$operate != null : !((Object)((Object)this$operate)).equals((Object)other$operate)) {
            return false;
        }
        Target this$target = this.getTarget();
        Target other$target = other.getTarget();
        if (this$target == null ? other$target != null : !((Object)((Object)this$target)).equals((Object)other$target)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$api = this.getApi();
        String other$api = other.getApi();
        if (this$api == null ? other$api != null : !this$api.equals(other$api)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        Role this$role = this.getRole();
        Role other$role = other.getRole();
        if (this$role == null ? other$role != null : !((Object)this$role).equals(other$role)) {
            return false;
        }
        String this$controller = this.getController();
        String other$controller = other.getController();
        if (this$controller == null ? other$controller != null : !this$controller.equals(other$controller)) {
            return false;
        }
        Permission this$permission = this.getPermission();
        Permission other$permission = other.getPermission();
        if (this$permission == null ? other$permission != null : !((Object)this$permission).equals(other$permission)) {
            return false;
        }
        Set<String> this$range = this.getRange();
        Set<String> other$range = other.getRange();
        if (this$range == null ? other$range != null : !((Object)this$range).equals(other$range)) {
            return false;
        }
        Set<String> this$resources = this.getResources();
        Set<String> other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !((Object)this$resources).equals(other$resources)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$fieldName = this.getFieldName();
        String other$fieldName = other.getFieldName();
        if (this$fieldName == null ? other$fieldName != null : !this$fieldName.equals(other$fieldName)) {
            return false;
        }
        String this$condition = this.getCondition();
        String other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        Rule this$rule = this.getRule();
        Rule other$rule = other.getRule();
        if (this$rule == null ? other$rule != null : !this$rule.equals(other$rule)) {
            return false;
        }
        Map<String, List<String>> this$argsMap = this.getArgsMap();
        Map<String, List<String>> other$argsMap = other.getArgsMap();
        if (this$argsMap == null ? other$argsMap != null : !((Object)this$argsMap).equals(other$argsMap)) {
            return false;
        }
        RateLimitInfo this$rateLimit = this.getRateLimit();
        RateLimitInfo other$rateLimit = other.getRateLimit();
        if (this$rateLimit == null ? other$rateLimit != null : !((Object)this$rateLimit).equals(other$rateLimit)) {
            return false;
        }
        BlacklistInfo this$blacklistInfo = this.getBlacklistInfo();
        BlacklistInfo other$blacklistInfo = other.getBlacklistInfo();
        if (this$blacklistInfo == null ? other$blacklistInfo != null : !((Object)this$blacklistInfo).equals(other$blacklistInfo)) {
            return false;
        }
        OpenAuthDict.OAuthInfo this$oauth = this.getOauth();
        OpenAuthDict.OAuthInfo other$oauth = other.getOauth();
        return !(this$oauth == null ? other$oauth != null : !((Object)this$oauth).equals(other$oauth));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthzModifier;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $index = this.getIndex();
        result = result * 59 + ($index == null ? 43 : ((Object)$index).hashCode());
        Operate $operate = this.getOperate();
        result = result * 59 + ($operate == null ? 43 : ((Object)((Object)$operate)).hashCode());
        Target $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : ((Object)((Object)$target)).hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $api = this.getApi();
        result = result * 59 + ($api == null ? 43 : $api.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        Role $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : ((Object)$role).hashCode());
        String $controller = this.getController();
        result = result * 59 + ($controller == null ? 43 : $controller.hashCode());
        Permission $permission = this.getPermission();
        result = result * 59 + ($permission == null ? 43 : ((Object)$permission).hashCode());
        Set<String> $range = this.getRange();
        result = result * 59 + ($range == null ? 43 : ((Object)$range).hashCode());
        Set<String> $resources = this.getResources();
        result = result * 59 + ($resources == null ? 43 : ((Object)$resources).hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $fieldName = this.getFieldName();
        result = result * 59 + ($fieldName == null ? 43 : $fieldName.hashCode());
        String $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        Rule $rule = this.getRule();
        result = result * 59 + ($rule == null ? 43 : $rule.hashCode());
        Map<String, List<String>> $argsMap = this.getArgsMap();
        result = result * 59 + ($argsMap == null ? 43 : ((Object)$argsMap).hashCode());
        RateLimitInfo $rateLimit = this.getRateLimit();
        result = result * 59 + ($rateLimit == null ? 43 : ((Object)$rateLimit).hashCode());
        BlacklistInfo $blacklistInfo = this.getBlacklistInfo();
        result = result * 59 + ($blacklistInfo == null ? 43 : ((Object)$blacklistInfo).hashCode());
        OpenAuthDict.OAuthInfo $oauth = this.getOauth();
        result = result * 59 + ($oauth == null ? 43 : ((Object)$oauth).hashCode());
        return result;
    }

    public String toString() {
        return "AuthzModifier(operate=" + (Object)((Object)this.getOperate()) + ", target=" + (Object)((Object)this.getTarget()) + ", method=" + this.getMethod() + ", api=" + this.getApi() + ", value=" + this.getValue() + ", index=" + this.getIndex() + ", role=" + this.getRole() + ", controller=" + this.getController() + ", permission=" + this.getPermission() + ", range=" + this.getRange() + ", resources=" + this.getResources() + ", className=" + this.getClassName() + ", fieldName=" + this.getFieldName() + ", condition=" + this.getCondition() + ", rule=" + this.getRule() + ", argsMap=" + this.getArgsMap() + ", rateLimit=" + this.getRateLimit() + ", blacklistInfo=" + this.getBlacklistInfo() + ", oauth=" + this.getOauth() + ")";
    }

    public static enum Operate {
        ADD,
        DELETE,
        DEL,
        MODIFY,
        UPDATE,
        GET,
        READ,
        EMPTY,
        NON;


        @JsonCreator
        public static Operate create(String type) {
            try {
                return Operate.valueOf(type.toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                return EMPTY;
            }
        }
    }

    public static enum Target {
        API,
        PARAMETER,
        DATA_COL,
        DATA_ROW,
        RATE,
        BLACKLIST,
        OPEN_AUTH,
        LOGIN,
        NON;


        @JsonCreator
        public static Target create(String target) {
            try {
                return Target.valueOf(NamingUtils.humpToUnderline((String)target).toUpperCase(Locale.ROOT));
            }
            catch (Exception e) {
                return NON;
            }
        }
    }

    public static class BlacklistInfo {
        private TYPE type;
        private OP op;
        private String ip;
        private String ipRange;
        private Object userId;
        private String deviceType;
        private String deviceId;
        private long time;
        private String date;

        public TYPE getType() {
            return this.type;
        }

        public OP getOp() {
            return this.op;
        }

        public String getIp() {
            return this.ip;
        }

        public String getIpRange() {
            return this.ipRange;
        }

        public Object getUserId() {
            return this.userId;
        }

        public String getDeviceType() {
            return this.deviceType;
        }

        public String getDeviceId() {
            return this.deviceId;
        }

        public long getTime() {
            return this.time;
        }

        public String getDate() {
            return this.date;
        }

        public BlacklistInfo setType(TYPE type) {
            this.type = type;
            return this;
        }

        public BlacklistInfo setOp(OP op) {
            this.op = op;
            return this;
        }

        public BlacklistInfo setIp(String ip) {
            this.ip = ip;
            return this;
        }

        public BlacklistInfo setIpRange(String ipRange) {
            this.ipRange = ipRange;
            return this;
        }

        public BlacklistInfo setUserId(Object userId) {
            this.userId = userId;
            return this;
        }

        public BlacklistInfo setDeviceType(String deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public BlacklistInfo setDeviceId(String deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        public BlacklistInfo setTime(long time) {
            this.time = time;
            return this;
        }

        public BlacklistInfo setDate(String date) {
            this.date = date;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BlacklistInfo)) {
                return false;
            }
            BlacklistInfo other = (BlacklistInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getTime() != other.getTime()) {
                return false;
            }
            TYPE this$type = this.getType();
            TYPE other$type = other.getType();
            if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
                return false;
            }
            OP this$op = this.getOp();
            OP other$op = other.getOp();
            if (this$op == null ? other$op != null : !((Object)((Object)this$op)).equals((Object)other$op)) {
                return false;
            }
            String this$ip = this.getIp();
            String other$ip = other.getIp();
            if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
                return false;
            }
            String this$ipRange = this.getIpRange();
            String other$ipRange = other.getIpRange();
            if (this$ipRange == null ? other$ipRange != null : !this$ipRange.equals(other$ipRange)) {
                return false;
            }
            Object this$userId = this.getUserId();
            Object other$userId = other.getUserId();
            if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
                return false;
            }
            String this$deviceType = this.getDeviceType();
            String other$deviceType = other.getDeviceType();
            if (this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType)) {
                return false;
            }
            String this$deviceId = this.getDeviceId();
            String other$deviceId = other.getDeviceId();
            if (this$deviceId == null ? other$deviceId != null : !this$deviceId.equals(other$deviceId)) {
                return false;
            }
            String this$date = this.getDate();
            String other$date = other.getDate();
            return !(this$date == null ? other$date != null : !this$date.equals(other$date));
        }

        protected boolean canEqual(Object other) {
            return other instanceof BlacklistInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $time = this.getTime();
            result = result * 59 + (int)($time >>> 32 ^ $time);
            TYPE $type = this.getType();
            result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
            OP $op = this.getOp();
            result = result * 59 + ($op == null ? 43 : ((Object)((Object)$op)).hashCode());
            String $ip = this.getIp();
            result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
            String $ipRange = this.getIpRange();
            result = result * 59 + ($ipRange == null ? 43 : $ipRange.hashCode());
            Object $userId = this.getUserId();
            result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
            String $deviceType = this.getDeviceType();
            result = result * 59 + ($deviceType == null ? 43 : $deviceType.hashCode());
            String $deviceId = this.getDeviceId();
            result = result * 59 + ($deviceId == null ? 43 : $deviceId.hashCode());
            String $date = this.getDate();
            result = result * 59 + ($date == null ? 43 : $date.hashCode());
            return result;
        }

        public String toString() {
            return "AuthzModifier.BlacklistInfo(type=" + (Object)((Object)this.getType()) + ", op=" + (Object)((Object)this.getOp()) + ", ip=" + this.getIp() + ", ipRange=" + this.getIpRange() + ", userId=" + this.getUserId() + ", deviceType=" + this.getDeviceType() + ", deviceId=" + this.getDeviceId() + ", time=" + this.getTime() + ", date=" + this.getDate() + ")";
        }

        public static enum TYPE {
            IP,
            USER,
            DEVICE,
            IP_RANGE,
            NON;


            @JsonCreator
            public static TYPE create(String type) {
                try {
                    return TYPE.valueOf(type.toUpperCase(Locale.ROOT));
                }
                catch (Exception e) {
                    return NON;
                }
            }
        }

        public static enum OP {
            UPDATE,
            REMOVE,
            READ,
            NON;


            @JsonCreator
            public static OP create(String op) {
                try {
                    return OP.valueOf(op.toUpperCase(Locale.ROOT));
                }
                catch (Exception e) {
                    return NON;
                }
            }
        }
    }

    public static class RateLimitInfo {
        private long window;
        private int maxRequests;
        private List<String> punishmentTime = new ArrayList<String>();
        private long minInterval;
        private List<String> associatedPatterns = new ArrayList<String>();
        private RateLimit.CheckType checkType;

        public long getWindow() {
            return this.window;
        }

        public int getMaxRequests() {
            return this.maxRequests;
        }

        public List<String> getPunishmentTime() {
            return this.punishmentTime;
        }

        public long getMinInterval() {
            return this.minInterval;
        }

        public List<String> getAssociatedPatterns() {
            return this.associatedPatterns;
        }

        public RateLimit.CheckType getCheckType() {
            return this.checkType;
        }

        public RateLimitInfo setWindow(long window) {
            this.window = window;
            return this;
        }

        public RateLimitInfo setMaxRequests(int maxRequests) {
            this.maxRequests = maxRequests;
            return this;
        }

        public RateLimitInfo setPunishmentTime(List<String> punishmentTime) {
            this.punishmentTime = punishmentTime;
            return this;
        }

        public RateLimitInfo setMinInterval(long minInterval) {
            this.minInterval = minInterval;
            return this;
        }

        public RateLimitInfo setAssociatedPatterns(List<String> associatedPatterns) {
            this.associatedPatterns = associatedPatterns;
            return this;
        }

        public RateLimitInfo setCheckType(RateLimit.CheckType checkType) {
            this.checkType = checkType;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RateLimitInfo)) {
                return false;
            }
            RateLimitInfo other = (RateLimitInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getWindow() != other.getWindow()) {
                return false;
            }
            if (this.getMaxRequests() != other.getMaxRequests()) {
                return false;
            }
            if (this.getMinInterval() != other.getMinInterval()) {
                return false;
            }
            List<String> this$punishmentTime = this.getPunishmentTime();
            List<String> other$punishmentTime = other.getPunishmentTime();
            if (this$punishmentTime == null ? other$punishmentTime != null : !((Object)this$punishmentTime).equals(other$punishmentTime)) {
                return false;
            }
            List<String> this$associatedPatterns = this.getAssociatedPatterns();
            List<String> other$associatedPatterns = other.getAssociatedPatterns();
            if (this$associatedPatterns == null ? other$associatedPatterns != null : !((Object)this$associatedPatterns).equals(other$associatedPatterns)) {
                return false;
            }
            RateLimit.CheckType this$checkType = this.getCheckType();
            RateLimit.CheckType other$checkType = other.getCheckType();
            return !(this$checkType == null ? other$checkType != null : !((Object)((Object)this$checkType)).equals((Object)other$checkType));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RateLimitInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $window = this.getWindow();
            result = result * 59 + (int)($window >>> 32 ^ $window);
            result = result * 59 + this.getMaxRequests();
            long $minInterval = this.getMinInterval();
            result = result * 59 + (int)($minInterval >>> 32 ^ $minInterval);
            List<String> $punishmentTime = this.getPunishmentTime();
            result = result * 59 + ($punishmentTime == null ? 43 : ((Object)$punishmentTime).hashCode());
            List<String> $associatedPatterns = this.getAssociatedPatterns();
            result = result * 59 + ($associatedPatterns == null ? 43 : ((Object)$associatedPatterns).hashCode());
            RateLimit.CheckType $checkType = this.getCheckType();
            result = result * 59 + ($checkType == null ? 43 : ((Object)((Object)$checkType)).hashCode());
            return result;
        }

        public String toString() {
            return "AuthzModifier.RateLimitInfo(window=" + this.getWindow() + ", maxRequests=" + this.getMaxRequests() + ", punishmentTime=" + this.getPunishmentTime() + ", minInterval=" + this.getMinInterval() + ", associatedPatterns=" + this.getAssociatedPatterns() + ", checkType=" + (Object)((Object)this.getCheckType()) + ")";
        }
    }

    public static class Permission {
        private Set<Set<String>> require;
        private Set<Set<String>> exclude;

        public Set<Set<String>> getRequire() {
            return this.require;
        }

        public Set<Set<String>> getExclude() {
            return this.exclude;
        }

        public Permission setRequire(Set<Set<String>> require) {
            this.require = require;
            return this;
        }

        public Permission setExclude(Set<Set<String>> exclude) {
            this.exclude = exclude;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Permission)) {
                return false;
            }
            Permission other = (Permission)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<Set<String>> this$require = this.getRequire();
            Set<Set<String>> other$require = other.getRequire();
            if (this$require == null ? other$require != null : !((Object)this$require).equals(other$require)) {
                return false;
            }
            Set<Set<String>> this$exclude = this.getExclude();
            Set<Set<String>> other$exclude = other.getExclude();
            return !(this$exclude == null ? other$exclude != null : !((Object)this$exclude).equals(other$exclude));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Permission;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<Set<String>> $require = this.getRequire();
            result = result * 59 + ($require == null ? 43 : ((Object)$require).hashCode());
            Set<Set<String>> $exclude = this.getExclude();
            result = result * 59 + ($exclude == null ? 43 : ((Object)$exclude).hashCode());
            return result;
        }

        public String toString() {
            return "AuthzModifier.Permission(require=" + this.getRequire() + ", exclude=" + this.getExclude() + ")";
        }
    }

    public static class Role {
        private Set<Set<String>> require;
        private Set<Set<String>> exclude;

        public Set<Set<String>> getRequire() {
            return this.require;
        }

        public Set<Set<String>> getExclude() {
            return this.exclude;
        }

        public Role setRequire(Set<Set<String>> require) {
            this.require = require;
            return this;
        }

        public Role setExclude(Set<Set<String>> exclude) {
            this.exclude = exclude;
            return this;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Role)) {
                return false;
            }
            Role other = (Role)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Set<Set<String>> this$require = this.getRequire();
            Set<Set<String>> other$require = other.getRequire();
            if (this$require == null ? other$require != null : !((Object)this$require).equals(other$require)) {
                return false;
            }
            Set<Set<String>> this$exclude = this.getExclude();
            Set<Set<String>> other$exclude = other.getExclude();
            return !(this$exclude == null ? other$exclude != null : !((Object)this$exclude).equals(other$exclude));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Role;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<Set<String>> $require = this.getRequire();
            result = result * 59 + ($require == null ? 43 : ((Object)$require).hashCode());
            Set<Set<String>> $exclude = this.getExclude();
            result = result * 59 + ($exclude == null ? 43 : ((Object)$exclude).hashCode());
            return result;
        }

        public String toString() {
            return "AuthzModifier.Role(require=" + this.getRequire() + ", exclude=" + this.getExclude() + ")";
        }
    }
}

