/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.interceptor;

import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.rpd.DataPermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.FieldDataPermRolesMeta;
import cn.omisheep.authz.core.interceptor.DataFinderSecurityInterceptor;
import cn.omisheep.authz.core.util.ArgsParser;
import cn.omisheep.commons.util.CollectionUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;

public class DefaultDataSecurityInterceptor
implements DataFinderSecurityInterceptor {
    @Override
    public String sqlChange(HttpMeta httpMeta, List<DataPermRolesMeta> dataPermRolesMetaList, Class<?> resultType, String sql) throws JSQLParserException {
        if (dataPermRolesMetaList.size() == 0) {
            return sql;
        }
        Set<String> rolesByUserId = httpMeta.getRoles();
        Set<String> permissionsByRole = httpMeta.getPermissions();
        Iterator iterator = dataPermRolesMetaList.stream().filter(dataPermMeta -> dataPermMeta.non() && httpMeta.hasToken() || CollectionUtils.containsSub(dataPermMeta.getRequireRoles(), (Set)rolesByUserId) || CollectionUtils.containsSub(dataPermMeta.getRequirePermissions(), (Set)permissionsByRole) || !CollectionUtils.containsSub(dataPermMeta.getExcludeRoles(), (Set)rolesByUserId) || !CollectionUtils.containsSub(dataPermMeta.getExcludePermissions(), (Set)permissionsByRole)).map(ArgsParser::parse).iterator();
        if (!iterator.hasNext()) {
            return sql;
        }
        Select select = (Select)CCJSqlParserUtil.parse((String)sql);
        PlainSelect selectBody = (PlainSelect)select.getSelectBody();
        Expression where = selectBody.getWhere();
        StringBuilder sb = new StringBuilder();
        sb.append(" ( ");
        while (iterator.hasNext()) {
            sb.append((String)iterator.next());
            if (iterator.hasNext()) {
                sb.append(" OR ");
                continue;
            }
            if (where != null) {
                sb.append(" ) AND ").append(where);
                continue;
            }
            sb.append(" ) ");
        }
        Expression securityWhere = CCJSqlParserUtil.parseCondExpression((String)sb.toString());
        return selectBody.withWhere(securityWhere).toString();
    }

    @Override
    public Object dataTrim(HttpMeta httpMeta, Map<String, FieldDataPermRolesMeta> fieldDataMap, Class<?> resultType, Object obj) {
        try {
            Set<String> rolesByUserId = httpMeta.getRoles();
            Set<String> permissionsByRole = httpMeta.getPermissions();
            ArrayList deleted = new ArrayList();
            fieldDataMap.entrySet().stream().filter(e -> ((FieldDataPermRolesMeta)e.getValue()).non() && !httpMeta.hasToken() || !CollectionUtils.containsSub(((FieldDataPermRolesMeta)e.getValue()).getRoles().getRequire(), (Set)rolesByUserId) || !CollectionUtils.containsSub(((FieldDataPermRolesMeta)e.getValue()).getPermissions().getRequire(), (Set)permissionsByRole) || CollectionUtils.containsSub(((FieldDataPermRolesMeta)e.getValue()).getRoles().getExclude(), (Set)rolesByUserId) || CollectionUtils.containsSub(((FieldDataPermRolesMeta)e.getValue()).getPermissions().getExclude(), (Set)permissionsByRole)).map(Map.Entry::getKey).forEach(deleted::add);
            if (obj instanceof Collection) {
                ((Collection)obj).forEach(o -> {
                    for (String d : deleted) {
                        try {
                            Field declaredField = resultType.getDeclaredField(d);
                            declaredField.setAccessible(true);
                            declaredField.set(o, null);
                        }
                        catch (Exception exception) {}
                    }
                });
            }
            return obj;
        }
        catch (Exception e2) {
            return obj;
        }
    }
}

