/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.interceptor;

import cn.omisheep.authz.core.AuthzProperties;
import cn.omisheep.authz.core.ExceptionStatus;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.interceptor.AuthzExceptionHandler;
import cn.omisheep.web.entity.Result;
import cn.omisheep.web.utils.HttpUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;

public class DefaultAuthzExceptionHandler
implements AuthzExceptionHandler {
    private final AuthzProperties.ResponseConfig config;

    public DefaultAuthzExceptionHandler(AuthzProperties.ResponseConfig config) {
        this.config = config;
    }

    @Override
    public boolean handle(HttpServletRequest request, HttpServletResponse response, HttpMeta httpMeta, ExceptionStatus firstExceptionStatus, List<Object> errorObjects) throws Exception {
        if (firstExceptionStatus.equals((Object)ExceptionStatus.MISMATCHED_URL)) {
            httpMeta.log("\u300c\u666e\u901a\u8bbf\u95ee(uri\u4e0d\u5b58\u5728)\u300d \tmethod: [{}] , ip : [{}] , path: [{}]   ", httpMeta.getMethod(), httpMeta.getIp(), httpMeta.getApi());
            return true;
        }
        if (this.config.isAlwaysOk()) {
            HttpUtils.returnResponse((int)200, (Object)Result.of((int)firstExceptionStatus.getCode(), (String)firstExceptionStatus.getMessage()));
        } else {
            HttpUtils.returnResponse((HttpStatus)firstExceptionStatus.getHttpStatus(), (Object)Result.of((int)firstExceptionStatus.getCode(), (String)firstExceptionStatus.getMessage()));
        }
        return false;
    }
}

