/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.helper;

import cn.omisheep.authz.core.AuthzProperties;
import cn.omisheep.authz.core.auth.deviced.Device;
import cn.omisheep.authz.core.auth.deviced.UserDevicesDict;
import cn.omisheep.authz.core.callback.AuthorizationCallback;
import cn.omisheep.authz.core.config.AuthzAppVersion;
import cn.omisheep.authz.core.config.Constants;
import cn.omisheep.authz.core.helper.AuthzGranterHelper;
import cn.omisheep.authz.core.helper.BaseHelper;
import cn.omisheep.authz.core.oauth.AuthorizationException;
import cn.omisheep.authz.core.oauth.AuthorizationInfo;
import cn.omisheep.authz.core.oauth.AuthorizedDeviceDetails;
import cn.omisheep.authz.core.oauth.ClientDetails;
import cn.omisheep.authz.core.tk.GrantType;
import cn.omisheep.authz.core.tk.IssueToken;
import cn.omisheep.authz.core.tk.TokenHelper;
import cn.omisheep.authz.core.tk.TokenPair;
import cn.omisheep.commons.encryption.Digest;
import cn.omisheep.commons.util.TimeUtils;
import cn.omisheep.commons.util.UUIDBits;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class OpenAuthHelper
extends BaseHelper {
    private static final AuthzProperties.OpenAuthConfig oauthConfig = properties.getOauth();
    private static AuthorizationCallback authorizationCallback;

    private OpenAuthHelper() {
        throw new UnsupportedOperationException();
    }

    public static IssueToken authorizeByCode(String clientId, String clientSecret, String authorizationCode) throws AuthorizationException {
        OpenAuthHelper.checkClient(clientId, clientSecret);
        String key = Constants.AUTHORIZE_CODE_PREFIX.get() + authorizationCode;
        AuthorizationInfo authorizationInfo = cache.get(key, AuthorizationInfo.class);
        cache.del(key);
        if (authorizationInfo == null || authorizationInfo.getExpiresAt() < TimeUtils.nowTime()) {
            throw AuthorizationException.authorizationCodeExpiredOrNotExist();
        }
        return OpenAuthHelper.authorize(authorizationInfo);
    }

    public static IssueToken authorizeByPassword(String clientId, String clientSecret, String scope, Object userId) throws AuthorizationException {
        ClientDetails clientDetails = OpenAuthHelper.checkClient(clientId, clientSecret);
        if (userId == null) {
            throw AuthorizationException.privilegeGrantFailed();
        }
        AuthorizationInfo authorizationInfo = new AuthorizationInfo(clientId, clientDetails.getClientName(), scope, GrantType.PASSWORD, null, null, null, userId);
        return OpenAuthHelper.authorize(authorizationInfo);
    }

    public static IssueToken authorizeByClient(String clientId, String clientSecret, String scope) throws AuthorizationException {
        ClientDetails clientDetails = OpenAuthHelper.checkClient(clientId, clientSecret);
        AuthorizationInfo authorizationInfo = new AuthorizationInfo(clientId, clientDetails.getClientName(), scope, GrantType.CLIENT_CREDENTIALS, null, null, null, null);
        return OpenAuthHelper.authorize(authorizationInfo);
    }

    private static ClientDetails checkClient(String clientId, String clientSecret) throws AuthorizationException {
        ClientDetails clientDetails = openAuthLibrary.getClientById(clientId);
        if (clientDetails == null || !StringUtils.equals((String)clientDetails.getClientSecret(), (String)clientSecret)) {
            throw AuthorizationException.clientSecretError();
        }
        return clientDetails;
    }

    private static IssueToken authorize(AuthorizationInfo authorizationInfo) {
        TokenPair tokenPair = TokenHelper.createTokenPair(authorizationInfo);
        AuthzGranterHelper.grant(tokenPair, false);
        if (authorizationCallback != null) {
            authorizationCallback.authorize(new AuthorizedDeviceDetails(authorizationInfo, tokenPair.getRefreshToken().getId()));
        }
        return TokenHelper.createIssueToken(tokenPair);
    }

    public static String createAuthorizationCode(String clientId, String scope, String redirectUrl, Object userId) throws AuthorizationException {
        ClientDetails client = OpenAuthHelper.findClient(clientId);
        if (client == null || !StringUtils.equals((String)client.getRedirectUrl(), (String)redirectUrl)) {
            throw AuthorizationException.clientNotExist();
        }
        String authorizationCode = Digest.hash((String)oauthConfig.getAlgorithm().getValue(), (String)(clientId + scope + System.currentTimeMillis() + UUIDBits.getUUIDBits((int)16)));
        if (authorizationCode == null) {
            throw AuthorizationException.privilegeGrantFailed();
        }
        Date now = TimeUtils.now();
        Date expiredTime = TimeUtils.datePlus((Date)now, (long)AuthzAppVersion.AUTHORIZATION_CODE_TIME.get());
        AuthorizationInfo authorizationInfo = new AuthorizationInfo(clientId, client.getClientName(), scope, GrantType.AUTHORIZATION_CODE, AuthzAppVersion.AUTHORIZATION_CODE_TIME.get(), expiredTime.getTime(), now.getTime(), userId);
        if (authorizationCallback != null) {
            authorizationCallback.createAuthorizationCodeCallback(authorizationCode, authorizationInfo);
        }
        cache.set(Constants.AUTHORIZE_CODE_PREFIX.get() + authorizationCode, authorizationInfo, AuthzAppVersion.AUTHORIZATION_CODE_TIME.get());
        return authorizationCode;
    }

    public static String createBasicScopeAuthorizationCode(String clientId, String redirectUrl, Object userId) throws AuthorizationException {
        return OpenAuthHelper.createAuthorizationCode(clientId, oauthConfig.getDefaultBasicScope(), redirectUrl, userId);
    }

    public static ClientDetails clientRegister(String clientName, String redirectUrl) {
        String clientId = UUIDBits.getUUIDBits((int)oauthConfig.getClientIdLength(), k -> openAuthLibrary.getClientById((String)k) == null, (int)20);
        if (clientId == null) {
            return null;
        }
        return OpenAuthHelper.clientRegister(clientId, UUIDBits.getUUIDBits((int)oauthConfig.getClientSecretLength()), clientName, redirectUrl);
    }

    public static ClientDetails clientRegister(String clientId, String clientName, String redirectUrl) {
        if (clientId == null) {
            return null;
        }
        return OpenAuthHelper.clientRegister(clientId, UUIDBits.getUUIDBits((int)oauthConfig.getClientSecretLength()), clientName, redirectUrl);
    }

    public static ClientDetails clientRegister(String clientId, String clientSecret, String clientName, String redirectUrl) {
        if (clientId == null || clientSecret == null) {
            return null;
        }
        ClientDetails clientDetails = new ClientDetails().setClientId(clientId).setClientSecret(clientSecret).setClientName(clientName).setRedirectUrl(redirectUrl);
        openAuthLibrary.registerClient(clientDetails);
        return clientDetails;
    }

    public static ClientDetails findClient(String clientId) {
        if (clientId == null) {
            return null;
        }
        return openAuthLibrary.getClientById(clientId);
    }

    public static void deleteClient(String clientId) {
        if (clientId == null) {
            return;
        }
        openAuthLibrary.deleteClientById(clientId);
    }

    public static List<AuthorizedDeviceDetails> getAuthorizedDeviceDetailsAt(Object userId) {
        Set<String> keys = cache.keys(UserDevicesDict.oauthKey(userId, "*"));
        Map<String, Device> deviceMap = cache.get(keys, Device.class);
        Iterator iterator = keys.stream().map(k -> k.split(":")[6]).iterator();
        return deviceMap.values().stream().map(v -> {
            if (v == null) {
                return null;
            }
            return new AuthorizedDeviceDetails((Device)v, userId, (String)iterator.next());
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static void removeAuthorizedDevice(Object userId, String authorizedDeviceId) {
        if (authorizedDeviceId.contains("*")) {
            return;
        }
        cache.del(UserDevicesDict.oauthKey(userId, authorizedDeviceId));
    }

    public static void removeAllAuthorizedDevice(Object userId) {
        Set<String> keys = cache.keys(UserDevicesDict.oauthKey(userId, "*"));
        cache.del(keys);
        if (authorizationCallback != null) {
            for (String k : keys) {
                authorizationCallback.removeAuthorization(k.split(":")[6]);
            }
        }
    }

    public static void setAuthorizationCallback(AuthorizationCallback authorizationCallback) {
        OpenAuthHelper.authorizationCallback = authorizationCallback;
    }
}

