/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.helper;

import cn.omisheep.authz.AuHelper;
import cn.omisheep.authz.core.AuthzContext;
import cn.omisheep.authz.core.NotLoginException;
import cn.omisheep.authz.core.RefreshTokenExpiredException;
import cn.omisheep.authz.core.ThreadWebEnvironmentException;
import cn.omisheep.authz.core.TokenException;
import cn.omisheep.authz.core.helper.BaseHelper;
import cn.omisheep.authz.core.tk.AccessToken;
import cn.omisheep.authz.core.tk.IssueToken;
import cn.omisheep.authz.core.tk.TokenHelper;
import cn.omisheep.authz.core.tk.TokenPair;
import cn.omisheep.web.utils.HttpUtils;
import io.jsonwebtoken.ExpiredJwtException;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class AuthzGranterHelper
extends BaseHelper {
    private AuthzGranterHelper() {
        throw new UnsupportedOperationException();
    }

    public static IssueToken grant(Object userId, String deviceType, String deviceId) {
        if (deviceType == null) {
            try {
                deviceType = AuHelper.getHttpMeta().getUserAgent();
            }
            catch (ThreadWebEnvironmentException e) {
                deviceType = "unknown";
            }
        }
        TokenPair tokenPair = TokenHelper.createTokenPair(userId, deviceType, deviceId);
        AuthzGranterHelper.grant(tokenPair, true);
        return TokenHelper.createIssueToken(tokenPair);
    }

    public static void grant(TokenPair tokenPair, boolean resp) {
        userDevicesDict.addUser(tokenPair, AuthzContext.getCurrentHttpMeta());
        try {
            HttpServletResponse response = HttpUtils.getCurrentResponse();
            if (response != null) {
                if (resp) {
                    response.addCookie(TokenHelper.generateCookie(tokenPair.getAccessToken()));
                } else {
                    response.setHeader("pragma", "no-cache");
                    response.setHeader("cache-control", "no-cache");
                    response.setDateHeader("expires", 0L);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static IssueToken refreshToken(String refreshToken) throws RefreshTokenExpiredException, TokenException {
        try {
            if (refreshToken == null) {
                throw new TokenException();
            }
            TokenPair tokenPair = TokenHelper.refreshToken(refreshToken);
            if (userDevicesDict.refreshUser(tokenPair)) {
                try {
                    HttpServletResponse response = HttpUtils.getCurrentResponse();
                    if (response != null) {
                        response.addCookie(TokenHelper.generateCookie(tokenPair.getAccessToken()));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return TokenHelper.createIssueToken(tokenPair);
            }
            throw new RefreshTokenExpiredException();
        }
        catch (ExpiredJwtException e) {
            throw new RefreshTokenExpiredException();
        }
        catch (Exception e) {
            throw new TokenException();
        }
    }

    public static void clearCookie(Object userId, String deviceType, String deviceId) {
        try {
            AccessToken token = AuthzContext.getCurrentToken();
            if (userId == null) {
                userId = token.getUserId();
            }
            if (ObjectUtils.equals((Object)token.getUserId(), (Object)userId) && (deviceType == null || StringUtils.equals((String)token.getDeviceType(), (String)deviceType)) && (deviceId == null || StringUtils.equals((String)token.getDeviceId(), (String)deviceId))) {
                TokenHelper.clearCookie(HttpUtils.getCurrentResponse());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void logoutById(Object userId, String id) {
        userDevicesDict.removeDeviceById(userId, id);
        AuthzGranterHelper.clearCookie(userId, null, null);
    }

    public static void logout() throws NotLoginException {
        AuHelper.getToken();
        userDevicesDict.removeCurrentDevice();
        AuthzGranterHelper.clearCookie(null, null, null);
    }

    public static void logoutAll() throws NotLoginException {
        userDevicesDict.removeAllDevice(AuHelper.getUserId());
        AuthzGranterHelper.clearCookie(null, null, null);
    }

    public static void logout(@NonNull String deviceType, @Nullable String deviceId) throws NotLoginException {
        userDevicesDict.removeDevice(AuHelper.getUserId(), deviceType, deviceId);
        AuthzGranterHelper.clearCookie(null, deviceType, deviceId);
    }

    public static void logoutAll(@NonNull Object userId) {
        userDevicesDict.removeAllDevice(userId);
        AuthzGranterHelper.clearCookie(userId, null, null);
    }

    public static void logout(@NonNull Object userId, @NonNull String deviceType) {
        userDevicesDict.removeDevice(userId, deviceType, null);
        AuthzGranterHelper.clearCookie(userId, deviceType, null);
    }

    public static void logout(@NonNull Object userId, @NonNull String deviceType, @Nullable String deviceId) {
        userDevicesDict.removeDevice(userId, deviceType, deviceId);
        AuthzGranterHelper.clearCookie(userId, deviceType, deviceId);
    }
}

