/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.helper;

import cn.omisheep.authz.AuHelper;
import cn.omisheep.authz.core.NotLoginException;
import cn.omisheep.authz.core.auth.deviced.DeviceCountInfo;
import cn.omisheep.authz.core.auth.deviced.DeviceDetails;
import cn.omisheep.authz.core.helper.BaseHelper;
import cn.omisheep.commons.util.TimeUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class AuthzDeviceHelper
extends BaseHelper {
    private AuthzDeviceHelper() {
        throw new UnsupportedOperationException();
    }

    @NonNull
    public static List<DeviceDetails> getActiveDevices(long ms) {
        return userDevicesDict.listActiveUserDevices(ms);
    }

    @NonNull
    public static List<DeviceDetails> getActiveDevices(String time) {
        return AuthzDeviceHelper.getActiveDevices(TimeUtils.parseTimeValue((String)time));
    }

    @NonNull
    public static List<Object> getActiveUserIdList(@NonNull String time) {
        return AuthzDeviceHelper.getActiveUserIdList(TimeUtils.parseTimeValue((String)time));
    }

    @NonNull
    public static List<Object> getActiveUserIdList(long ms) {
        return AuthzDeviceHelper.getActiveDevices(ms).stream().map(DeviceDetails::getUserId).distinct().collect(Collectors.toList());
    }

    public static boolean checkUserIsActive(@NonNull Object userId, @NonNull String time) {
        return userDevicesDict.listActiveUserDevices(userId, TimeUtils.parseTimeValue((String)time)).size() > 0;
    }

    public static boolean checkUserIsActive(@NonNull Object userId, long ms) {
        return userDevicesDict.listActiveUserDevices(userId, ms).size() > 0;
    }

    @NonNull
    public static List<Object> getAllUserId() {
        return userDevicesDict.listUserId();
    }

    @Nullable
    public static DeviceDetails getDeviceByUserIdAndDeviceTypeAndDeviceId(@NonNull Object userId, @NonNull String deviceType, @Nullable String deviceId) {
        return userDevicesDict.getDevice(userId, deviceType, deviceId);
    }

    @NonNull
    public static List<DeviceDetails> getAllDeviceFromCurrentUser() throws NotLoginException {
        return userDevicesDict.listDevicesByUserId(AuHelper.getUserId());
    }

    @NonNull
    public static List<DeviceDetails> getAllDeviceByUserId(@NonNull Object userId) {
        return userDevicesDict.listDevicesByUserId(userId);
    }

    @NonNull
    public static List<DeviceDetails> getAllDeviceByUserIdAndDeviceType(@NonNull Object userId, @NonNull String deviceType) {
        return userDevicesDict.listDevicesByUserId(userId).stream().filter(device -> device.getDeviceType().equals(deviceType)).collect(Collectors.toList());
    }

    @NonNull
    public static Map<Object, List<DeviceDetails>> getAllUsersDevices() {
        HashMap<Object, List<DeviceDetails>> map = new HashMap<Object, List<DeviceDetails>>();
        AuHelper.getAllUserId().forEach(userId -> map.put(userId, AuthzDeviceHelper.getAllDeviceByUserId(userId)));
        return map;
    }

    public static void addDeviceTypesTotalLimit(@NonNull Collection<String> types, int total) throws NotLoginException {
        AuthzDeviceHelper.addDeviceTypesTotalLimitAt(AuHelper.getUserId(), types, total);
    }

    public static void addDeviceTypesTotalLimitAt(@NonNull Object userId, @NonNull Collection<String> types, int total) {
        userDevicesDict.addDeviceTypesTotalLimit(userId, types, total);
    }

    public static List<DeviceCountInfo> getOrUpdateDeviceTypesTotalLimitAt(@NonNull Object userId) {
        return userDevicesDict.getOrUpdateDeviceTypesTotalLimit(userId);
    }

    public static List<DeviceCountInfo> getOrUpdateDeviceTypesTotalLimit() throws NotLoginException {
        return userDevicesDict.getOrUpdateDeviceTypesTotalLimit(AuHelper.getUserId());
    }

    public static void changeMaximumTotalDevice(int count) throws NotLoginException {
        AuthzDeviceHelper.changeMaximumTotalDeviceAt(AuHelper.getUserId(), count);
    }

    public static void changeMaximumTotalDeviceAt(@NonNull Object userId, int count) {
        userDevicesDict.changeMaximumTotalDevice(userId, count);
    }

    public static void changeMaximumTotalSameTypeDevice(int count) throws NotLoginException {
        AuthzDeviceHelper.changeMaximumTotalSameTypeDeviceAt(AuHelper.getUserId(), count);
    }

    public static void changeMaximumTotalSameTypeDeviceAt(@NonNull Object userId, int count) {
        userDevicesDict.changeMaximumTotalSameTypeDevice(userId, count);
    }
}

