/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.config;

import cn.omisheep.authz.annotation.ArgResource;
import cn.omisheep.authz.annotation.AuthData;
import cn.omisheep.authz.annotation.AuthField;
import cn.omisheep.authz.annotation.AuthzResourcesScan;
import cn.omisheep.authz.annotation.BatchAuthData;
import cn.omisheep.authz.core.auth.rpd.ArgsMeta;
import cn.omisheep.authz.core.auth.rpd.DataPermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.FieldDataPermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.authz.core.util.MetaUtils;
import cn.omisheep.authz.core.util.ScanUtils;
import cn.omisheep.commons.util.ClassUtils;
import cn.omisheep.commons.util.CollectionUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.context.annotation.ImportSelector;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.lang.NonNull;

public class AuthzResourcesInit
implements ImportSelector {
    private Object[] dataPerm(String className) {
        try {
            Class<?> aClass = Class.forName(className);
            ArrayList<AuthData> authDataList = new ArrayList<AuthData>();
            AuthData authData = (AuthData)AnnotationUtils.getAnnotation(aClass, AuthData.class);
            BatchAuthData batchAuthData = (BatchAuthData)AnnotationUtils.getAnnotation(aClass, BatchAuthData.class);
            authDataList.add(authData);
            if (batchAuthData != null) {
                authDataList.addAll(Arrays.asList(batchAuthData.value()));
            }
            List dataPermRolesMetaList = authDataList.stream().filter(Objects::nonNull).map(MetaUtils::generateDataRolesMeta).collect(Collectors.toList());
            return new Object[]{className, dataPermRolesMetaList};
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    @NonNull
    public String[] selectImports(AnnotationMetadata annotationMetadata) {
        Map annotationAttributes = annotationMetadata.getAnnotationAttributes(AuthzResourcesScan.class.getName());
        String[] entityBasePackages = new String[]{};
        if (annotationAttributes != null) {
            entityBasePackages = (String[])annotationAttributes.get("entity");
        }
        Set entityClasses = CollectionUtils.newSet((Object[])ScanUtils.scan(Object.class, entityBasePackages));
        HashMap<String, List<DataPermRolesMeta>> map = new HashMap<String, List<DataPermRolesMeta>>();
        entityClasses.stream().map(this::dataPerm).filter(Objects::nonNull).forEach(o -> map.put((String)o[0], (List)o[1]));
        String[] argsBasePackages = new String[]{};
        if (annotationAttributes != null) {
            argsBasePackages = (String[])annotationAttributes.get("args");
        }
        HashMap<String, ArgsMeta> argMap = new HashMap<String, ArgsMeta>();
        Arrays.stream(argsBasePackages).forEach(basePackage -> ClassUtils.getClassSet((String)basePackage).forEach(type -> Arrays.stream(type.getMethods()).filter(method -> method.isAnnotationPresent(ArgResource.class)).forEach(method -> {
            ArgResource argResource = (ArgResource)AnnotationUtils.getAnnotation((Method)method, ArgResource.class);
            String name = argResource.name();
            if (Objects.equals(name, "")) {
                name = method.getName();
            }
            argMap.put(name, ArgsMeta.of(type, method).setDescription(argResource.description()));
        })));
        PermissionDict.initArgs(entityClasses, this.ge(entityClasses), map, argMap);
        return new String[0];
    }

    private Map<String, Map<String, FieldDataPermRolesMeta>> ge(Set<String> entityClasses) {
        HashMap<String, Map<String, FieldDataPermRolesMeta>> map = new HashMap<String, Map<String, FieldDataPermRolesMeta>>();
        for (String clz : entityClasses) {
            try {
                Class<?> aClass = Class.forName(clz);
                Map fmap = map.computeIfAbsent(clz, r -> new HashMap());
                for (Field field : aClass.getDeclaredFields()) {
                    FieldDataPermRolesMeta fieldDataPermRolesMeta;
                    AuthField authField = (AuthField)AnnotationUtils.getAnnotation((AnnotatedElement)field, AuthField.class);
                    if (authField == null || (fieldDataPermRolesMeta = MetaUtils.generateDataFiledRolesMeta(field.getType().getTypeName(), authField)) == null) continue;
                    fmap.put(field.getName(), fieldDataPermRolesMeta);
                }
            }
            catch (Exception exception) {
            }
        }
        return map;
    }
}

