/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.config;

import cn.omisheep.authz.core.AuthzManager;
import cn.omisheep.authz.core.AuthzProperties;
import cn.omisheep.authz.core.AuthzVersion;
import cn.omisheep.authz.core.msg.AuthzModifier;
import cn.omisheep.authz.core.msg.Message;
import cn.omisheep.authz.core.msg.VersionMessage;
import cn.omisheep.authz.core.util.FormatUtils;
import cn.omisheep.authz.core.util.MD5Utils;
import cn.omisheep.authz.core.util.RedisUtils;
import cn.omisheep.commons.util.Assert;
import cn.omisheep.commons.util.Async;
import cn.omisheep.commons.util.TaskBuilder;
import cn.omisheep.commons.util.TimeUtils;
import java.io.File;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.StringUtils;

public class AuthzAppVersion {
    private static boolean loading = false;
    private static final AtomicInteger version = new AtomicInteger(0);
    private static final ArrayList<AuthzModifier> changeLog = new ArrayList();
    private static final ArrayList<AuthzModifier> cache = new ArrayList();
    private static final Map<String, String> _values = new HashMap<String, String>();
    private static final Map<String, Object> _values_obj = new HashMap<String, Object>();
    public static final Map<String, String> values = Collections.unmodifiableMap(_values);
    public static final Map<String, Object> valuesObject = Collections.unmodifiableMap(_values_obj);
    public static final String srcFolder = new File(Objects.requireNonNull(AuthzVersion.class.getClassLoader().getResource("")).getPath()).toString();
    private static final String osName = System.getProperty("os.name").toLowerCase();
    public static final boolean isMac = osName.contains("mac");
    public static final boolean isWindows = osName.contains("window");
    public static final boolean isLinux = osName.contains("linux");
    public static final String CONNECT_INFO_WITH_SAME_APPLICATION = "connectInfoWithSameApplication";
    public static final String CONNECT_INFO_WITH_SAME_APP_NAME = "connectInfoWithSameAppName";
    public static final String ALL_CONNECT = "all";
    public static final String LOCAL_CONNECT = "local";
    public static Class<?> mainClass = AuthzAppVersion.class;
    public static ConfigurableEnvironment environment;
    public static AuthzProperties properties;
    public static Class<?> USER_ID_TYPE;
    public static Constructor<?> USER_ID_CONSTRUCTOR;
    private static final Supplier<Boolean> md5check;
    public static final Supplier<String> HOST;
    public static Supplier<String> PORT;
    public static Supplier<String> CONTEXT_PATH;
    public static Supplier<String> BASE_URL;
    public static final Supplier<Boolean> SUPPORT_REDIS;
    public static final Supplier<String> APPLICATION_NAME;
    public static final Supplier<String> APP_NAME;
    public static final Supplier<ConnectInfo> CONNECT_INFO;
    public static final Supplier<Long> AUTHORIZATION_CODE_TIME;
    public static final Supplier<String> SCOPE_SEPARATOR;
    private static final Supplier<String> JAR_PATH;
    private static final Supplier<String> JAR_MD5;
    public static final Supplier<Void> init;

    private AuthzAppVersion() {
        throw new UnsupportedOperationException();
    }

    public static boolean isMd5check() {
        return md5check.get();
    }

    public static String getJarMd5() {
        return JAR_MD5.get();
    }

    public static String getJarPath() {
        return JAR_PATH.get();
    }

    public static HashMap<String, Object> getVersion() {
        return (HashMap)_values_obj.computeIfAbsent("CONNECT_VERSION", r -> {
            HashMap<String, Object> v = new HashMap<String, Object>();
            v.put("version", version.get() + "");
            v.put("appName", APP_NAME.get());
            v.put("application", APPLICATION_NAME.get());
            v.put("host", HOST.get());
            v.put("port", PORT.get());
            v.put("contextPath", CONTEXT_PATH.get());
            v.put("baseUrl", BASE_URL.get());
            v.put("dashboardApiHelper", BASE_URL.get() + "/authz-api" + "/v1");
            v.put("dashboardDocs", BASE_URL.get() + "/authz-api" + "/v1" + "/docs");
            v.put("supportCloud", SUPPORT_REDIS.get());
            v.put("os", osName);
            v.put("srcFolder", srcFolder);
            return v;
        });
    }

    public static List<ConnectInfo> listAllConnectInfo() {
        Set<String> scan = RedisUtils.scan("authz:connect:*");
        return RedisUtils.Obj.get(scan);
    }

    public static Map<String, List<ConnectInfo>> getConnectInfo() {
        List connectInfo = AuthzAppVersion.listAllConnectInfo().stream().distinct().collect(Collectors.toList());
        List connectInfoWithSameApplication = connectInfo.stream().filter(c -> ((ConnectInfo)c).application.equals(APPLICATION_NAME.get())).collect(Collectors.toList());
        List connectInfoWithSameAppName = connectInfo.stream().filter(c -> ((ConnectInfo)c).appName.equals(APP_NAME.get())).collect(Collectors.toList());
        List local = connectInfo.stream().filter(c -> ((ConnectInfo)c).appName.equals(APP_NAME.get()) && ((ConnectInfo)c).application.equals(APPLICATION_NAME.get())).collect(Collectors.toList());
        HashMap<String, List<ConnectInfo>> map = new HashMap<String, List<ConnectInfo>>();
        map.put(CONNECT_INFO_WITH_SAME_APPLICATION, connectInfoWithSameApplication);
        map.put(CONNECT_INFO_WITH_SAME_APP_NAME, connectInfoWithSameAppName);
        map.put(LOCAL_CONNECT, local);
        map.put(ALL_CONNECT, connectInfo);
        return map;
    }

    public static void receive(VersionMessage versionMessage) {
        if (versionMessage.isTag()) {
            List<AuthzModifier> authzModifierList;
            if (version.get() == 0 && (authzModifierList = versionMessage.getAuthzModifierList()) != null && versionMessage.getVersion() == authzModifierList.size()) {
                loading = true;
                for (AuthzModifier modifier : authzModifierList) {
                    AuthzAppVersion.receiveCut(modifier);
                    version.incrementAndGet();
                }
                loading = false;
            }
            return;
        }
        if (versionMessage.getVersion() == -1 && !loading) {
            AuthzAppVersion.send();
            return;
        }
        AuthzModifier authzModifier = versionMessage.getAuthzModifier();
        if (authzModifier != null) {
            if (loading) {
                cache.add(authzModifier);
                TaskBuilder.scheduleOnceDelay((Runnable)AuthzAppVersion.task(), (String)"10s");
                return;
            }
            AuthzAppVersion.receiveCut(authzModifier);
            version.incrementAndGet();
            changeLog.add(versionMessage.getAuthzModifier());
        }
    }

    public static Runnable task() {
        return () -> {
            if (loading) {
                TaskBuilder.scheduleOnceDelay((Runnable)AuthzAppVersion.task(), (String)"10s");
            } else {
                cache.forEach(AuthzAppVersion::receiveCut);
                cache.clear();
            }
        };
    }

    public static void receiveCut(AuthzModifier authzModifier) {
        AuthzModifier.Operate operate = authzModifier.getOperate();
        if (AuthzModifier.Operate.READ != operate && AuthzModifier.Operate.GET != operate) {
            AuthzManager.op(authzModifier);
        }
    }

    public static void born() {
        Async.run(() -> RedisUtils.publish(VersionMessage.CHANNEL, new VersionMessage(-1)));
        TaskBuilder.schedule(AuthzAppVersion::ping, (long)25L, (TimeUnit)TimeUnit.SECONDS);
    }

    public static void ping() {
        try {
            RedisUtils.Obj.set("authz:connect:" + Message.uuid, CONNECT_INFO.get(), 30000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void send(AuthzModifier authzModifier) {
        changeLog.add(authzModifier);
        int v = version.incrementAndGet();
        Async.run(() -> RedisUtils.publish(VersionMessage.CHANNEL, new VersionMessage(authzModifier, v)));
    }

    public static void send() {
        Async.run(() -> RedisUtils.publish(VersionMessage.CHANNEL, new VersionMessage(changeLog, version.get()).setTag(true)));
    }

    static {
        md5check = () -> properties.getSys().isMd5check();
        HOST = () -> _values.computeIfAbsent("HOST", r -> {
            try {
                return InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                return "unknown";
            }
        });
        PORT = () -> _values.computeIfAbsent("PORT", r -> Optional.ofNullable(environment.getProperty("server.port")).orElse("unknown"));
        CONTEXT_PATH = () -> _values.computeIfAbsent("CONTEXT_PATH", r -> Optional.ofNullable(environment.getProperty("server.servlet.context-path")).orElse(""));
        BASE_URL = () -> _values.computeIfAbsent("BASE_URL", r -> FormatUtils.format("{}:{}{}", HOST.get(), PORT.get(), CONTEXT_PATH.get()));
        SUPPORT_REDIS = () -> properties.getCache().isEnableRedis();
        APPLICATION_NAME = () -> _values.computeIfAbsent("APPLICATION_NAME", r -> {
            String name = environment.getProperty("spring.application.name");
            return StringUtils.hasText((String)name) ? name : "application";
        });
        APP_NAME = () -> properties.getApp();
        CONNECT_INFO = () -> (ConnectInfo)_values_obj.computeIfAbsent("CONNECT_INFO", r -> {
            ConnectInfo connectInfo = new ConnectInfo();
            connectInfo.setApplication(APPLICATION_NAME.get());
            connectInfo.setAppName(APP_NAME.get());
            connectInfo.setContextPath(CONTEXT_PATH.get());
            connectInfo.setUrl(FormatUtils.format("{}:{}", HOST.get(), HOST.get()));
            connectInfo.setHost(HOST.get());
            connectInfo.setPort(PORT.get());
            if (properties.getDashboard().isEnabled()) {
                String u = BASE_URL.get();
                if (!BASE_URL.get().endsWith("/")) {
                    u = u + "/";
                }
                connectInfo.setDashboard(u + "authz.html");
            }
            return connectInfo;
        });
        AUTHORIZATION_CODE_TIME = () -> (Long)_values_obj.computeIfAbsent("AUTHORIZATION_CODE_TIME", r -> TimeUtils.parseTimeValue((String)properties.getOauth().getAuthorizationCodeTime()));
        SCOPE_SEPARATOR = () -> properties.getOauth().getScopeSeparator();
        JAR_PATH = () -> {
            try {
                return _values.computeIfAbsent("JAR_PATH", r -> new ApplicationHome(mainClass).getSource().getAbsolutePath());
            }
            catch (Exception e) {
                return _values.computeIfAbsent("JAR_PATH", r -> "unknown");
            }
        };
        JAR_MD5 = () -> {
            try {
                return _values.computeIfAbsent("JAR_MD5", r -> MD5Utils.compute(JAR_PATH.get()));
            }
            catch (Exception e) {
                return _values.computeIfAbsent("JAR_MD5", r -> "unknown");
            }
        };
        init = () -> {
            Assert.state((!_values.containsKey("APP") ? 1 : 0) != 0, (String)"APP\u5df2\u521d\u59cb\u5316");
            _values.put("APP", APP_NAME.get());
            _values.put("USER_DEVICE_KEY_PREFIX", "authz:" + APP_NAME.get() + ":user:device:");
            _values.put("USER_REQUEST_KEY_PREFIX", "authz:" + APP_NAME.get() + ":user:request:");
            _values.put("OAUTH_USER_DEVICE_KEY_PREFIX", "authz:" + APP_NAME.get() + ":oauth:user:device:");
            _values.put("ACCESS_INFO_KEY_PREFIX", "authz:" + APP_NAME.get() + ":usersAccessInfo:");
            _values.put("REFRESH_INFO_KEY_PREFIX", "authz:" + APP_NAME.get() + ":usersRefreshInfo:");
            _values.put("PERMISSIONS_BY_ROLE_KEY_PREFIX", "authz:" + APP_NAME.get() + ":permissionsByRole:");
            _values.put("ROLES_BY_USER_KEY_PREFIX", "authz:" + APP_NAME.get() + ":userRoles:");
            _values.put("CLINT_PREFIX", "authz:" + APP_NAME.get() + ":oauth:client:");
            _values.put("AUTHORIZE_CODE_PREFIX", "authz:" + APP_NAME.get() + ":oauth:code:");
            _values.put("DASHBOARD_KEY_PREFIX", "authz:" + APP_NAME.get() + ":dashboard:");
            return null;
        };
    }

    public static class ConnectInfo {
        private String url;
        private String host;
        private String port;
        private String contextPath;
        private String appName;
        private String application;
        private String dashboard;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ConnectInfo)) {
                return false;
            }
            ConnectInfo that = (ConnectInfo)o;
            return new EqualsBuilder().append((Object)this.getUrl(), (Object)that.getUrl()).append((Object)this.getHost(), (Object)that.getHost()).append((Object)this.getPort(), (Object)that.getPort()).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.getUrl()).append((Object)this.getHost()).append((Object)this.getPort()).toHashCode();
        }

        public String getUrl() {
            return this.url;
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }

        public String getContextPath() {
            return this.contextPath;
        }

        public String getAppName() {
            return this.appName;
        }

        public String getApplication() {
            return this.application;
        }

        public String getDashboard() {
            return this.dashboard;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setPort(String port) {
            this.port = port;
        }

        public void setContextPath(String contextPath) {
            this.contextPath = contextPath;
        }

        public void setAppName(String appName) {
            this.appName = appName;
        }

        public void setApplication(String application) {
            this.application = application;
        }

        public void setDashboard(String dashboard) {
            this.dashboard = dashboard;
        }

        public String toString() {
            return "AuthzAppVersion.ConnectInfo(url=" + this.getUrl() + ", host=" + this.getHost() + ", port=" + this.getPort() + ", contextPath=" + this.getContextPath() + ", appName=" + this.getAppName() + ", application=" + this.getApplication() + ", dashboard=" + this.getDashboard() + ")";
        }
    }
}

