/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.config;

import cn.omisheep.authz.core.AuthzContext;
import cn.omisheep.authz.core.AuthzProperties;
import cn.omisheep.authz.core.AuthzVersion;
import cn.omisheep.authz.core.auth.DefaultPermLibrary;
import cn.omisheep.authz.core.auth.PermLibrary;
import cn.omisheep.authz.core.auth.deviced.UserDevicesDict;
import cn.omisheep.authz.core.auth.ipf.Httpd;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.authz.core.cache.Cache;
import cn.omisheep.authz.core.codec.AuthzRSAManager;
import cn.omisheep.authz.core.config.AuInit;
import cn.omisheep.authz.core.config.AuthzAppVersion;
import cn.omisheep.authz.core.config.CallbackInit;
import cn.omisheep.authz.core.config.Pelcron;
import cn.omisheep.authz.core.msg.Message;
import cn.omisheep.authz.core.oauth.OpenAuthDict;
import cn.omisheep.authz.core.oauth.OpenAuthLibrary;
import cn.omisheep.authz.core.schema.ModelParser;
import cn.omisheep.authz.core.util.LogUtils;
import cn.omisheep.commons.util.TaskBuilder;
import java.util.Map;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.servlet.handler.AbstractHandlerMethodMapping;

public class AuCoreInitialization
implements ApplicationContextAware {
    private ApplicationContext ctx;
    private final AuthzProperties properties;
    private final UserDevicesDict userDevicesDict;
    private final PermLibrary permLibrary;
    private final Cache cache;
    private final OpenAuthLibrary openAuthLibrary;

    public AuCoreInitialization(AuthzProperties properties, UserDevicesDict userDevicesDict, PermLibrary permLibrary, OpenAuthLibrary openAuthLibrary, Cache cache) {
        this.properties = properties;
        this.userDevicesDict = userDevicesDict;
        this.cache = cache;
        this.permLibrary = permLibrary;
        this.openAuthLibrary = openAuthLibrary;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.ctx = applicationContext;
        AuthzContext.init(applicationContext);
        this.init();
        CallbackInit.callbackInit(applicationContext);
        this.chechPermLibrary();
        this.printBanner();
    }

    public void printBanner() {
        if (this.properties.isBanner()) {
            AuthzVersion.printBanner();
        }
    }

    public void chechPermLibrary() {
        PermLibrary bean = (PermLibrary)this.ctx.getBean(PermLibrary.class);
        if (bean == null || bean instanceof DefaultPermLibrary) {
            AuInit.log.warn("Not configured PermLibrary. Please implements cn.omisheep.authz.core.auth.PermLibrary");
        }
    }

    public void init() {
        AuthzAppVersion.init.get();
        AbstractHandlerMethodMapping methodMapping = (AbstractHandlerMethodMapping)this.ctx.getBean("requestMappingHandlerMapping");
        Map mapRet = methodMapping.getHandlerMethods();
        PermissionDict.init(this.ctx, this.permLibrary, this.cache, mapRet);
        LogUtils.debug("PermissionDict init success \n", new Object[0]);
        OpenAuthDict.init(this.ctx, mapRet);
        LogUtils.debug("OpenAuthDict init success \n", new Object[0]);
        Httpd.init(this.properties, this.ctx, mapRet);
        LogUtils.debug("Httpd init success \n", new Object[0]);
        this.initRSA();
        if (this.properties.getSys().getGcPeriod() != null) {
            TaskBuilder.schedule(Pelcron::GC, (String)this.properties.getSys().getGcPeriod());
        }
        this.openAuthLibrary.init();
        AuthzAppVersion.USER_ID_TYPE = ModelParser.getUserIdType(this.permLibrary);
        try {
            AuthzAppVersion.USER_ID_CONSTRUCTOR = AuthzAppVersion.USER_ID_TYPE.getConstructor(String.class);
        }
        catch (NoSuchMethodException e) {
            LogUtils.error("\u8bf7\u4fdd\u8bc1UserId\u7684\u7c7b\u6709String\u53c2\u6570\u7684\u6784\u9020\u5668", new Object[0]);
        }
        AuInit.log.info("Started Authz Message id: {}", (Object)Message.uuid);
        this.initVersionInfo();
        if (this.properties.getSys().isMd5check()) {
            AuInit.log.info("project md5 => {}", (Object)AuthzAppVersion.getJarMd5());
        }
    }

    private void initVersionInfo() {
        try {
            if (this.properties.getCache().isEnableRedis()) {
                AuthzAppVersion.born();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initRSA() {
        AuthzRSAManager.setTime(this.properties.getRsa().getRsaKeyRefreshWithPeriod());
        if (this.properties.getRsa().isAuto() && (this.properties.getRsa().getCustomPrivateKey() == null || this.properties.getRsa().getCustomPublicKey() == null)) {
            AuthzRSAManager.setAuto(true);
        } else {
            AuthzRSAManager.setAuto(false);
            AuthzProperties.RSAConfig rsaConfig = this.properties.getRsa();
            AuthzRSAManager.setAuKeyPair(rsaConfig.getCustomPublicKey(), rsaConfig.getCustomPrivateKey());
        }
    }
}

