/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.codec;

import cn.omisheep.authz.core.util.LogUtils;
import cn.omisheep.commons.util.RSAHelper;
import cn.omisheep.commons.util.TaskBuilder;
import java.util.concurrent.ScheduledFuture;

public class AuthzRSAManager {
    private static ScheduledFuture<?> scheduledFuture;
    private static boolean auto;
    private static RSAHelper.RSAKeyPair auKeyPair;
    private static String time;

    private AuthzRSAManager() {
        throw new UnsupportedOperationException();
    }

    public static void setTime(String time) {
        AuthzRSAManager.time = time;
    }

    public static void setAuto(boolean auto) {
        AuthzRSAManager.auto = auto;
        if (auto) {
            if (scheduledFuture != null) {
                scheduledFuture.cancel(true);
            }
            scheduledFuture = TaskBuilder.schedule(AuthzRSAManager::refreshKeyGroup, (String)time);
        }
    }

    public static void setAuKeyPair(String publicKey, String privateKey) {
        if (scheduledFuture != null) {
            scheduledFuture.cancel(true);
            scheduledFuture = null;
        }
        auto = false;
        auKeyPair = new RSAHelper.RSAKeyPair(publicKey, privateKey);
        LogUtils.debug("\u2b07 RSA Key Pair \u2b07 {} \n", auKeyPair);
    }

    public static void refreshKeyGroup() {
        auKeyPair = RSAHelper.genKeyPair();
        LogUtils.debug("\u2b07 RSA Key Pair \u2b07 {} \n", auKeyPair);
    }

    public static String encrypt(String plaintext) {
        return RSAHelper.encrypt((String)plaintext, (String)auKeyPair.getPublicKey());
    }

    public static String decrypt(String encryptSource) {
        return RSAHelper.decrypt((String)encryptSource, (String)auKeyPair.getPrivateKey());
    }

    public static String getPublicKeyString() {
        return auKeyPair.getPublicKey();
    }

    public static String getPrivateKeyString() {
        return auKeyPair.getPrivateKey();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthzRSAManager)) {
            return false;
        }
        AuthzRSAManager other = (AuthzRSAManager)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthzRSAManager;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "AuthzRSAManager()";
    }
}

