/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.cache.library;

import cn.omisheep.authz.core.cache.Cache;
import cn.omisheep.authz.core.cache.library.L2RefreshCacheSupport;
import cn.omisheep.authz.core.config.Constants;
import java.util.HashSet;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class PermLibraryCache {
    private final Cache cache;

    public PermLibraryCache(Cache cache) {
        this.cache = cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* cn.omisheep.authz.core.auth.PermLibrary+.getRolesByUserId(..))")
    public Object aroundRolesByUserId(ProceedingJoinPoint joinPoint) throws Throwable {
        try {
            Object[] args = joinPoint.getArgs();
            L2RefreshCacheSupport.isLibrary.set(Boolean.TRUE);
            if (args.length != 1) {
                Object object = joinPoint.proceed();
                return object;
            }
            Object object = this.handle(Constants.ROLES_BY_USER_KEY_PREFIX.get() + args[0], joinPoint);
            return object;
        }
        finally {
            L2RefreshCacheSupport.isLibrary.set(Boolean.FALSE);
        }
    }

    @Around(value="execution(* cn.omisheep.authz.core.auth.PermLibrary+.getPermissionsByRole(String))")
    public Object aroundPermissionsByRole(ProceedingJoinPoint joinPoint) throws Throwable {
        try {
            L2RefreshCacheSupport.isLibrary.set(Boolean.TRUE);
            Object object = this.handle(Constants.PERMISSIONS_BY_ROLE_KEY_PREFIX.get() + joinPoint.getArgs()[0], joinPoint);
            return object;
        }
        finally {
            L2RefreshCacheSupport.isLibrary.set(Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object handle(String key, ProceedingJoinPoint joinPoint) throws Throwable {
        if (!this.cache.notKey(key)) {
            try {
                Object object = this.cache.get(key);
                return object;
            }
            finally {
                L2RefreshCacheSupport.refresh(key, joinPoint);
            }
        }
        Object result = joinPoint.proceed();
        if (result == null) {
            HashSet set = new HashSet();
            this.cache.set(key, set);
            return set;
        }
        this.cache.set(key, result);
        return result;
    }
}

