/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.cache.library;

import cn.omisheep.authz.core.cache.Cache;
import cn.omisheep.authz.core.cache.library.L2RefreshCacheSupport;
import cn.omisheep.authz.core.config.AuthzAppVersion;
import cn.omisheep.authz.core.config.Constants;
import cn.omisheep.authz.core.oauth.ClientDetails;
import java.util.HashMap;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;

@Aspect
public class OpenAuthLibraryCache {
    private final Cache cache;

    public OpenAuthLibraryCache(Cache cache) {
        this.cache = cache;
    }

    @Around(value="execution(* cn.omisheep.authz.core.oauth.OpenAuthLibrary+.init())")
    public Object aroundInit(ProceedingJoinPoint joinPoint) throws Throwable {
        List initList = (List)joinPoint.proceed();
        HashMap<String, ClientDetails> map = new HashMap<String, ClientDetails>(initList.size());
        for (ClientDetails clientDetails : initList) {
            map.put(Constants.CLINT_PREFIX.get() + clientDetails.getClientId(), clientDetails);
        }
        this.cache.set(map);
        return initList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="execution(* cn.omisheep.authz.core.oauth.OpenAuthLibrary+.getClientById(String))")
    public Object aroundGetClientById(ProceedingJoinPoint joinPoint) throws Throwable {
        String key = Constants.CLINT_PREFIX.get() + joinPoint.getArgs()[0];
        try {
            if (this.cache.notKey(key)) {
                Object result = joinPoint.proceed();
                this.cache.set(key, result);
                Object object = result;
                return object;
            }
            Object object = this.cache.get(key);
            return object;
        }
        finally {
            L2RefreshCacheSupport.refresh(key, joinPoint);
        }
    }

    @Around(value="execution(* cn.omisheep.authz.core.oauth.OpenAuthLibrary+.deleteClientById(String))")
    public Object aroundDeleteClientById(ProceedingJoinPoint joinPoint) throws Throwable {
        this.cache.del(Constants.CLINT_PREFIX.get() + joinPoint.getArgs()[0]);
        return joinPoint.proceed();
    }

    @Around(value="execution(* cn.omisheep.authz.core.oauth.OpenAuthLibrary+.registerClient(cn.omisheep.authz.core.oauth.ClientDetails)))")
    public Object aroundRegisterClient(ProceedingJoinPoint joinPoint) throws Throwable {
        L2RefreshCacheSupport.isLibrary.set(Boolean.TRUE);
        ClientDetails clientDetails = (ClientDetails)joinPoint.getArgs()[0];
        String key = Constants.CLINT_PREFIX.get() + clientDetails.getClientId();
        this.cache.set(key, clientDetails);
        return joinPoint.proceed();
    }

    @Around(value="execution(* cn.omisheep.authz.core.callback.AuthorizationCallback+.createAuthorizationCodeCallback(String,cn.omisheep.authz.core.oauth.AuthorizationInfo)))")
    public Object aroundCreateAuthorizationInfo(ProceedingJoinPoint joinPoint) throws Throwable {
        this.cache.set(Constants.AUTHORIZE_CODE_PREFIX.get() + joinPoint.getArgs()[0], joinPoint.getArgs()[1], AuthzAppVersion.AUTHORIZATION_CODE_TIME.get());
        return joinPoint.proceed();
    }
}

