/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.cache.library;

import cn.omisheep.authz.core.AuthzContext;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.cache.Cache;
import cn.omisheep.authz.core.helper.BaseHelper;
import cn.omisheep.authz.core.util.LogUtils;
import cn.omisheep.commons.util.Async;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.aspectj.lang.ProceedingJoinPoint;

public class L2RefreshCacheSupport
extends BaseHelper {
    static final ThreadLocal<Boolean> isLibrary = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static final ConcurrentHashMap<String, CompletableFuture<?>> refreshCache = new ConcurrentHashMap();

    public static boolean isLibrary() {
        return isLibrary.get();
    }

    public static void refresh(String key, ProceedingJoinPoint joinPoint) {
        CompletableFuture<?> completableFuture = refreshCache.get(key);
        if (completableFuture != null) {
            LogUtils.debug("\u91cd\u590d\u7684\u5237\u65b0\u4efb\u52a1 key : {} ", key);
            if (Async.isSuccessFuture(completableFuture)) {
                refreshCache.remove(key);
            } else {
                LogUtils.debug("\u5237\u65b0\u4efb\u52a1\u672a\u5b8c\u6210 key : {} ", key);
            }
        } else {
            HttpMeta currentHttpMeta = AuthzContext.getCurrentHttpMeta();
            CompletableFuture future = Async.run(() -> {
                try {
                    isLibrary.set(Boolean.TRUE);
                    AuthzContext.httpMeta.set(currentHttpMeta);
                    Object v1 = joinPoint.proceed();
                    Cache.CacheItem item = cache.asRawMap().get(key);
                    if (item == null) {
                        cache.set(key, v1);
                    } else if (!Objects.equals(item.getValue(), v1)) {
                        LogUtils.debug("key : {} new-value : {} old-value : {} ", key, item.getValue(), v1);
                        cache.set(key, v1);
                    }
                }
                catch (Throwable e) {
                    LogUtils.error(e);
                }
                finally {
                    isLibrary.set(Boolean.FALSE);
                }
            });
            refreshCache.put(key, future);
        }
    }
}

