/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.cache;

import cn.omisheep.authz.core.AuthzProperties;
import cn.omisheep.authz.core.cache.Cache;
import cn.omisheep.authz.core.msg.CacheMessage;
import cn.omisheep.authz.core.util.LogUtils;
import cn.omisheep.authz.core.util.RedisUtils;
import cn.omisheep.commons.util.Async;
import cn.omisheep.commons.util.ClassUtils;
import cn.omisheep.commons.util.CollectionUtils;
import cn.omisheep.commons.util.KeyMatchUtils;
import cn.omisheep.commons.util.TimeUtils;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Scheduler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class L2Cache
implements Cache {
    private final LoadingCache<String, Cache.CacheItem> cache;
    private final ConcurrentSkipListSet<String> keyPatterns = new ConcurrentSkipListSet();

    public L2Cache(AuthzProperties properties) {
        Caffeine caffeine = Caffeine.newBuilder().scheduler(Scheduler.systemScheduler()).expireAfter((Expiry)new Cache.CacheExpiry(TimeUtils.parseTimeValue((String)properties.getCache().getExpireAfterCreateTime()), TimeUtils.parseTimeValue((String)properties.getCache().getExpireAfterUpdateTime()), TimeUtils.parseTimeValue((String)properties.getCache().getExpireAfterReadTime())));
        Long cacheMaximumSize = properties.getCache().getCacheMaximumSize();
        if (cacheMaximumSize != null) {
            caffeine.maximumSize(cacheMaximumSize.longValue());
        }
        this.cache = caffeine.build((CacheLoader)new CacheLoader<String, Cache.CacheItem>(){

            public @Nullable Cache.CacheItem load(@NonNull String key) {
                return RedisUtils.Obj.get(key, Cache.CacheItem.class);
            }

            public @NonNull Map<@NonNull String, @NonNull Cache.CacheItem> loadAll(@NonNull Iterable<? extends @NonNull String> keys) {
                ArrayList<String> list = new ArrayList<String>();
                keys.forEach(list::add);
                HashMap<String, Cache.CacheItem> map = new HashMap<String, Cache.CacheItem>();
                List valueList = RedisUtils.Obj.get(list);
                Iterator iterator = valueList.iterator();
                list.forEach(k -> {
                    Cache.CacheItem next = (Cache.CacheItem)iterator.next();
                    if (next == null) {
                        map.put((String)k, new Cache.CacheItem<Object>(null));
                    } else {
                        map.put((String)k, next);
                    }
                });
                return map;
            }
        });
    }

    @Override
    public @NonNull Set<String> keys(@NonNull String pattern) {
        if (!pattern.contains("*") && !pattern.contains("?")) {
            return CollectionUtils.ofSet((Object[])new String[]{pattern});
        }
        Cache.CacheItem cacheItem = (Cache.CacheItem)this.cache.asMap().get(pattern);
        if (cacheItem != null) {
            return (Set)cacheItem.value;
        }
        Set<String> scan = RedisUtils.scan(pattern);
        if (pattern.startsWith("USER_REQUEST")) {
            return scan;
        }
        Async.run(() -> RedisUtils.publish(CacheMessage.CHANNEL, CacheMessage.write(pattern, scan)));
        if (!scan.isEmpty()) {
            this.cache.put((Object)pattern, new Cache.CacheItem<Set<String>>(scan));
            this.keyPatterns.add(pattern);
        }
        return scan;
    }

    @Override
    public @NonNull Set<String> keysAndLoad(String pattern) {
        Set<String> keys = this.keys(pattern);
        if (keys.isEmpty()) {
            return new HashSet<String>();
        }
        Async.run(() -> this.cache.getAll((Iterable)keys));
        return keys;
    }

    @Override
    public boolean notKey(@NonNull String key) {
        return this.cache.get((Object)key) == null;
    }

    @Override
    public long ttl(@NonNull String key) {
        Cache.CacheItem item = (Cache.CacheItem)this.cache.get((Object)key);
        if (item == null) {
            return -2L;
        }
        return item.ttl();
    }

    @Override
    public void expire(@NonNull String key, long ms) {
        Cache.CacheItem item;
        if (ms == 0L || ms < -1L) {
            this.cache.invalidate((Object)key);
        }
        if ((item = (Cache.CacheItem)this.cache.get((Object)key)) != null) {
            item.expiration = TimeUtils.nowTime() + ms;
            RedisUtils.expire(key, ms);
        }
    }

    @Override
    public <E> void set(@NonNull String key, @Nullable E element, long ttl) {
        this.setSneaky(key, element, ttl);
        Async.run(() -> RedisUtils.publish(CacheMessage.CHANNEL, CacheMessage.write(key)));
    }

    @Override
    public void set(@NonNull Map<String, ?> elements) {
        HashMap items = new HashMap();
        elements.forEach((k, v) -> items.put(k, new Cache.CacheItem<Object>(v)));
        this.cache.putAll(items);
        Async.run(() -> {
            this.removePatterns(elements.keySet());
            RedisUtils.Obj.set(items);
            RedisUtils.publish(CacheMessage.CHANNEL, CacheMessage.write(items.keySet()));
        });
    }

    @Override
    public <E> void setSneaky(@NonNull String key, @Nullable E element) {
        this.setSneaky(key, element, -1L);
    }

    @Override
    public <E> void setSneaky(@NonNull String key, @Nullable E element, long number, @NonNull TimeUnit unit) {
        this.setSneaky(key, element, unit.toMillis(number));
    }

    @Override
    public <E> void setSneaky(@NonNull String key, @Nullable E element, long ms) {
        if (ms < -1L || ms == 0L) {
            return;
        }
        try {
            Cache.CacheItem item = new Cache.CacheItem(ms, element);
            Async.run(() -> {
                this.removePatterns(key);
                if (ms == -1L) {
                    RedisUtils.Obj.update(key, item);
                } else {
                    RedisUtils.Obj.set(key, item, ms);
                }
            });
            this.cache.put((Object)key, item);
        }
        catch (Exception e) {
            LogUtils.error(e);
        }
    }

    @Override
    public @Nullable Object get(String key) {
        this.cache.refresh((Object)key);
        Cache.CacheItem item = (Cache.CacheItem)this.cache.get((Object)key);
        return item != null ? item.value : null;
    }

    @Override
    public @NonNull Map<String, Object> get(Set<String> keys) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (keys.isEmpty()) {
            return map;
        }
        this.cache.getAll(keys).forEach((k, v) -> {
            this.cache.refresh(k);
            map.put((String)k, v.value);
        });
        return map;
    }

    @Override
    public <T> @NonNull Map<String, T> get(@NonNull Set<String> keys, @NonNull Class<T> requiredType) {
        HashMap map = new HashMap();
        if (keys.isEmpty()) {
            return map;
        }
        Map items = this.cache.getAll(keys);
        items.forEach((k, v) -> {
            this.cache.refresh(k);
            if (v.value == null) {
                map.put(k, null);
            } else {
                map.put(k, ClassUtils.castValue((Object)v.value, (Class)requiredType));
            }
        });
        return map;
    }

    @Override
    public void del(@NonNull String key) {
        this.cache.invalidate((Object)key);
        Async.run(() -> {
            this.removePatterns(key);
            RedisUtils.Obj.del(key);
            RedisUtils.publish(CacheMessage.CHANNEL, CacheMessage.delete(key));
        });
    }

    @Override
    public void del(@NonNull Set<String> keys) {
        if (keys.isEmpty()) {
            return;
        }
        this.cache.invalidateAll(keys);
        Async.run(() -> {
            RedisUtils.Obj.del(keys);
            RedisUtils.publish(CacheMessage.CHANNEL, CacheMessage.delete(keys));
            this.removePatterns(keys);
        });
    }

    @Override
    public void receive(@NonNull CacheMessage message) {
        if (CacheMessage.Type.WRITE.equals((Object)message.getType())) {
            this.setSync(message);
        } else {
            this.delSync(message.getKeys());
        }
    }

    private void setSync(CacheMessage message) {
        Set<String> keys = message.getKeys();
        String pattern = message.getPattern();
        if (pattern != null) {
            this.cache.put((Object)pattern, new Cache.CacheItem<Set<String>>(keys));
        } else {
            if (keys == null) {
                return;
            }
            this.removePatterns(keys);
            HashMap map = new HashMap();
            List valueList = RedisUtils.Obj.get(keys);
            Iterator iterator = valueList.iterator();
            keys.forEach(k -> {
                Cache.CacheItem next = (Cache.CacheItem)iterator.next();
                if (next == null) {
                    this.removePatterns((String)k);
                }
                map.put(k, next);
            });
            this.cache.putAll(map);
        }
    }

    private void delSync(Set<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        this.removePatterns(keys);
        this.cache.invalidateAll(keys);
    }

    @Override
    public void reload() {
        this.reload(this.cache.asMap().keySet().toArray(new String[0]));
    }

    @Override
    public void reload(String ... keys) {
        if (keys == null || keys.length == 0) {
            return;
        }
        List<String> list = Arrays.asList(keys);
        list.forEach(arg_0 -> this.cache.refresh(arg_0));
    }

    @Override
    public @NonNull Map<String, Object> asMap() {
        HashMap map = new HashMap();
        for (Map.Entry e : this.cache.asMap().entrySet()) {
            map.put(e.getKey(), ((Cache.CacheItem)e.getValue()).value);
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public @NonNull Map<String, Cache.CacheItem> asRawMap() {
        return Collections.unmodifiableMap(this.cache.asMap());
    }

    private void removePatterns(String key) {
        List list = KeyMatchUtils.matchPatterns((String)key, this.keyPatterns);
        list.forEach(this.keyPatterns::remove);
        this.cache.invalidateAll((Iterable)list);
    }

    private void removePatterns(Set<String> keys) {
        List list = KeyMatchUtils.matchPatterns(keys, this.keyPatterns);
        list.forEach(this.keyPatterns::remove);
        this.cache.invalidateAll((Iterable)list);
    }
}

