/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.cache;

import cn.omisheep.authz.core.cache.Cache;
import cn.omisheep.commons.util.ClassUtils;
import cn.omisheep.commons.util.KeyMatchUtils;
import cn.omisheep.commons.util.TimeUtils;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.Scheduler;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class L1Cache
implements Cache {
    private final com.github.benmanes.caffeine.cache.Cache<String, Cache.CacheItem> cache;

    public L1Cache(Long maximumSize, String expireAfterCreateTime, String expireAfterUpdateTime, String expireAfterReadTime) {
        Caffeine caffeine = Caffeine.newBuilder().scheduler(Scheduler.systemScheduler()).expireAfter((Expiry)new Cache.CacheExpiry(TimeUtils.parseTimeValue((String)expireAfterCreateTime), TimeUtils.parseTimeValue((String)expireAfterUpdateTime), TimeUtils.parseTimeValue((String)expireAfterReadTime)));
        this.cache = maximumSize == null ? caffeine.build() : caffeine.maximumSize(maximumSize.longValue()).build();
    }

    public L1Cache() {
        this.cache = Caffeine.newBuilder().scheduler(Scheduler.systemScheduler()).expireAfter((Expiry)new Cache.CacheExpiry()).build();
    }

    @Override
    public @NonNull Set<String> keys(@NonNull String pattern) {
        if (pattern.equals("")) {
            return new HashSet<String>();
        }
        if (pattern.equals("*")) {
            return this.cache.asMap().keySet();
        }
        return this.cache.asMap().keySet().stream().filter(key -> KeyMatchUtils.stringMatch((String)pattern, (String)key, (boolean)true)).collect(Collectors.toSet());
    }

    @Override
    public boolean notKey(@NonNull String key) {
        return this.cache.getIfPresent((Object)key) == null;
    }

    @Override
    public long ttl(@NonNull String key) {
        Cache.CacheItem item = (Cache.CacheItem)this.cache.getIfPresent((Object)key);
        if (item == null) {
            return -2L;
        }
        return item.ttl();
    }

    @Override
    public <E> void set(@NonNull String key, @Nullable E element, long ttl) {
        this.cache.put((Object)key, new Cache.CacheItem<E>(ttl, element));
    }

    @Override
    public void set(@NonNull Map<String, ?> elements) {
        elements.forEach((k, v) -> this.cache.put(k, new Cache.CacheItem<Object>(v)));
    }

    @Override
    public void expire(@NonNull String key, long ms) {
        Cache.CacheItem item;
        if (ms == 0L || ms < -1L) {
            this.cache.invalidate((Object)key);
        }
        if ((item = (Cache.CacheItem)this.cache.getIfPresent((Object)key)) != null) {
            item.expiration = TimeUtils.nowTime() + ms;
        }
    }

    @Override
    public Object get(String key) {
        Cache.CacheItem item = (Cache.CacheItem)this.cache.getIfPresent((Object)key);
        return item == null ? null : item.value;
    }

    @Override
    public @NonNull Map<String, Object> get(Set<String> keys) {
        return new HashMap<String, Object>(this.cache.getAllPresent(keys));
    }

    @Override
    public <T> @NonNull Map<String, T> get(@NonNull Set<String> keys, @NonNull Class<T> requiredType) {
        HashMap map = new HashMap();
        Map items = this.cache.getAllPresent(keys);
        items.forEach((k, v) -> {
            if (v.value == null) {
                map.put(k, null);
            } else {
                map.put(k, ClassUtils.castValue((Object)v.value, (Class)requiredType));
            }
        });
        return map;
    }

    @Override
    public void del(@NonNull String key) {
        this.cache.invalidate((Object)key);
    }

    @Override
    public void del(@NonNull Set<String> keys) {
        this.cache.invalidateAll(keys);
    }

    @Override
    public @NonNull Map<String, Object> asMap() {
        HashMap map = new HashMap();
        for (Map.Entry e : this.cache.asMap().entrySet()) {
            map.put(e.getKey(), ((Cache.CacheItem)e.getValue()).value);
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public @NonNull Map<String, Cache.CacheItem> asRawMap() {
        return Collections.unmodifiableMap(this.cache.asMap());
    }
}

