/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.rpd;

import cn.omisheep.authz.annotation.Auth;
import cn.omisheep.authz.annotation.AuthParam;
import cn.omisheep.authz.annotation.BatchAuthParam;
import cn.omisheep.authz.annotation.Certificated;
import cn.omisheep.authz.annotation.IPRangeLimit;
import cn.omisheep.authz.core.auth.PermLibrary;
import cn.omisheep.authz.core.auth.ipf.Httpd;
import cn.omisheep.authz.core.auth.ipf.LimitMeta;
import cn.omisheep.authz.core.auth.rpd.ArgsMeta;
import cn.omisheep.authz.core.auth.rpd.DataPermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.FieldDataPermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.ParamMetadata;
import cn.omisheep.authz.core.auth.rpd.ParamPermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.Rule;
import cn.omisheep.authz.core.cache.Cache;
import cn.omisheep.authz.core.config.AuInit;
import cn.omisheep.authz.core.config.AuthzAppVersion;
import cn.omisheep.authz.core.config.Constants;
import cn.omisheep.authz.core.msg.AuthzModifier;
import cn.omisheep.authz.core.schema.Model;
import cn.omisheep.authz.core.schema.ModelParser;
import cn.omisheep.authz.core.util.MetaUtils;
import cn.omisheep.authz.core.util.RedisUtils;
import cn.omisheep.authz.core.util.ValueMatcher;
import cn.omisheep.authz.support.util.IPRange;
import cn.omisheep.authz.support.util.IPRangeMeta;
import cn.omisheep.commons.util.Async;
import cn.omisheep.web.entity.Result;
import cn.omisheep.web.entity.ResultCode;
import cn.omisheep.web.entity.ResultMap;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.springframework.boot.autoconfigure.web.servlet.error.BasicErrorController;
import org.springframework.context.ApplicationContext;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class PermissionDict {
    private static final Map<String, List<Map<String, String>>> _controllerMetadata = new HashMap<String, List<Map<String, String>>>();
    private static final Map<String, Map<String, PermRolesMeta>> _authzMetadata = new HashMap<String, Map<String, PermRolesMeta>>();
    private static final Map<String, PermRolesMeta> _authzControllerMetadata = new HashMap<String, PermRolesMeta>();
    private static final Map<String, String> _controllerNameMap = new HashMap<String, String>();
    private static final Set<String> _certificatedControllerMetadata = new HashSet<String>();
    private static final Map<String, Map<String, Map<String, ParamMetadata>>> _authzParamMetadata = new HashMap<String, Map<String, Map<String, ParamMetadata>>>();
    private static final Map<String, Set<String>> _certificatedMetadata = new HashMap<String, Set<String>>();
    private static final Map<String, ArgsMeta> _argsMetadata = new HashMap<String, ArgsMeta>();
    private static final Map<String, List<DataPermRolesMeta>> _dataPermMetadata = new HashMap<String, List<DataPermRolesMeta>>();
    private static final Map<String, Map<String, FieldDataPermRolesMeta>> _fieldMetadata = new HashMap<String, Map<String, FieldDataPermRolesMeta>>();
    private static final Map<String, Map<String, IPRangeMeta>> _ipRangeMeta = new HashMap<String, Map<String, IPRangeMeta>>();
    private static final Map<String, Model> _authzResourcesModel = new HashMap<String, Model>();
    private static boolean _supportNative;
    private static final Set<IPRange> _globalAllow;
    private static final Set<IPRange> _globalDeny;
    private static final Map<String, Set<String>> certificatedMetadata;
    private static final Set<String> controllerCertificatedMetadata;
    private static final Map<String, Map<String, PermRolesMeta>> rolePermission;
    private static final Map<String, PermRolesMeta> controllerRolePermission;
    private static final Map<String, Map<String, Map<String, ParamMetadata>>> paramPermission;
    private static final Map<String, Model> authzResourcesModel;
    private static final Map<String, List<DataPermRolesMeta>> dataPermission;
    private static final Map<String, Map<String, FieldDataPermRolesMeta>> fieldsData;
    private static final Map<String, ArgsMeta> args;
    private static final Map<String, Map<String, IPRangeMeta>> iPRange;
    private static final Set<IPRange> globalAllow;
    private static final Set<IPRange> globalDeny;
    private static final Map<String, List<Map<String, String>>> controllerMetadata;
    private static final ReentrantLock lock;
    private static String permSeparator;
    private static boolean isInit;

    public static boolean isSupportNative() {
        return _supportNative;
    }

    public static String getControllerBeanName(String typeName) {
        return _controllerNameMap.get(typeName);
    }

    public static void putParam(String api, String method, String name, ParamMetadata paramMetadata) {
        _authzParamMetadata.computeIfAbsent(api, r -> new HashMap()).computeIfAbsent(method, r -> new HashMap()).computeIfAbsent(name, r -> paramMetadata).setParamMetaList(paramMetadata.getParamMetaList());
    }

    public static void putParam(String api, String method) {
        _authzParamMetadata.computeIfAbsent(api, r -> new HashMap()).computeIfAbsent(method, r -> new HashMap());
    }

    @Nullable
    public static Object modify(@NonNull AuthzModifier authzModifier) {
        if (authzModifier.getTarget() == null) {
            return PermissionDict.modifyParam(authzModifier);
        }
        switch (authzModifier.getTarget()) {
            case API: 
            case LOGIN: {
                return PermissionDict.modifyAPI(authzModifier);
            }
            case PARAMETER: {
                return PermissionDict.modifyParam(authzModifier);
            }
            case DATA_ROW: 
            case DATA_COL: {
                return PermissionDict.modifyData(authzModifier);
            }
            case NON: {
                return null;
            }
        }
        return null;
    }

    private static Result returnObj(String api, String method) {
        PermRolesMeta _v = null;
        try {
            _v = _authzMetadata.get(api).get(method);
        }
        catch (Exception exception) {
            // empty catch block
        }
        boolean k = false;
        try {
            k = _certificatedMetadata.get(api).contains(method);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Map<String, ParamMetadata> paramAuth = null;
        boolean hasParamAuth = false;
        try {
            paramAuth = _authzParamMetadata.get(api).get(method);
            hasParamAuth = paramAuth != null && !paramAuth.isEmpty() && paramAuth.values().stream().anyMatch(ParamMetadata::hasParamAuth);
            k = k || hasParamAuth;
        }
        catch (Exception exception) {
            // empty catch block
        }
        LimitMeta rateLimit = null;
        try {
            rateLimit = Httpd.getRateLimitMetadata().get(api).get(method);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (_v != null) {
            return Result.SUCCESS.data("auth", (Object)_v).data("hasAuth", (Object)(!_v.non() ? 1 : 0)).data("requireLogin", (Object)(!_v.non() || k ? 1 : 0)).data("paramAuth", paramAuth).data("rateLimit", (Object)rateLimit).data("hasRateLimit", (Object)(rateLimit != null ? 1 : 0)).data("hasParamAuth", (Object)hasParamAuth);
        }
        return Result.SUCCESS.data("auth", null).data("hasAuth", (Object)false).data("paramAuth", paramAuth).data("rateLimit", (Object)rateLimit).data("hasRateLimit", (Object)(rateLimit != null ? 1 : 0)).data("hasParamAuth", (Object)hasParamAuth).data("requireLogin", (Object)k);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object modifyAPI(AuthzModifier authzModifier) {
        lock.lock();
        String api = authzModifier.getApi();
        String method = authzModifier.getMethod();
        try {
            Object controller;
            block56: {
                boolean login;
                block54: {
                    block57: {
                        block55: {
                            if (!AuthzModifier.Target.LOGIN.equals((Object)authzModifier.getTarget())) break block56;
                            try {
                                login = (Boolean)authzModifier.getValue();
                                controller = authzModifier.getController();
                                if (controller == null) break block54;
                                if (!_controllerMetadata.containsKey(controller)) {
                                    Result result = Result.FAIL.data();
                                    return result;
                                }
                                if (!login) break block55;
                                _certificatedControllerMetadata.add((String)controller);
                            }
                            catch (Exception e) {
                                controller = Result.FAIL.data();
                                return controller;
                            }
                            break block57;
                        }
                        _certificatedControllerMetadata.remove(controller);
                    }
                    Result result = Result.SUCCESS.data();
                    return result;
                }
                if (login) {
                    _certificatedMetadata.computeIfAbsent(api, r -> new HashSet()).add(method);
                } else {
                    try {
                        boolean hasAuth;
                        Map<String, ParamMetadata> paramAuth = _authzParamMetadata.get(api).get(method);
                        boolean hasParamAuth = paramAuth != null && !paramAuth.isEmpty() && paramAuth.values().stream().anyMatch(ParamMetadata::hasParamAuth);
                        Map<String, PermRolesMeta> metaMap = _authzMetadata.get(api);
                        if (metaMap == null) {
                            hasAuth = false;
                        } else {
                            PermRolesMeta meta = metaMap.get(method);
                            boolean bl = hasAuth = meta != null && !meta.non();
                        }
                        if (hasAuth || hasParamAuth) {
                            Result result = Result.FAIL.data();
                            return result;
                        }
                    }
                    catch (Exception e) {
                        Result hasParamAuth = Result.FAIL.data();
                        return hasParamAuth;
                    }
                    if (_certificatedMetadata.containsKey(api)) {
                        _certificatedMetadata.get(api).remove(method);
                    }
                }
                Result e = Result.SUCCESS.data();
                return e;
            }
            switch (authzModifier.getOperate()) {
                case ADD: 
                case MODIFY: 
                case UPDATE: {
                    Map<String, PermRolesMeta> metaMap;
                    PermRolesMeta build = authzModifier.build();
                    controller = authzModifier.getController();
                    if (controller != null) {
                        if (!_controllerMetadata.containsKey(controller)) {
                            Result e = Result.FAIL.data();
                            return e;
                        }
                        if (build == null || build.non()) {
                            _authzControllerMetadata.remove(controller);
                            ResultMap e = Result.SUCCESS.data("auth", (Object)new PermRolesMeta()).data("hasAuth", (Object)false);
                            return e;
                        }
                        _authzControllerMetadata.put((String)controller, build);
                        ResultMap e = Result.SUCCESS.data("auth", (Object)build).data("hasAuth", (Object)(!build.non() ? 1 : 0));
                        return e;
                    }
                    if (build != null) {
                        _authzMetadata.computeIfAbsent(api, r -> new HashMap()).computeIfAbsent(authzModifier.getMethod(), r -> new PermRolesMeta()).clear().merge(build);
                    }
                    if ((metaMap = _authzMetadata.get(api)) != null) {
                        PermRolesMeta permRolesMeta = metaMap.get(method);
                        if (permRolesMeta != null) {
                            if (build == null) {
                                permRolesMeta.clear();
                            }
                            if (permRolesMeta.non()) {
                                metaMap.remove(method);
                            }
                        }
                        if (metaMap.isEmpty()) {
                            _authzMetadata.remove(api);
                        }
                    }
                    Result result = PermissionDict.returnObj(api, method);
                    return result;
                }
                case DELETE: 
                case DEL: {
                    String controller2 = authzModifier.getController();
                    if (controller2 != null) {
                        if (!_controllerMetadata.containsKey(controller2)) {
                            Result result = Result.FAIL.data();
                            return result;
                        }
                        _authzControllerMetadata.remove(controller2);
                        ResultMap resultMap = Result.SUCCESS.data("auth", null).data("hasAuth", (Object)false);
                        return resultMap;
                    }
                    _authzMetadata.get(api).get(method).clear();
                    if (_authzMetadata.get(api).get(method).non()) {
                        _authzMetadata.get(api).remove(method);
                    }
                    if (_authzMetadata.get(api).isEmpty()) {
                        _authzMetadata.remove(api);
                    }
                    Result result = PermissionDict.returnObj(api, method);
                    return result;
                }
                case GET: 
                case READ: {
                    if (api == null && method == null) {
                        Map<String, Map<String, PermRolesMeta>> controller2 = rolePermission;
                        return controller2;
                    }
                    if (api == null) {
                        List controller2 = rolePermission.values().stream().filter(stringPermRolesMetaMap -> stringPermRolesMetaMap.containsKey(authzModifier.getMethod())).map(stringPermRolesMetaMap -> (PermRolesMeta)stringPermRolesMetaMap.get(authzModifier.getMethod())).collect(Collectors.toList());
                        return controller2;
                    }
                    if (method == null) {
                        Map<String, PermRolesMeta> controller2 = rolePermission.get(authzModifier.getApi());
                        return controller2;
                    }
                    PermRolesMeta controller2 = rolePermission.get(api).get(method);
                    return controller2;
                }
            }
            ResultCode controller2 = Result.FAIL;
            return controller2;
        }
        catch (Exception e) {
            ResultCode resultCode = Result.FAIL;
            return resultCode;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object modifyParam(AuthzModifier authzModifier) {
        lock.lock();
        try {
            int index = authzModifier.getIndex();
            String path = authzModifier.getApi();
            String method = authzModifier.getMethod();
            String name = (String)authzModifier.getValue();
            switch (authzModifier.getOperate()) {
                case ADD: 
                case MODIFY: 
                case UPDATE: {
                    ParamMetadata paramMetadata = _authzParamMetadata.get(path).get(method).get(name);
                    PermRolesMeta build = authzModifier.build();
                    if (paramMetadata.getParamMetaList() == null) {
                        if (build != null && !build.non()) {
                            ParamPermRolesMeta meta = new ParamPermRolesMeta().setRange(authzModifier.getRange()).setResources(authzModifier.getResources()).merge(build);
                            if (!meta.non()) {
                                paramMetadata.setParamMetaList(new ArrayList<ParamPermRolesMeta>());
                                paramMetadata.getParamMetaList().add(meta);
                                Result result = Result.SUCCESS.data((Object)meta);
                                return result;
                            }
                            Result result = Result.FAIL.data();
                            return result;
                        }
                        Result meta = Result.FAIL.data();
                        return meta;
                    }
                    ParamPermRolesMeta meta = new ParamPermRolesMeta().merge(build).setRange(authzModifier.getRange()).setResources(authzModifier.getResources());
                    if (meta.non()) {
                        paramMetadata.getParamMetaList().remove(index);
                        if (paramMetadata.getParamMetaList().isEmpty()) {
                            paramMetadata.setParamMetaList(null);
                        }
                        Result result = Result.FAIL.data();
                        return result;
                    }
                    if (paramMetadata.getParamMetaList().size() <= index) {
                        paramMetadata.getParamMetaList().add(meta);
                    } else {
                        paramMetadata.getParamMetaList().set(index, meta);
                    }
                    Result result = Result.SUCCESS.data((Object)meta);
                    return result;
                }
                case DELETE: 
                case DEL: {
                    ParamMetadata paramMetadata = _authzParamMetadata.get(path).get(method).get(name);
                    if (paramMetadata.getParamMetaList() == null || paramMetadata.getParamMetaList().size() <= index) {
                        ResultCode resultCode = Result.SUCCESS;
                        return resultCode;
                    }
                    paramMetadata.getParamMetaList().remove(index);
                    if (paramMetadata.getParamMetaList().isEmpty()) {
                        paramMetadata.setParamMetaList(null);
                    }
                    ResultCode resultCode = Result.SUCCESS;
                    return resultCode;
                }
            }
            ResultCode resultCode = Result.SUCCESS;
            return resultCode;
        }
        catch (Exception e) {
            ResultCode resultCode = Result.FAIL;
            return resultCode;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object modifyData(AuthzModifier authzModifier) {
        Object object;
        try {
            lock.lock();
            String className = authzModifier.getClassName();
            if (className == null) {
                if (authzModifier.getTarget() == AuthzModifier.Target.DATA_COL) {
                    Map<String, Map<String, FieldDataPermRolesMeta>> map = fieldsData;
                    return map;
                }
                if (authzModifier.getTarget() == AuthzModifier.Target.DATA_ROW) {
                    Map<String, List<DataPermRolesMeta>> map = dataPermission;
                    return map;
                }
                ResultCode resultCode = Result.FAIL;
                return resultCode;
            }
            if (authzResourcesModel.get(className) == null) {
                ResultCode resultCode = Result.FAIL;
                return resultCode;
            }
            if (authzModifier.getTarget() == AuthzModifier.Target.DATA_ROW) {
                Object dataPermRolesMeta;
                switch (authzModifier.getOperate()) {
                    case ADD: {
                        Rule rule = authzModifier.getRule();
                        dataPermRolesMeta = rule == null ? DataPermRolesMeta.of(authzModifier.getCondition()) : DataPermRolesMeta.of(rule);
                        PermRolesMeta build = authzModifier.build();
                        ((PermRolesMeta)dataPermRolesMeta).setRoles(build.roles);
                        ((PermRolesMeta)dataPermRolesMeta).setPermissions(build.permissions);
                        ((DataPermRolesMeta)dataPermRolesMeta).setArgsMap(authzModifier.getArgsMap());
                        _dataPermMetadata.computeIfAbsent(className, r -> new ArrayList()).add(dataPermRolesMeta);
                        break;
                    }
                    case MODIFY: 
                    case UPDATE: {
                        if (authzModifier.getIndex() == null) {
                            ResultCode resultCode = Result.FAIL;
                            return resultCode;
                        }
                        if (_dataPermMetadata.get(className) == null) {
                            ResultCode resultCode = Result.FAIL;
                            return resultCode;
                        }
                        DataPermRolesMeta old_data_mata = _dataPermMetadata.get(className).get(authzModifier.getIndex());
                        DataPermRolesMeta new_data_mata = null;
                        if (authzModifier.getCondition() != null) {
                            new_data_mata = DataPermRolesMeta.of(authzModifier.getCondition());
                        }
                        if (authzModifier.getRule() != null) {
                            new_data_mata = DataPermRolesMeta.of(authzModifier.getRule());
                        }
                        if (new_data_mata != null) {
                            old_data_mata.setRule(new_data_mata.getRule());
                            old_data_mata.setCondition(new_data_mata.getCondition());
                        }
                        PermRolesMeta build_new = authzModifier.build();
                        if (build_new.roles != null) {
                            old_data_mata.setRoles(build_new.roles);
                        }
                        if (build_new.permissions != null) {
                            old_data_mata.setPermissions(build_new.permissions);
                        }
                        if (authzModifier.getArgsMap() == null) break;
                        old_data_mata.setArgsMap(authzModifier.getArgsMap());
                        break;
                    }
                    case DELETE: 
                    case DEL: {
                        Integer index = authzModifier.getIndex();
                        if (_dataPermMetadata.get(className) == null) {
                            ResultCode resultCode = Result.FAIL;
                            return resultCode;
                        }
                        if (index == null) {
                            _dataPermMetadata.get(className).clear();
                            break;
                        }
                        _dataPermMetadata.get(className).remove(index);
                        break;
                    }
                    case GET: 
                    case READ: {
                        if (_dataPermMetadata.get(className) == null) {
                            Map<String, List<DataPermRolesMeta>> map = dataPermission;
                            return map;
                        }
                        if (authzModifier.getIndex() == null) {
                            List<DataPermRolesMeta> list = dataPermission.get(className);
                            return list;
                        }
                        DataPermRolesMeta dataPermRolesMeta2 = dataPermission.get(className).get(authzModifier.getIndex());
                        return dataPermRolesMeta2;
                    }
                    default: {
                        ResultCode resultCode = Result.FAIL;
                        return resultCode;
                    }
                }
                dataPermRolesMeta = dataPermission.get(className);
                return dataPermRolesMeta;
            }
            switch (authzModifier.getOperate()) {
                case ADD: {
                    if (authzModifier.getFieldName() == null) {
                        ResultCode dataPermRolesMeta = Result.FAIL;
                        return dataPermRolesMeta;
                    }
                    Object build = authzModifier.build();
                    FieldDataPermRolesMeta fieldData = FieldDataPermRolesMeta.of(className, (PermRolesMeta)build);
                    _fieldMetadata.computeIfAbsent(className, r -> new HashMap()).put(authzModifier.getFieldName(), fieldData);
                }
                case MODIFY: 
                case UPDATE: {
                    Object build;
                    if (authzModifier.getFieldName() == null) {
                        build = Result.FAIL;
                        return build;
                    }
                    build = authzModifier.build();
                    FieldDataPermRolesMeta fieldData = FieldDataPermRolesMeta.of(className, (PermRolesMeta)build);
                    FieldDataPermRolesMeta fd = _fieldMetadata.computeIfAbsent(className, r -> new HashMap()).computeIfAbsent(authzModifier.getFieldName(), r -> new FieldDataPermRolesMeta(className));
                    if (fieldData.getPermissions() != null) {
                        fd.setPermissions(fieldData.getPermissions());
                    }
                    if (fieldData.getRoles() != null) {
                        fd.setRoles(fieldData.getRoles());
                    }
                }
                case GET: 
                case READ: {
                    object = fieldsData.get(authzModifier.getFieldName());
                    return object;
                }
                case DELETE: 
                case DEL: {
                    if (authzModifier.getFieldName() == null) {
                        _fieldMetadata.remove(className);
                    } else {
                        _fieldMetadata.get(className).remove(authzModifier.getFieldName());
                    }
                    ResultCode resultCode = Result.SUCCESS;
                    return resultCode;
                }
            }
            ResultCode resultCode = Result.FAIL;
            return resultCode;
        }
        catch (Exception e) {
            object = Result.FAIL;
            return object;
        }
        finally {
            lock.unlock();
        }
    }

    public static void setPermSeparator(String permSeparator) {
        PermissionDict.permSeparator = permSeparator;
    }

    public static String getPermSeparator() {
        return permSeparator;
    }

    private PermissionDict() {
        throw new UnsupportedOperationException();
    }

    public static void initArgs(Set<String> authzResourcesNames, Map<String, Map<String, FieldDataPermRolesMeta>> fieldMetadata, HashMap<String, List<DataPermRolesMeta>> map, HashMap<String, ArgsMeta> args) {
        for (String authzResourcesName : authzResourcesNames) {
            try {
                _authzResourcesModel.put(authzResourcesName, ModelParser.parse(Class.forName(authzResourcesName)));
            }
            catch (Exception exception) {}
        }
        _fieldMetadata.putAll(fieldMetadata);
        _dataPermMetadata.putAll(map);
        _argsMetadata.putAll(args);
    }

    public static void init(ApplicationContext applicationContext, PermLibrary permLibrary, Cache cache, Map<RequestMappingInfo, HandlerMethod> mapRet) {
        if (isInit) {
            AuInit.log.error("PermissionDict\u5df2\u521d\u59cb\u5316");
        }
        isInit = true;
        PermissionDict.setPermSeparator(",");
        HashSet toBeLoadedRoles = new HashSet();
        HashMap iMap = new HashMap();
        applicationContext.getBeansWithAnnotation(Controller.class).forEach((k, v) -> _controllerNameMap.put(MetaUtils.getTypeName(v), (String)k));
        applicationContext.getBeansWithAnnotation(Auth.class).forEach((key, value) -> {
            PermRolesMeta permRolesMeta;
            if (!MetaUtils.isController(value)) {
                return;
            }
            Set<Auth> auths = MetaUtils.getAnnotations(value, Auth.class);
            if (auths != null && (permRolesMeta = MetaUtils.generatePermRolesMeta(auths)) != null && !permRolesMeta.non()) {
                _authzControllerMetadata.put((String)key, permRolesMeta);
            }
        });
        applicationContext.getBeansWithAnnotation(Certificated.class).forEach((key, value) -> {
            if (!MetaUtils.isController(value)) {
                return;
            }
            Certificated certificated = MetaUtils.getAnnotation(value, Certificated.class);
            if (certificated != null) {
                _certificatedControllerMetadata.add((String)key);
            }
        });
        applicationContext.getBeansWithAnnotation(IPRangeLimit.class).forEach((key, value) -> {
            if (!MetaUtils.isController(value)) {
                return;
            }
            IPRangeLimit ipRangeLimit = MetaUtils.getAnnotation(value, IPRangeLimit.class);
            if (ipRangeLimit == null) {
                return;
            }
            iMap.put(key, new IPRangeMeta().setAllow(ipRangeLimit.allow()).setDeny(ipRangeLimit.deny()));
        });
        mapRet.forEach((key, value) -> {
            IPRangeLimit ipRangeLimit;
            Certificated certificated;
            Set auths;
            PermRolesMeta permRolesMeta;
            List<String> mtds = key.getMethodsCondition().getMethods().stream().map(Enum::name).collect(Collectors.toList());
            Set<String> patterns = MetaUtils.getPatterns(key);
            if (!value.getBeanType().equals(BasicErrorController.class)) {
                List clm = _controllerMetadata.computeIfAbsent((String)value.getBean(), r -> new ArrayList());
                patterns.forEach(p -> mtds.forEach(m -> {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("method", (String)m);
                    map.put("path", (String)p);
                    clm.add(map);
                }));
            }
            if (!(permRolesMeta = new PermRolesMeta().merge(MetaUtils.generatePermRolesMeta(auths = AnnotatedElementUtils.getAllMergedAnnotations((AnnotatedElement)value.getMethod(), Auth.class)))).non()) {
                mtds.forEach(method -> patterns.forEach(patternValue -> _authzMetadata.computeIfAbsent((String)patternValue, r -> new HashMap()).put(method, permRolesMeta)));
            }
            Set<Set<String>> requireRoles = permRolesMeta.getRequireRoles();
            Set<Set<String>> excludeRoles = permRolesMeta.getExcludeRoles();
            if (requireRoles != null) {
                requireRoles.forEach(toBeLoadedRoles::addAll);
            }
            if (excludeRoles != null) {
                excludeRoles.forEach(toBeLoadedRoles::addAll);
            }
            if ((certificated = (Certificated)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)value.getMethod(), Certificated.class)) != null) {
                patterns.forEach(p -> _certificatedMetadata.computeIfAbsent((String)p, r -> new HashSet()).addAll(mtds));
            }
            IPRangeMeta iFc = (IPRangeMeta)iMap.get(value.getBean() + "");
            IPRangeMeta ipRangeMeta = new IPRangeMeta();
            if (iFc != null) {
                ipRangeMeta.setAllow(iFc.getAllow());
                ipRangeMeta.setDeny(iFc.getDeny());
            }
            if ((ipRangeLimit = (IPRangeLimit)value.getMethodAnnotation(IPRangeLimit.class)) != null) {
                ipRangeMeta.setAllow(ipRangeLimit.allow()).setDeny(ipRangeLimit.deny());
                if (iFc != null) {
                    ipRangeMeta.getAllow().addAll(iFc.getAllow());
                    ipRangeMeta.getDeny().addAll(iFc.getDeny());
                }
            }
            if (ipRangeMeta.getDeny() != null && !ipRangeMeta.getDeny().isEmpty() || ipRangeMeta.getAllow() != null && !ipRangeMeta.getAllow().isEmpty()) {
                mtds.forEach(method -> patterns.forEach(patternValue -> _ipRangeMeta.computeIfAbsent((String)patternValue, r -> new HashMap()).put(method, ipRangeMeta)));
            }
            mtds.forEach(method -> patterns.forEach(patternValue -> {
                PermissionDict.putParam(patternValue, method);
                for (MethodParameter param : value.getMethodParameters()) {
                    ParamMetadata.ParamType type;
                    RequestParam requestParam = (RequestParam)param.getParameterAnnotation(RequestParam.class);
                    PathVariable pathVariable = (PathVariable)param.getParameterAnnotation(PathVariable.class);
                    String paramName = param.getParameter().getName();
                    Class<?> clz = param.getParameter().getType();
                    if (pathVariable != null) {
                        type = ParamMetadata.ParamType.PATH_VARIABLE;
                        if (!pathVariable.name().equals("")) {
                            paramName = pathVariable.name();
                        }
                    } else {
                        if (requestParam == null) continue;
                        type = ParamMetadata.ParamType.REQUEST_PARAM;
                        if (!requestParam.name().equals("")) {
                            paramName = requestParam.name();
                        }
                    }
                    PermissionDict.putParam(patternValue, method, paramName, ParamMetadata.of(clz, type, null));
                    AuthParam authParam = (AuthParam)param.getParameterAnnotation(AuthParam.class);
                    BatchAuthParam batchAuthParam = (BatchAuthParam)param.getParameterAnnotation(BatchAuthParam.class);
                    if (authParam == null && batchAuthParam == null || ValueMatcher.checkTypeByClass(clz).isOther()) continue;
                    ArrayList<AuthParam> authParamList = new ArrayList<AuthParam>();
                    authParamList.add(authParam);
                    if (batchAuthParam != null) {
                        authParamList.addAll(Arrays.asList(batchAuthParam.value()));
                    }
                    List<Object> paramPermRolesMetas = new ArrayList<ParamPermRolesMeta>();
                    for (AuthParam ap : authParamList) {
                        paramPermRolesMetas.add(MetaUtils.generateParamMeta(ap));
                    }
                    if ((paramPermRolesMetas = paramPermRolesMetas.stream().filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) continue;
                    PermissionDict.putParam(patternValue, method, paramName, ParamMetadata.of(clz, type, paramPermRolesMetas));
                }
            }));
        });
        _globalAllow.addAll(IPRangeMeta.parse(AuthzAppVersion.properties.getGlobalIpRange().getAllow()));
        _globalDeny.addAll(IPRangeMeta.parse(AuthzAppVersion.properties.getGlobalIpRange().getDeny()));
        _supportNative = AuthzAppVersion.properties.getGlobalIpRange().isSupportNative();
        if (AuthzAppVersion.properties.getCache().isEnableRedis()) {
            Async.run(() -> {
                List toBeLoadedRolesKeys = RedisUtils.Obj.get(toBeLoadedRoles.stream().map(role -> Constants.PERMISSIONS_BY_ROLE_KEY_PREFIX.get() + role).collect(Collectors.toList()));
                Iterator iterator = toBeLoadedRoles.iterator();
                HashMap<String, Set> map = new HashMap<String, Set>();
                toBeLoadedRolesKeys.forEach(perms -> map.put((String)iterator.next(), (Set)perms));
                map.forEach((role, v) -> {
                    Collection<String> permissions = permLibrary.getPermissionsByRole((String)role);
                    if (permissions != null) {
                        if (permissions instanceof Set) {
                            cache.setSneaky(Constants.PERMISSIONS_BY_ROLE_KEY_PREFIX.get() + role, (Set)permissions, -1L);
                        } else {
                            cache.setSneaky(Constants.PERMISSIONS_BY_ROLE_KEY_PREFIX.get() + role, new HashSet<String>(permissions), -1L);
                        }
                    }
                });
            });
        }
    }

    public static Map<String, Set<String>> getCertificatedMetadata() {
        return certificatedMetadata;
    }

    public static Set<String> getControllerCertificatedMetadata() {
        return controllerCertificatedMetadata;
    }

    public static Map<String, Map<String, PermRolesMeta>> getRolePermission() {
        return rolePermission;
    }

    public static Map<String, PermRolesMeta> getControllerRolePermission() {
        return controllerRolePermission;
    }

    public static Map<String, Map<String, Map<String, ParamMetadata>>> getParamPermission() {
        return paramPermission;
    }

    public static Map<String, Model> getAuthzResourcesModel() {
        return authzResourcesModel;
    }

    public static Map<String, List<DataPermRolesMeta>> getDataPermission() {
        return dataPermission;
    }

    public static Map<String, Map<String, FieldDataPermRolesMeta>> getFieldsData() {
        return fieldsData;
    }

    public static Map<String, ArgsMeta> getArgs() {
        return args;
    }

    public static Map<String, Map<String, IPRangeMeta>> getIPRange() {
        return iPRange;
    }

    public static Set<IPRange> getGlobalAllow() {
        return globalAllow;
    }

    public static Set<IPRange> getGlobalDeny() {
        return globalDeny;
    }

    public static Map<String, List<Map<String, String>>> getControllerMetadata() {
        return controllerMetadata;
    }

    static {
        _globalAllow = new HashSet<IPRange>();
        _globalDeny = new HashSet<IPRange>();
        certificatedMetadata = Collections.unmodifiableMap(_certificatedMetadata);
        controllerCertificatedMetadata = Collections.unmodifiableSet(_certificatedControllerMetadata);
        rolePermission = Collections.unmodifiableMap(_authzMetadata);
        controllerRolePermission = Collections.unmodifiableMap(_authzControllerMetadata);
        paramPermission = Collections.unmodifiableMap(_authzParamMetadata);
        authzResourcesModel = Collections.unmodifiableMap(_authzResourcesModel);
        dataPermission = Collections.unmodifiableMap(_dataPermMetadata);
        fieldsData = Collections.unmodifiableMap(_fieldMetadata);
        args = Collections.unmodifiableMap(_argsMetadata);
        iPRange = Collections.unmodifiableMap(_ipRangeMeta);
        globalAllow = Collections.unmodifiableSet(_globalAllow);
        globalDeny = Collections.unmodifiableSet(_globalDeny);
        controllerMetadata = Collections.unmodifiableMap(_controllerMetadata);
        lock = new ReentrantLock();
        permSeparator = ",";
        isInit = false;
    }
}

