/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.rpd;

import cn.omisheep.authz.core.auth.rpd.Meta;
import cn.omisheep.authz.core.auth.rpd.Non;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.commons.util.CollectionUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class PermRolesMeta
implements Non {
    Meta roles;
    Meta permissions;

    @Override
    public boolean non() {
        return !(this.roles != null && !this.roles.non() || this.permissions != null && !this.permissions.non());
    }

    public PermRolesMeta clear() {
        this.roles = null;
        this.permissions = null;
        return this;
    }

    public Set<Set<String>> getRequireRoles() {
        if (this.roles != null) {
            return this.roles.require;
        }
        return null;
    }

    public Set<Set<String>> getExcludeRoles() {
        if (this.roles != null) {
            return this.roles.exclude;
        }
        return null;
    }

    public Set<Set<String>> getRequirePermissions() {
        if (this.permissions != null) {
            return this.permissions.require;
        }
        return null;
    }

    public Set<Set<String>> getExcludePermissions() {
        if (this.permissions != null) {
            return this.permissions.exclude;
        }
        return null;
    }

    @JsonIgnore
    public Meta getRoles() {
        return this.roles;
    }

    @JsonIgnore
    public Meta getPermissions() {
        return this.permissions;
    }

    public void setRequireRoles(Set<Set<String>> requireRoles) {
        if (requireRoles == null || requireRoles.isEmpty()) {
            if (this.roles != null) {
                this.roles.require = null;
            }
        } else {
            Set<Set<String>> set = this.filter(requireRoles);
            if (set.isEmpty()) {
                if (this.roles != null) {
                    this.roles.require = null;
                }
                return;
            }
            if (this.roles == null) {
                this.roles = new Meta();
            }
            this.roles.require = set;
        }
    }

    public void setExcludeRoles(Set<Set<String>> excludeRoles) {
        if (excludeRoles == null || excludeRoles.isEmpty()) {
            if (this.roles != null) {
                this.roles.exclude = null;
            }
        } else {
            Set<Set<String>> set = this.filter(excludeRoles);
            if (set.isEmpty()) {
                if (this.roles != null) {
                    this.roles.exclude = null;
                }
                return;
            }
            if (this.roles == null) {
                this.roles = new Meta();
            }
            this.roles.exclude = set;
        }
    }

    public void setRequirePermissions(Set<Set<String>> requirePermissions) {
        if (requirePermissions == null || requirePermissions.isEmpty()) {
            if (this.permissions != null) {
                this.permissions.require = null;
            }
        } else {
            Set<Set<String>> set = this.filter(requirePermissions);
            if (set.isEmpty()) {
                if (this.permissions != null) {
                    this.permissions.require = null;
                }
                return;
            }
            if (this.permissions == null) {
                this.permissions = new Meta();
            }
            this.permissions.require = set;
        }
    }

    public void setExcludePermissions(Set<Set<String>> excludePermissions) {
        if (excludePermissions == null || excludePermissions.isEmpty()) {
            if (this.permissions != null) {
                this.permissions.exclude = null;
            }
        } else {
            Set<Set<String>> set = this.filter(excludePermissions);
            if (set.isEmpty()) {
                if (this.permissions != null) {
                    this.permissions.exclude = null;
                }
                return;
            }
            if (this.permissions == null) {
                this.permissions = new Meta();
            }
            this.permissions.exclude = set;
        }
    }

    private Set<Set<String>> filter(Set<Set<String>> set) {
        return set.stream().map(s -> {
            Set collect = s.stream().filter(Objects::nonNull).map(v -> v.replaceAll("&nbsp;", " ")).map(String::trim).filter((? super T v) -> !v.isEmpty()).collect(Collectors.toSet());
            if (!collect.isEmpty()) {
                return collect;
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public void setRequireRoles(Collection<String> requireRoles) {
        this.setRequireRoles(CollectionUtils.splitStrValsToSets((String)PermissionDict.getPermSeparator(), (String[])requireRoles.toArray(new String[0])));
    }

    public void setExcludeRoles(Collection<String> excludeRoles) {
        this.setExcludeRoles(CollectionUtils.splitStrValsToSets((String)PermissionDict.getPermSeparator(), (String[])excludeRoles.toArray(new String[0])));
    }

    public void setRequirePermissions(Collection<String> requirePermissions) {
        this.setRequirePermissions(CollectionUtils.splitStrValsToSets((String)PermissionDict.getPermSeparator(), (String[])requirePermissions.toArray(new String[0])));
    }

    public void setExcludePermissions(Collection<String> excludePermissions) {
        this.setExcludePermissions(CollectionUtils.splitStrValsToSets((String)PermissionDict.getPermSeparator(), (String[])excludePermissions.toArray(new String[0])));
    }

    public void setRoles(Meta role) {
        if (role == null) {
            return;
        }
        this.setRoles(role.require, role.exclude);
    }

    public void setRoles(Set<Set<String>> require, Set<Set<String>> exclude) {
        if ((require == null || require.isEmpty()) && (exclude == null || exclude.isEmpty())) {
            this.roles = null;
            return;
        }
        this.setRequireRoles(require);
        this.setExcludeRoles(exclude);
    }

    public void setPermissions(Meta permissions) {
        if (permissions == null) {
            return;
        }
        this.setPermissions(permissions.require, permissions.exclude);
    }

    public void setPermissions(Set<Set<String>> require, Set<Set<String>> exclude) {
        if ((require == null || require.isEmpty()) && (exclude == null || exclude.isEmpty())) {
            this.permissions = null;
            return;
        }
        this.setRequirePermissions(require);
        this.setExcludePermissions(exclude);
    }

    public PermRolesMeta merge(PermRolesMeta other) {
        if (other == null) {
            return this;
        }
        if (this.permissions == null) {
            this.setExcludePermissions(other.getExcludePermissions());
            this.setRequirePermissions(other.getRequirePermissions());
        } else {
            Set<Set<String>> excludePermissions;
            Set<Set<String>> requirePermissions = other.getRequirePermissions();
            if (requirePermissions != null) {
                this.permissions.require.addAll(requirePermissions);
            }
            if ((excludePermissions = other.getExcludePermissions()) != null) {
                this.permissions.exclude.addAll(excludePermissions);
            }
        }
        if (this.roles == null) {
            this.setRequireRoles(other.getRequireRoles());
            this.setExcludeRoles(other.getExcludeRoles());
        } else {
            Set<Set<String>> excludeRoles;
            Set<Set<String>> requireRoles = other.getRequireRoles();
            if (requireRoles != null) {
                this.roles.require.addAll(requireRoles);
            }
            if ((excludeRoles = other.getExcludeRoles()) != null) {
                this.roles.exclude.addAll(excludeRoles);
            }
        }
        return this;
    }

    public String toString() {
        return (this.roles != null ? "( role : " + this.roles + " )" : "") + (this.permissions != null ? "\t, ( permissions : " + this.permissions + " )" : "");
    }
}

