/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.rpd;

import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.Rule;
import cn.omisheep.authz.core.util.RuleParser;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DataPermRolesMeta
extends PermRolesMeta {
    private String condition;
    private Rule rule;
    private Map<String, List<String>> argsMap;

    public static DataPermRolesMeta of(String condition) {
        return new DataPermRolesMeta().setRule(RuleParser.parseStringToRule(condition)).setCondition(condition);
    }

    public static DataPermRolesMeta of(Rule rule) {
        return new DataPermRolesMeta().setCondition(RuleParser.parseRuleToString(rule)).setRule(rule);
    }

    public DataPermRolesMeta addArg(String source, List<String> args) {
        if (this.argsMap == null) {
            this.argsMap = new HashMap<String, List<String>>();
        }
        this.argsMap.put(source, args);
        return this;
    }

    public void addArg(String source, String ... args) {
        if (this.argsMap == null) {
            this.argsMap = new HashMap<String, List<String>>();
        }
        if (args != null) {
            this.argsMap.put(source, Arrays.stream(args).collect(Collectors.toList()));
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataPermRolesMeta)) {
            return false;
        }
        DataPermRolesMeta other = (DataPermRolesMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$condition = this.getCondition();
        String other$condition = other.getCondition();
        if (this$condition == null ? other$condition != null : !this$condition.equals(other$condition)) {
            return false;
        }
        Rule this$rule = this.getRule();
        Rule other$rule = other.getRule();
        if (this$rule == null ? other$rule != null : !this$rule.equals(other$rule)) {
            return false;
        }
        Map<String, List<String>> this$argsMap = this.getArgsMap();
        Map<String, List<String>> other$argsMap = other.getArgsMap();
        return !(this$argsMap == null ? other$argsMap != null : !((Object)this$argsMap).equals(other$argsMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataPermRolesMeta;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $condition = this.getCondition();
        result = result * 59 + ($condition == null ? 43 : $condition.hashCode());
        Rule $rule = this.getRule();
        result = result * 59 + ($rule == null ? 43 : $rule.hashCode());
        Map<String, List<String>> $argsMap = this.getArgsMap();
        result = result * 59 + ($argsMap == null ? 43 : ((Object)$argsMap).hashCode());
        return result;
    }

    public String getCondition() {
        return this.condition;
    }

    public Rule getRule() {
        return this.rule;
    }

    public Map<String, List<String>> getArgsMap() {
        return this.argsMap;
    }

    public DataPermRolesMeta setCondition(String condition) {
        this.condition = condition;
        return this;
    }

    public DataPermRolesMeta setRule(Rule rule) {
        this.rule = rule;
        return this;
    }

    public DataPermRolesMeta setArgsMap(Map<String, List<String>> argsMap) {
        this.argsMap = argsMap;
        return this;
    }

    @Override
    public String toString() {
        return "DataPermRolesMeta(condition=" + this.getCondition() + ", rule=" + this.getRule() + ", argsMap=" + this.getArgsMap() + ")";
    }
}

