/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.rpd;

import cn.omisheep.authz.core.schema.Model;
import cn.omisheep.authz.core.schema.ModelParser;
import cn.omisheep.authz.core.util.LogUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Objects;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ArgsMeta {
    @JsonIgnore
    final Class<?> type;
    @JsonIgnore
    final Method method;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    final List<Class<?>> parameters;
    @JsonIgnore
    final Class<?> returnType;
    final Model model;
    final String ref;
    String description = "";

    private ArgsMeta(Class<?> type, Method method) {
        this.type = type;
        this.method = method;
        this.returnType = method.getReturnType();
        this.parameters = Arrays.stream(method.getParameterTypes()).collect(Collectors.toList());
        this.model = ModelParser.parse(method.getReturnType());
        String[] s = method.toString().split(" ");
        this.ref = s[s.length - 1];
    }

    public String getMethod() {
        return this.method.getName();
    }

    public static ArgsMeta of(Class<?> type, Method method) {
        return new ArgsMeta(type, method);
    }

    public static ArgsMeta of(Class<?> type, String methodName, Class<?> ... args) {
        try {
            return new ArgsMeta(type, type.getMethod(methodName, args));
        }
        catch (NoSuchMethodException e) {
            LogUtils.error("NoSuchMethodException", e);
            return null;
        }
    }

    public static ArgsMeta of(Object type, String methodName, Class<?> ... args) {
        return ArgsMeta.of(type.getClass(), methodName, args);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ArgsMeta)) {
            return false;
        }
        ArgsMeta meta = (ArgsMeta)o;
        return Objects.equal((Object)this.method, (Object)meta.method) && Objects.equal(this.type, meta.type);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.method, this.type});
    }

    public Class<?> getType() {
        return this.type;
    }

    public List<Class<?>> getParameters() {
        return this.parameters;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Model getModel() {
        return this.model;
    }

    public String getRef() {
        return this.ref;
    }

    public String getDescription() {
        return this.description;
    }

    public ArgsMeta setDescription(String description) {
        this.description = description;
        return this;
    }
}

