/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.rpd;

import cn.omisheep.authz.AuthzAutoConfiguration;
import cn.omisheep.authz.core.AuthzContext;
import cn.omisheep.authz.core.auth.rpd.ArgsMeta;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.authz.core.util.LogUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ArgsHandler {
    private ArgsHandler() {
        throw new UnsupportedOperationException();
    }

    public static List<Class<?>> argParameterList(String argsName) {
        ArgsMeta meta = PermissionDict.getArgs().get(argsName);
        if (meta == null) {
            return null;
        }
        return meta.parameters;
    }

    public static Object handle(String argName, Object ... otherArgs) {
        ArgsMeta meta = PermissionDict.getArgs().get(argName);
        if (meta == null) {
            LogUtils.error("arg {} is null", argName);
            return null;
        }
        try {
            Object bean = AuthzContext.getBean(meta.type);
            return meta.method.invoke(bean, otherArgs);
        }
        catch (Exception e) {
            try {
                if (Modifier.isStatic(meta.method.getModifiers())) {
                    return meta.method.invoke(null, otherArgs);
                }
                int modifiers = meta.type.getModifiers();
                if (Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers)) {
                    LogUtils.error("{} bean \u4e0d\u5b58\u5728 \u4e14\u4e0d\u80fd\u5b9e\u4f8b\u5316 \uff0c \u6216\u8005\u53c2\u6570\u4e2a\u6570\u3001\u7c7b\u578b\u4e0d\u6b63\u786e", meta.type);
                    return null;
                }
                return meta.method.invoke(meta.type.newInstance(), otherArgs);
            }
            catch (Exception ex) {
                LogUtils.error("{} \u6784\u9020\u51fd\u6570\u5f02\u5e38", meta.type);
                LogUtils.error(e);
                return null;
            }
        }
    }

    public static Map<String, String> parseTypeForTemplate(String className) {
        if (className.startsWith("java.")) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> typeTemplate = new HashMap<String, String>();
        try {
            Class<?> clz = Class.forName(className, false, AuthzAutoConfiguration.class.getClassLoader());
            for (Method method : clz.getMethods()) {
                String name;
                if (method.isAnnotationPresent(JsonIgnore.class) || !(name = method.getName()).startsWith("get") && !name.startsWith("is") || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || Modifier.isAbstract(method.getModifiers()) || Modifier.isNative(method.getModifiers()) || Modifier.isFinal(method.getModifiers())) continue;
                String field = name.startsWith("get") ? name.substring(3, 4).toLowerCase(Locale.ROOT) + name.substring(4) : name.substring(2, 3).toLowerCase(Locale.ROOT) + name.substring(3);
                try {
                    if (clz.getDeclaredField(field).isAnnotationPresent(JsonIgnore.class)) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                typeTemplate.put(field, method.getReturnType().getTypeName());
            }
        }
        catch (Exception e) {
            return new HashMap<String, String>();
        }
        return typeTemplate;
    }
}

