/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.ipf;

import cn.omisheep.authz.annotation.RateLimit;
import cn.omisheep.authz.core.auth.ipf.Httpd;
import cn.omisheep.authz.core.config.Constants;
import cn.omisheep.commons.util.TimeUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class LimitMeta {
    private final long window;
    private final int maxRequests;
    private final long minInterval;
    private final RateLimit.CheckType checkType;
    private final List<AssociatedPattern> associatedPatterns;
    private final List<Long> punishmentTime = new ArrayList<Long>();

    public LimitMeta(String window, int maxRequests, String[] punishmentTime, String minInterval, String[] associatedPatterns, RateLimit.CheckType checkType) {
        this.window = TimeUtils.parseTimeValue((String)window);
        this.maxRequests = maxRequests;
        this.checkType = checkType;
        Arrays.stream(punishmentTime).forEach(val -> this.punishmentTime.add(TimeUtils.parseTimeValue((String)val)));
        Collections.sort(this.punishmentTime);
        this.minInterval = TimeUtils.parseTimeValue((String)minInterval);
        if (associatedPatterns.length > 0) {
            ArrayList<AssociatedPattern> ap = new ArrayList<AssociatedPattern>();
            for (String info : associatedPatterns) {
                AssociatedPattern associatedPattern = AssociatedPattern.of(info);
                if (associatedPattern == null) continue;
                int i = ap.indexOf(associatedPattern);
                if (i == -1) {
                    ap.add(associatedPattern);
                    continue;
                }
                AssociatedPattern existedAssociatedPattern = ap.get(i);
                existedAssociatedPattern.mergeMethods(associatedPattern);
            }
            this.associatedPatterns = !ap.isEmpty() ? ap : null;
        } else {
            this.associatedPatterns = null;
        }
    }

    public List<AssociatedPattern> _getAssociatedPatterns() {
        if (this.associatedPatterns == null) {
            return null;
        }
        return Collections.unmodifiableList(this.associatedPatterns);
    }

    public Set<String> getAssociatedPatterns() {
        if (this.associatedPatterns == null) {
            return null;
        }
        return this.associatedPatterns.stream().flatMap(a -> ((AssociatedPattern)a).methods.stream().map(m -> m + " " + ((AssociatedPattern)a).pattern)).collect(Collectors.toSet());
    }

    public List<Long> getPunishmentTime() {
        return Collections.unmodifiableList(this.punishmentTime);
    }

    public long getWindow() {
        return this.window;
    }

    public int getMaxRequests() {
        return this.maxRequests;
    }

    public long getMinInterval() {
        return this.minInterval;
    }

    public RateLimit.CheckType getCheckType() {
        return this.checkType;
    }

    public static class AssociatedPattern {
        private final Set<String> methods;
        private final String pattern;

        public static AssociatedPattern of(String info) {
            Set<String> methods;
            String pattern;
            String[] split = info.split(" ");
            if (split.length > 1) {
                pattern = split[split.length - 1];
                if (!pattern.endsWith("*")) {
                    ConcurrentHashMap<String, Httpd.RequestPool> map = Httpd.getIpRequestPools().get(pattern);
                    if (map == null) {
                        return null;
                    }
                    methods = new HashSet<String>(map.keySet());
                } else {
                    methods = AssociatedPattern.getMethods(pattern);
                }
                if (methods == null || methods.isEmpty()) {
                    return null;
                }
            } else {
                pattern = split[0];
                methods = AssociatedPattern.getMethods(pattern);
                if (methods == null) {
                    return null;
                }
            }
            return new AssociatedPattern(methods, pattern);
        }

        private static Set<String> getMethods(String pattern) {
            String _p = pattern.substring(0, pattern.lastIndexOf("*"));
            Map<String, ConcurrentHashMap<String, Httpd.RequestPool>> map = Httpd.getIpRequestPools();
            Set collect = Httpd.getIpRequestPools().keySet().stream().filter(v -> v.startsWith(_p)).flatMap(v -> ((ConcurrentHashMap)map.get(v)).keySet().stream()).collect(Collectors.toSet());
            if (collect.isEmpty()) {
                return null;
            }
            return new HashSet<String>(collect);
        }

        public static String[] mtsFn(String mts) {
            if (mts.equals("*")) {
                return Constants.METHODS;
            }
            return new String[]{mts};
        }

        public void mergeMethods(AssociatedPattern other) {
            this.methods.addAll(other.methods);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AssociatedPattern that = (AssociatedPattern)o;
            return Objects.equal((Object)this.pattern, (Object)that.pattern);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.pattern});
        }

        public Set<String> getMethods() {
            return this.methods;
        }

        public String getPattern() {
            return this.pattern;
        }

        public AssociatedPattern(Set<String> methods, String pattern) {
            this.methods = methods;
            this.pattern = pattern;
        }

        public String toString() {
            return "LimitMeta.AssociatedPattern(methods=" + this.getMethods() + ", pattern=" + this.getPattern() + ")";
        }
    }
}

