/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.ipf;

import cn.omisheep.authz.annotation.RateLimit;
import cn.omisheep.authz.core.AuthzProperties;
import cn.omisheep.authz.core.auth.ipf.LimitMeta;
import cn.omisheep.authz.core.auth.ipf.RequestMeta;
import cn.omisheep.authz.core.callback.RateLimitCallback;
import cn.omisheep.authz.core.msg.AuthzModifier;
import cn.omisheep.authz.core.msg.RequestMessage;
import cn.omisheep.authz.core.util.LogUtils;
import cn.omisheep.authz.core.util.MetaUtils;
import cn.omisheep.web.entity.Result;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.ApplicationContext;
import org.springframework.http.server.PathContainer;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.util.pattern.PathPattern;
import org.springframework.web.util.pattern.PathPatternParser;

public class Httpd {
    private static final HashMap<String, PathPattern> pathMatcherMap = new HashMap();
    private static final PathPatternParser pathPatternParser = new PathPatternParser();
    private static final RequestPools _ipRequestPools = new RequestPools();
    private static final RequestPools _userIdRequestPools = new RequestPools();
    private static final Map<String, Map<String, LimitMeta>> _rateLimitMetadata = new HashMap<String, Map<String, LimitMeta>>();
    private static final Map<String, Map<String, LimitMeta>> rateLimitMetadata = Collections.unmodifiableMap(_rateLimitMetadata);
    private static final Map<String, ConcurrentHashMap<String, RequestPool>> ipRequestPools = Collections.unmodifiableMap(_ipRequestPools);
    private static final Map<String, ConcurrentHashMap<String, RequestPool>> userIdRequestPools = Collections.unmodifiableMap(_userIdRequestPools);
    @JsonIgnore
    private static final Map<LimitMeta, List<RequestPool>> associatedIpPoolsCache = new HashMap<LimitMeta, List<RequestPool>>();
    private static boolean isInit = false;

    public static RequestPool getIpRequestPools(String api, String method) {
        ConcurrentHashMap map = (ConcurrentHashMap)_ipRequestPools.get(api);
        if (map == null) {
            return null;
        }
        return (RequestPool)map.get(method);
    }

    public static RequestPool getUserIdRequestPool(String api, String method) {
        ConcurrentHashMap map = (ConcurrentHashMap)_userIdRequestPools.get(api);
        if (map == null) {
            return null;
        }
        return (RequestPool)map.get(method);
    }

    public static LimitMeta getLimitMetadata(String method, String api) {
        Map<String, LimitMeta> limitMetaMap = _rateLimitMetadata.get(api);
        if (limitMetaMap == null) {
            return null;
        }
        return limitMetaMap.get(method);
    }

    public static void setPathPattern(String pattern) {
        pathMatcherMap.put(pattern, pathPatternParser.parse(pattern));
    }

    public static boolean match(String pattern, String path) {
        PathPattern pathPattern = pathMatcherMap.get(pattern);
        if (pathPattern == null) {
            return false;
        }
        return pathPattern.matches(PathContainer.parsePath((String)path));
    }

    public static String getPattern(String path) {
        for (Map.Entry<String, PathPattern> entry : pathMatcherMap.entrySet()) {
            if (!entry.getValue().matches(PathContainer.parsePath((String)path))) continue;
            return entry.getKey();
        }
        return null;
    }

    public static String getPattern(String method, String path) {
        for (Map.Entry<String, PathPattern> entry : pathMatcherMap.entrySet()) {
            if (!entry.getValue().matches(PathContainer.parsePath((String)path))) continue;
            ConcurrentHashMap map = (ConcurrentHashMap)_ipRequestPools.get(entry.getKey());
            if (map == null || map.isEmpty()) {
                return null;
            }
            if (map.get(method) == null) {
                return null;
            }
            return entry.getKey();
        }
        return null;
    }

    public static void receive(RequestMessage requestMessage) {
        String api = requestMessage.getApi();
        String method = requestMessage.getMethod();
        String ip = requestMessage.getIp();
        long now = requestMessage.getNow();
        Object userId = requestMessage.getUserId();
        LimitMeta limitMeta = Httpd.getLimitMetadata(method, api);
        if (limitMeta == null) {
            return;
        }
        try {
            RequestMeta requestMeta;
            RateLimit.CheckType checkType = limitMeta.getCheckType();
            if (checkType.equals((Object)RateLimit.CheckType.USER_ID) && userId == null) {
                return;
            }
            RequestPool ipRequestPool = (RequestPool)((ConcurrentHashMap)_ipRequestPools.get(api)).get(method);
            RequestPool userIdRequestPool = (RequestPool)((ConcurrentHashMap)_userIdRequestPools.get(api)).get(method);
            RequestMeta requestMeta2 = requestMeta = checkType.equals((Object)RateLimit.CheckType.IP) ? (RequestMeta)ipRequestPool.get(ip) : (RequestMeta)userIdRequestPool.get(userId.toString());
            if (requestMeta == null) {
                if (checkType.equals((Object)RateLimit.CheckType.IP)) {
                    ipRequestPool.put(ip, new RequestMeta(now, ip, null));
                } else {
                    userIdRequestPool.put(userId.toString(), new RequestMeta(now, null, userId));
                }
            } else if (!requestMeta.pushRequest(now, limitMeta)) {
                Httpd.forbid(now, requestMeta, limitMeta, method, api);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static List<RequestPool> associatedIpPools(LimitMeta limitMeta) {
        List<RequestPool> rps = associatedIpPoolsCache.get(limitMeta);
        if (rps != null) {
            return rps;
        }
        List<LimitMeta.AssociatedPattern> associatedPatterns = limitMeta._getAssociatedPatterns();
        RateLimit.CheckType checkType = limitMeta.getCheckType();
        ArrayList<RequestPool> oIpPools = new ArrayList<RequestPool>();
        if (associatedPatterns != null) {
            associatedPatterns.forEach(associatedPattern -> associatedPattern.getMethods().forEach(meth -> {
                RequestPools requestPools = checkType.equals((Object)RateLimit.CheckType.IP) ? _ipRequestPools : _userIdRequestPools;
                requestPools.keySet().stream().filter(path -> Httpd.match(associatedPattern.getPattern(), path)).forEach(path -> oIpPools.add((RequestPool)((ConcurrentHashMap)requestPools.get(path)).get(meth)));
            }));
        }
        associatedIpPoolsCache.put(limitMeta, oIpPools);
        return oIpPools;
    }

    public static void forbid(long now, RequestMeta requestMeta, LimitMeta limitMeta, String method, String api) {
        requestMeta.forbidden(method, api, limitMeta);
        String ip = requestMeta.getIp();
        Object userId = requestMeta.getUserId();
        for (RequestPool ipPool : Httpd.associatedIpPools(limitMeta)) {
            if (!ipPool.containsKey(ip)) {
                ipPool.put(ip, new RequestMeta(now, ip, userId).forbidden(method, api, limitMeta));
                continue;
            }
            ((RequestMeta)ipPool.get(ip)).forbidden(method, api, limitMeta);
        }
    }

    public static void relive(RequestMeta requestMeta, LimitMeta limitMeta, String method, String api) {
        String ip = requestMeta.getIp();
        requestMeta.relive(method, api, limitMeta);
        Httpd.associatedIpPools(limitMeta).forEach(ipPool -> {
            if (ipPool.containsKey(ip)) {
                ((RequestMeta)ipPool.get(ip)).relive(method, api, limitMeta);
            }
        });
    }

    @Nullable
    public static synchronized Object modify(@NonNull AuthzModifier authzModifier) {
        String path = authzModifier.getApi();
        String method = authzModifier.getMethod();
        try {
            switch (authzModifier.getOperate()) {
                case ADD: 
                case MODIFY: 
                case UPDATE: {
                    AuthzModifier.RateLimitInfo rateLimit = authzModifier.getRateLimit();
                    LimitMeta limitMeta = new LimitMeta(rateLimit.getWindow() + "ms", rateLimit.getMaxRequests(), rateLimit.getPunishmentTime().toArray(new String[0]), rateLimit.getMinInterval() + "ms", rateLimit.getAssociatedPatterns().toArray(new String[0]), rateLimit.getCheckType());
                    _rateLimitMetadata.computeIfAbsent(path, r -> new HashMap()).put(method, limitMeta);
                    return Result.SUCCESS.data("rateLimit", (Object)limitMeta);
                }
                case DEL: 
                case DELETE: {
                    _rateLimitMetadata.computeIfAbsent(path, r -> new HashMap()).remove(method);
                    if (_rateLimitMetadata.get(path).isEmpty()) {
                        _rateLimitMetadata.remove(path);
                    }
                    return Result.SUCCESS;
                }
                case READ: 
                case GET: {
                    return _rateLimitMetadata.get(authzModifier.getApi()).get(authzModifier.getMethod());
                }
            }
            return Result.FAIL;
        }
        catch (Exception e) {
            LogUtils.error("modify error", e);
            return Result.FAIL;
        }
    }

    public static void setRateLimitCallback(RateLimitCallback callback) {
        RequestMeta.setCallback(callback);
    }

    public static void init(AuthzProperties properties, ApplicationContext applicationContext, Map<RequestMappingInfo, HandlerMethod> mapRet) {
        if (isInit) {
            return;
        }
        isInit = true;
        HashMap cMap = new HashMap();
        applicationContext.getBeansWithAnnotation(RateLimit.class).forEach((key, value) -> {
            Class aClass = AopUtils.getTargetClass((Object)value);
            RateLimit rateLimit = aClass.getAnnotation(RateLimit.class);
            if (rateLimit != null) {
                cMap.put(aClass.getName(), new LimitMeta(rateLimit.window(), rateLimit.maxRequests(), rateLimit.punishmentTime(), rateLimit.minInterval(), rateLimit.associatedPatterns(), rateLimit.checkType()));
            }
        });
        mapRet.forEach((key, value) -> MetaUtils.getPatterns(key).forEach(patternValue -> {
            Httpd.setPathPattern(patternValue);
            HashMap userIdRequestPool = new HashMap();
            HashMap ipRequestPool = new HashMap();
            key.getMethodsCondition().getMethods().forEach(method -> {
                userIdRequestPool.put(method.name(), new RequestPool());
                ipRequestPool.put(method.name(), new RequestPool());
            });
            _ipRequestPools.computeIfAbsent(patternValue, r -> new ConcurrentHashMap()).putAll(ipRequestPool);
            _userIdRequestPools.computeIfAbsent(patternValue, r -> new ConcurrentHashMap()).putAll(userIdRequestPool);
        }));
        mapRet.forEach((key, value) -> {
            Set methods = key.getMethodsCondition().getMethods();
            RateLimit rateLimit = (RateLimit)value.getMethodAnnotation(RateLimit.class);
            if (rateLimit != null) {
                LimitMeta limitMeta = new LimitMeta(rateLimit.window(), rateLimit.maxRequests(), rateLimit.punishmentTime(), rateLimit.minInterval(), rateLimit.associatedPatterns(), rateLimit.checkType());
                methods.forEach(method -> MetaUtils.getPatterns(key).forEach(patternValue -> _rateLimitMetadata.computeIfAbsent((String)patternValue, r -> new HashMap()).put(method.toString(), limitMeta)));
            } else {
                methods.forEach(method -> MetaUtils.getPatterns(key).forEach(patternValue -> {
                    LimitMeta limitMeta = (LimitMeta)cMap.get(value.getBeanType().getName());
                    if (limitMeta != null) {
                        _rateLimitMetadata.computeIfAbsent((String)patternValue, r -> new HashMap()).put(method.toString(), limitMeta);
                    }
                }));
            }
        });
    }

    private Httpd() {
        throw new UnsupportedOperationException();
    }

    public static Map<String, Map<String, LimitMeta>> getRateLimitMetadata() {
        return rateLimitMetadata;
    }

    public static Map<String, ConcurrentHashMap<String, RequestPool>> getIpRequestPools() {
        return ipRequestPools;
    }

    public static Map<String, ConcurrentHashMap<String, RequestPool>> getUserIdRequestPools() {
        return userIdRequestPools;
    }

    public static class RequestPool
    extends ConcurrentHashMap<String, RequestMeta> {
        private static final long serialVersionUID = -284927742264879191L;
    }

    public static class RequestPools
    extends HashMap<String, ConcurrentHashMap<String, RequestPool>> {
        private static final long serialVersionUID = -1838299980303412207L;
    }
}

