/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.ipf;

import cn.omisheep.authz.annotation.ArgResource;
import cn.omisheep.authz.core.AuthzException;
import cn.omisheep.authz.core.ExceptionStatus;
import cn.omisheep.authz.core.LogLevel;
import cn.omisheep.authz.core.auth.deviced.UserDevicesDict;
import cn.omisheep.authz.core.auth.rpd.ParamMetadata;
import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.authz.core.config.AuthzAppVersion;
import cn.omisheep.authz.core.helper.BaseHelper;
import cn.omisheep.authz.core.tk.AccessToken;
import cn.omisheep.authz.core.util.IPUtils;
import cn.omisheep.authz.core.util.LogUtils;
import cn.omisheep.commons.util.CollectionUtils;
import cn.omisheep.web.utils.HttpUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import lombok.NonNull;
import org.springframework.util.StringUtils;

public class HttpMeta
extends BaseHelper {
    private String ip;
    private String uri;
    private String api;
    private String servletPath;
    private String path;
    private String method;
    private String userAgent;
    private String refer;
    private String body;
    private AccessToken token;
    private Object userId;
    private Set<String> roles;
    private Set<String> permissions;
    private Set<String> scope;
    private PermRolesMeta permRolesMeta;
    private Boolean hasApiAuth;
    private Boolean hasParamAuth;
    private Boolean requireLogin;
    private String controller;
    @JsonIgnore
    private HttpServletRequest request;
    @JsonIgnore
    private boolean clearCookie = true;
    @JsonIgnore
    private UserDevicesDict.UserStatus userStatus;
    @JsonIgnore
    private LinkedList<Object> exceptionObjectList = new LinkedList();
    @JsonIgnore
    private LinkedList<ExceptionStatus> exceptionStatusList = new LinkedList();
    private Date now = new Date();

    public HttpMeta setRoles(Set<String> roles) {
        if (roles == null) {
            return this;
        }
        this.roles = roles;
        return this;
    }

    public HttpMeta setPermissions(Set<String> permissions) {
        if (permissions == null) {
            return this;
        }
        this.permissions = permissions;
        return this;
    }

    @NonNull
    public Set<String> getRoles() {
        if (this.userId == null) {
            return new HashSet<String>();
        }
        if (this.roles == null) {
            Collection<String> r = permLibrary.getRolesByUserId(this.userId);
            this.roles = r instanceof Set ? (Set<Object>)r : new HashSet<String>(r);
        }
        return this.roles;
    }

    @NonNull
    public Set<String> getPermissions() {
        if (this.userId == null) {
            return new HashSet<String>();
        }
        this.permissions = Optional.ofNullable(this.permissions).orElseGet(() -> {
            HashSet<String> perms = new HashSet<String>();
            for (String role : (Set)Optional.ofNullable(this.getRoles()).orElse(new HashSet())) {
                Collection<String> permissionsByRole = permLibrary.getPermissionsByRole(role);
                if (permissionsByRole == null) continue;
                perms.addAll(permissionsByRole);
            }
            return perms;
        });
        return this.permissions;
    }

    @NonNull
    public Set<String> getScope() {
        if (this.token == null) {
            return new HashSet<String>();
        }
        this.scope = Optional.ofNullable(this.scope).orElseGet(() -> {
            String s = this.token.getScope();
            if (s == null || s.equals("")) {
                return new HashSet();
            }
            return CollectionUtils.ofSet((Object[])s.split(AuthzAppVersion.SCOPE_SEPARATOR.get()));
        });
        return this.scope;
    }

    @ArgResource(value="httpMeta", description="\u5f53\u524d\u8bf7\u6c42\u7684HttpMeta")
    public static HttpMeta currentHttpMeta() {
        try {
            return (HttpMeta)HttpUtils.getCurrentRequest().getAttribute("AU_HTTP_META");
        }
        catch (Exception e) {
            return null;
        }
    }

    @ArgResource(value="token", description="\u5f53\u524d\u8bf7\u6c42\u7684Token")
    public static AccessToken currentToken() {
        try {
            return HttpMeta.currentHttpMeta().token;
        }
        catch (Exception e) {
            return null;
        }
    }

    @ArgResource(value="userId", description="\u5f53\u524d\u8bf7\u6c42\u7684userId")
    public static Object currentUserId() {
        try {
            return HttpMeta.currentToken().getUserId();
        }
        catch (Exception e) {
            return null;
        }
    }

    public HttpMeta error(AuthzException authzException) {
        if (authzException == null) {
            return this;
        }
        return this.error(authzException.getExceptionStatus());
    }

    public HttpMeta error(ExceptionStatus exceptionStatus) {
        if (exceptionStatus != null) {
            this.exceptionStatusList.add(exceptionStatus);
        }
        return this;
    }

    public HttpMeta clearError() {
        this.exceptionStatusList.clear();
        return this;
    }

    public void log(String formatMsg, Object ... args) {
        LogUtils.push(LogLevel.INFO, formatMsg, args);
    }

    public void log(LogLevel logLevel, String formatMsg, Object ... args) {
        LogUtils.push(logLevel, formatMsg, args);
    }

    public void exportLog() {
        LogUtils.export();
    }

    public String getBody() {
        if (!"POST".equals(this.method) || StringUtils.startsWithIgnoreCase((String)this.request.getContentType(), (String)"multipart/")) {
            return null;
        }
        if (this.body == null) {
            try {
                this.body = new BufferedReader(new InputStreamReader((InputStream)this.request.getInputStream())).lines().collect(Collectors.joining(System.lineSeparator()));
            }
            catch (IOException e) {
                LogUtils.error("read body error", new Object[0]);
                return null;
            }
        }
        return this.body;
    }

    public void setToken(AccessToken token) {
        if (this.token == null && token != null) {
            this.token = token;
            this.userId = token.getUserId();
        }
    }

    public boolean hasToken() {
        return this.token != null;
    }

    public HttpMeta(HttpServletRequest request, String uri, String api, String method, String path) {
        this.request = request;
        this.refer = request.getHeader("Referer");
        this.ip = IPUtils.getIp(request);
        this.method = method.toUpperCase();
        this.userAgent = request.getHeader("user-agent");
        this.servletPath = request.getServletPath();
        this.uri = uri;
        this.api = api;
        this.path = path;
    }

    public boolean isMethod(String method) {
        if (method != null) {
            return this.method.equals(method.toUpperCase());
        }
        return false;
    }

    public boolean isHasApiAuth() {
        PermRolesMeta permRolesMeta;
        if (this.hasApiAuth != null) {
            return this.hasApiAuth;
        }
        Map<String, PermRolesMeta> map = PermissionDict.getRolePermission().get(this.api);
        PermRolesMeta cPermRolesMeta = PermissionDict.getControllerRolePermission().get(this.controller);
        if (map == null && cPermRolesMeta == null) {
            this.hasApiAuth = false;
            return this.hasApiAuth;
        }
        this.hasApiAuth = map != null ? Boolean.valueOf((permRolesMeta = map.get(this.method)) != null && !permRolesMeta.non() || cPermRolesMeta != null && !cPermRolesMeta.non()) : Boolean.valueOf(cPermRolesMeta != null && !cPermRolesMeta.non());
        return this.hasApiAuth;
    }

    public boolean isHasParamAuth() {
        if (this.hasParamAuth != null) {
            return this.requireLogin;
        }
        Map<String, Map<String, ParamMetadata>> map = PermissionDict.getParamPermission().get(this.api);
        if (map == null || map.get(this.method) == null) {
            this.hasParamAuth = false;
            return this.hasParamAuth;
        }
        this.hasParamAuth = map.get(this.method).values().stream().anyMatch(v -> v.hasParamAuth());
        return this.hasParamAuth;
    }

    public boolean isRequireLogin() {
        if (this.requireLogin != null) {
            return this.requireLogin;
        }
        Set<String> list = PermissionDict.getCertificatedMetadata().get(this.api);
        boolean contains = PermissionDict.getControllerCertificatedMetadata().contains(this.controller);
        if (list == null || list.isEmpty()) {
            this.requireLogin = this.isHasApiAuth() || this.isHasParamAuth() || contains;
            return this.requireLogin;
        }
        this.requireLogin = contains || list.contains(this.method) || this.isHasApiAuth() || this.isHasParamAuth();
        return this.requireLogin;
    }

    public String getIp() {
        return this.ip;
    }

    public String getUri() {
        return this.uri;
    }

    public String getApi() {
        return this.api;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public String getRefer() {
        return this.refer;
    }

    public AccessToken getToken() {
        return this.token;
    }

    public Object getUserId() {
        return this.userId;
    }

    public PermRolesMeta getPermRolesMeta() {
        return this.permRolesMeta;
    }

    public Boolean getHasApiAuth() {
        return this.hasApiAuth;
    }

    public Boolean getHasParamAuth() {
        return this.hasParamAuth;
    }

    public Boolean getRequireLogin() {
        return this.requireLogin;
    }

    public String getController() {
        return this.controller;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public boolean isClearCookie() {
        return this.clearCookie;
    }

    public UserDevicesDict.UserStatus getUserStatus() {
        return this.userStatus;
    }

    public LinkedList<Object> getExceptionObjectList() {
        return this.exceptionObjectList;
    }

    public LinkedList<ExceptionStatus> getExceptionStatusList() {
        return this.exceptionStatusList;
    }

    public Date getNow() {
        return this.now;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setApi(String api) {
        this.api = api;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public void setRefer(String refer) {
        this.refer = refer;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setUserId(Object userId) {
        this.userId = userId;
    }

    public void setScope(Set<String> scope) {
        this.scope = scope;
    }

    public void setPermRolesMeta(PermRolesMeta permRolesMeta) {
        this.permRolesMeta = permRolesMeta;
    }

    public void setHasApiAuth(Boolean hasApiAuth) {
        this.hasApiAuth = hasApiAuth;
    }

    public void setHasParamAuth(Boolean hasParamAuth) {
        this.hasParamAuth = hasParamAuth;
    }

    public void setRequireLogin(Boolean requireLogin) {
        this.requireLogin = requireLogin;
    }

    public void setController(String controller) {
        this.controller = controller;
    }

    @JsonIgnore
    public void setRequest(HttpServletRequest request) {
        this.request = request;
    }

    @JsonIgnore
    public void setClearCookie(boolean clearCookie) {
        this.clearCookie = clearCookie;
    }

    @JsonIgnore
    public void setUserStatus(UserDevicesDict.UserStatus userStatus) {
        this.userStatus = userStatus;
    }

    @JsonIgnore
    public void setExceptionObjectList(LinkedList<Object> exceptionObjectList) {
        this.exceptionObjectList = exceptionObjectList;
    }

    @JsonIgnore
    public void setExceptionStatusList(LinkedList<ExceptionStatus> exceptionStatusList) {
        this.exceptionStatusList = exceptionStatusList;
    }

    public void setNow(Date now) {
        this.now = now;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpMeta)) {
            return false;
        }
        HttpMeta other = (HttpMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isClearCookie() != other.isClearCookie()) {
            return false;
        }
        Boolean this$hasApiAuth = this.getHasApiAuth();
        Boolean other$hasApiAuth = other.getHasApiAuth();
        if (this$hasApiAuth == null ? other$hasApiAuth != null : !((Object)this$hasApiAuth).equals(other$hasApiAuth)) {
            return false;
        }
        Boolean this$hasParamAuth = this.getHasParamAuth();
        Boolean other$hasParamAuth = other.getHasParamAuth();
        if (this$hasParamAuth == null ? other$hasParamAuth != null : !((Object)this$hasParamAuth).equals(other$hasParamAuth)) {
            return false;
        }
        Boolean this$requireLogin = this.getRequireLogin();
        Boolean other$requireLogin = other.getRequireLogin();
        if (this$requireLogin == null ? other$requireLogin != null : !((Object)this$requireLogin).equals(other$requireLogin)) {
            return false;
        }
        String this$ip = this.getIp();
        String other$ip = other.getIp();
        if (this$ip == null ? other$ip != null : !this$ip.equals(other$ip)) {
            return false;
        }
        String this$uri = this.getUri();
        String other$uri = other.getUri();
        if (this$uri == null ? other$uri != null : !this$uri.equals(other$uri)) {
            return false;
        }
        String this$api = this.getApi();
        String other$api = other.getApi();
        if (this$api == null ? other$api != null : !this$api.equals(other$api)) {
            return false;
        }
        String this$servletPath = this.getServletPath();
        String other$servletPath = other.getServletPath();
        if (this$servletPath == null ? other$servletPath != null : !this$servletPath.equals(other$servletPath)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$userAgent = this.getUserAgent();
        String other$userAgent = other.getUserAgent();
        if (this$userAgent == null ? other$userAgent != null : !this$userAgent.equals(other$userAgent)) {
            return false;
        }
        String this$refer = this.getRefer();
        String other$refer = other.getRefer();
        if (this$refer == null ? other$refer != null : !this$refer.equals(other$refer)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        AccessToken this$token = this.getToken();
        AccessToken other$token = other.getToken();
        if (this$token == null ? other$token != null : !((Object)this$token).equals(other$token)) {
            return false;
        }
        Object this$userId = this.getUserId();
        Object other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        Set<String> this$roles = this.getRoles();
        Set<String> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        Set<String> this$permissions = this.getPermissions();
        Set<String> other$permissions = other.getPermissions();
        if (this$permissions == null ? other$permissions != null : !((Object)this$permissions).equals(other$permissions)) {
            return false;
        }
        Set<String> this$scope = this.getScope();
        Set<String> other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope)) {
            return false;
        }
        PermRolesMeta this$permRolesMeta = this.getPermRolesMeta();
        PermRolesMeta other$permRolesMeta = other.getPermRolesMeta();
        if (this$permRolesMeta == null ? other$permRolesMeta != null : !this$permRolesMeta.equals(other$permRolesMeta)) {
            return false;
        }
        String this$controller = this.getController();
        String other$controller = other.getController();
        if (this$controller == null ? other$controller != null : !this$controller.equals(other$controller)) {
            return false;
        }
        HttpServletRequest this$request = this.getRequest();
        HttpServletRequest other$request = other.getRequest();
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        UserDevicesDict.UserStatus this$userStatus = this.getUserStatus();
        UserDevicesDict.UserStatus other$userStatus = other.getUserStatus();
        if (this$userStatus == null ? other$userStatus != null : !((Object)((Object)this$userStatus)).equals((Object)other$userStatus)) {
            return false;
        }
        LinkedList<Object> this$exceptionObjectList = this.getExceptionObjectList();
        LinkedList<Object> other$exceptionObjectList = other.getExceptionObjectList();
        if (this$exceptionObjectList == null ? other$exceptionObjectList != null : !((Object)this$exceptionObjectList).equals(other$exceptionObjectList)) {
            return false;
        }
        LinkedList<ExceptionStatus> this$exceptionStatusList = this.getExceptionStatusList();
        LinkedList<ExceptionStatus> other$exceptionStatusList = other.getExceptionStatusList();
        if (this$exceptionStatusList == null ? other$exceptionStatusList != null : !((Object)this$exceptionStatusList).equals(other$exceptionStatusList)) {
            return false;
        }
        Date this$now = this.getNow();
        Date other$now = other.getNow();
        return !(this$now == null ? other$now != null : !((Object)this$now).equals(other$now));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpMeta;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isClearCookie() ? 79 : 97);
        Boolean $hasApiAuth = this.getHasApiAuth();
        result = result * 59 + ($hasApiAuth == null ? 43 : ((Object)$hasApiAuth).hashCode());
        Boolean $hasParamAuth = this.getHasParamAuth();
        result = result * 59 + ($hasParamAuth == null ? 43 : ((Object)$hasParamAuth).hashCode());
        Boolean $requireLogin = this.getRequireLogin();
        result = result * 59 + ($requireLogin == null ? 43 : ((Object)$requireLogin).hashCode());
        String $ip = this.getIp();
        result = result * 59 + ($ip == null ? 43 : $ip.hashCode());
        String $uri = this.getUri();
        result = result * 59 + ($uri == null ? 43 : $uri.hashCode());
        String $api = this.getApi();
        result = result * 59 + ($api == null ? 43 : $api.hashCode());
        String $servletPath = this.getServletPath();
        result = result * 59 + ($servletPath == null ? 43 : $servletPath.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $userAgent = this.getUserAgent();
        result = result * 59 + ($userAgent == null ? 43 : $userAgent.hashCode());
        String $refer = this.getRefer();
        result = result * 59 + ($refer == null ? 43 : $refer.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        AccessToken $token = this.getToken();
        result = result * 59 + ($token == null ? 43 : ((Object)$token).hashCode());
        Object $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        Set<String> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        Set<String> $permissions = this.getPermissions();
        result = result * 59 + ($permissions == null ? 43 : ((Object)$permissions).hashCode());
        Set<String> $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
        PermRolesMeta $permRolesMeta = this.getPermRolesMeta();
        result = result * 59 + ($permRolesMeta == null ? 43 : $permRolesMeta.hashCode());
        String $controller = this.getController();
        result = result * 59 + ($controller == null ? 43 : $controller.hashCode());
        HttpServletRequest $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        UserDevicesDict.UserStatus $userStatus = this.getUserStatus();
        result = result * 59 + ($userStatus == null ? 43 : ((Object)((Object)$userStatus)).hashCode());
        LinkedList<Object> $exceptionObjectList = this.getExceptionObjectList();
        result = result * 59 + ($exceptionObjectList == null ? 43 : ((Object)$exceptionObjectList).hashCode());
        LinkedList<ExceptionStatus> $exceptionStatusList = this.getExceptionStatusList();
        result = result * 59 + ($exceptionStatusList == null ? 43 : ((Object)$exceptionStatusList).hashCode());
        Date $now = this.getNow();
        result = result * 59 + ($now == null ? 43 : ((Object)$now).hashCode());
        return result;
    }

    public String toString() {
        return "HttpMeta(ip=" + this.getIp() + ", uri=" + this.getUri() + ", api=" + this.getApi() + ", servletPath=" + this.getServletPath() + ", path=" + this.getPath() + ", method=" + this.getMethod() + ", userAgent=" + this.getUserAgent() + ", refer=" + this.getRefer() + ", body=" + this.getBody() + ", token=" + this.getToken() + ", userId=" + this.getUserId() + ", roles=" + this.getRoles() + ", permissions=" + this.getPermissions() + ", scope=" + this.getScope() + ", permRolesMeta=" + this.getPermRolesMeta() + ", hasApiAuth=" + this.getHasApiAuth() + ", hasParamAuth=" + this.getHasParamAuth() + ", requireLogin=" + this.getRequireLogin() + ", controller=" + this.getController() + ", request=" + this.getRequest() + ", clearCookie=" + this.isClearCookie() + ", userStatus=" + (Object)((Object)this.getUserStatus()) + ", exceptionObjectList=" + this.getExceptionObjectList() + ", exceptionStatusList=" + this.getExceptionStatusList() + ", now=" + this.getNow() + ")";
    }

    public HttpMeta() {
    }
}

