/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.ipf;

import cn.omisheep.authz.core.AuthzManager;
import cn.omisheep.authz.core.msg.AuthzModifier;
import cn.omisheep.authz.core.tk.AccessToken;
import cn.omisheep.authz.support.util.IPAddress;
import cn.omisheep.authz.support.util.IPRange;
import cn.omisheep.commons.util.TimeUtils;
import cn.omisheep.web.entity.Result;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import orestes.bloomfilter.CountingBloomFilter;
import orestes.bloomfilter.FilterBuilder;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class Blacklist {
    private static final Set<IP> ipBlacklist = new CopyOnWriteArraySet<IP>();
    private static final CountingBloomFilter<String> ipBlacklistBloomFilter = new FilterBuilder(1000, 0.001).countingBits(8).buildCountingBloomFilter();
    private static final Set<User> userBlacklist = new CopyOnWriteArraySet<User>();
    private static final CountingBloomFilter<String> userBlacklistBloomFilter = new FilterBuilder(1000, 0.001).countingBits(8).buildCountingBloomFilter();
    private static final Set<IPRangeDeny> ipRangeBlacklist = new CopyOnWriteArraySet<IPRangeDeny>();

    public static boolean check(@NonNull String ip, @Nullable Object userId, @Nullable String deviceType, @Nullable String deviceId) {
        return IP.check(ip) && IPRangeDeny.check(ip) && User.check(userId, deviceType, deviceId);
    }

    public static boolean check(@NonNull String ip, @Nullable AccessToken accessToken) {
        if (accessToken == null) {
            return Blacklist.check(ip);
        }
        return IP.check(ip) && IPRangeDeny.check(ip) && User.check(accessToken.getUserId(), accessToken.getDeviceType(), accessToken.getDeviceId());
    }

    public static boolean check(String ip) {
        return IP.check(ip) && IPRangeDeny.check(ip);
    }

    public static Map<String, Object> readAll() {
        HashMap<String, Set<Object>> map = new HashMap<String, Set<Object>>();
        map.put("ipBlacklist", ipBlacklist);
        map.put("userBlacklist", userBlacklist);
        map.put("ipRangeBlacklist", ipRangeBlacklist);
        return Collections.unmodifiableMap(map);
    }

    public static Object modify(AuthzModifier modifier) throws ParseException {
        AuthzModifier.BlacklistInfo blacklistInfo = modifier.getBlacklistInfo();
        long time = blacklistInfo.getTime();
        block0 : switch (blacklistInfo.getType()) {
            case IP: {
                String ip = blacklistInfo.getIp();
                switch (blacklistInfo.getOp()) {
                    case UPDATE: {
                        Date date = TimeUtils.formatParse((String)blacklistInfo.getDate());
                        if (date == null) {
                            IP._update(ip, time);
                            break block0;
                        }
                        IP._update(ip, date);
                        break block0;
                    }
                    case REMOVE: {
                        IP._remove(ip);
                        break block0;
                    }
                    case READ: {
                        return Result.SUCCESS.data(ipBlacklist);
                    }
                }
                break;
            }
            case IP_RANGE: {
                String ipRange = blacklistInfo.getIpRange();
                switch (blacklistInfo.getOp()) {
                    case UPDATE: {
                        Date date = TimeUtils.formatParse((String)blacklistInfo.getDate());
                        if (date == null) {
                            IPRangeDeny._update(ipRange, time);
                            break block0;
                        }
                        IPRangeDeny._update(ipRange, date);
                        break block0;
                    }
                    case REMOVE: {
                        IPRangeDeny._remove(ipRange);
                        break block0;
                    }
                    case READ: {
                        return Result.SUCCESS.data(ipRangeBlacklist);
                    }
                }
                break;
            }
            case USER: 
            case DEVICE: {
                Object userId = blacklistInfo.getUserId();
                String deviceType = blacklistInfo.getDeviceType();
                String deviceId = blacklistInfo.getDeviceId();
                switch (blacklistInfo.getOp()) {
                    case UPDATE: {
                        Date date = TimeUtils.formatParse((String)blacklistInfo.getDate());
                        if (date == null) {
                            User._update(userId, deviceType, deviceId, time);
                            break block0;
                        }
                        User._update(userId, deviceType, deviceId, date);
                        break block0;
                    }
                    case REMOVE: {
                        User._remove(userId, deviceType, deviceId);
                        break block0;
                    }
                    case READ: {
                        return Result.SUCCESS.data(userBlacklist);
                    }
                }
            }
        }
        return Result.SUCCESS;
    }

    private Blacklist() {
        throw new UnsupportedOperationException();
    }

    private static AuthzModifier.BlacklistInfo _create(AuthzModifier.BlacklistInfo.TYPE type, AuthzModifier.BlacklistInfo.OP op) {
        return new AuthzModifier.BlacklistInfo().setType(type).setOp(op);
    }

    private static void _op(AuthzModifier.BlacklistInfo blacklistInfo) {
        AuthzModifier authzModifier = new AuthzModifier().setTarget(AuthzModifier.Target.BLACKLIST).setBlacklistInfo(blacklistInfo);
        AuthzManager.operate(authzModifier);
    }

    public static class TimeMeta {
        private final long _end;
        private final long _time;

        public String getTime() {
            return TimeUtils.parseTime((long)this._time);
        }

        public String getEnd() {
            return TimeUtils.format((Date)new Date(this._end));
        }

        private TimeMeta(long time) {
            this._time = time;
            this._end = TimeUtils.nowTime() + this._time;
        }

        private TimeMeta(Date endDate) {
            this._time = endDate.getTime() - TimeUtils.nowTime();
            this._end = endDate.getTime();
        }

        private static TimeMeta of(long time) {
            return new TimeMeta(time);
        }

        private static TimeMeta of(Date endDate) {
            return new TimeMeta(endDate);
        }

        private boolean relive() {
            return TimeUtils.nowTime() >= this._end;
        }
    }

    public static class IPRangeDeny {
        @JsonIgnore
        private final String value;
        private final IPRange ipRange;
        private final TimeMeta timeMeta;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IPRangeDeny)) {
                return false;
            }
            IPRangeDeny that = (IPRangeDeny)o;
            return new EqualsBuilder().append((Object)this.getValue(), (Object)that.getValue()).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.getValue()).toHashCode();
        }

        public IPRangeDeny(String ipRange, TimeMeta timeMeta) {
            this.value = ipRange;
            this.ipRange = new IPRange(ipRange);
            this.timeMeta = timeMeta;
        }

        private static void _update(String ipRange, Date endDate) {
            IPRangeDeny _ipRange = new IPRangeDeny(ipRange, TimeMeta.of(endDate));
            ipRangeBlacklist.remove(_ipRange);
            ipRangeBlacklist.add(_ipRange);
        }

        private static void _update(String ipRange, long time) {
            IPRangeDeny _ipRange = new IPRangeDeny(ipRange, TimeMeta.of(time));
            ipRangeBlacklist.remove(_ipRange);
            ipRangeBlacklist.add(_ipRange);
        }

        public static void update(String ipRange, long time) {
            Blacklist._op(Blacklist._create(AuthzModifier.BlacklistInfo.TYPE.IP_RANGE, AuthzModifier.BlacklistInfo.OP.UPDATE).setTime(time).setIpRange(ipRange));
        }

        public static void update(String ipRange, Date endDate) {
            Blacklist._op(Blacklist._create(AuthzModifier.BlacklistInfo.TYPE.IP_RANGE, AuthzModifier.BlacklistInfo.OP.UPDATE).setDate(TimeUtils.format((Date)endDate)).setIpRange(ipRange));
        }

        private static void _remove(String ipRange) {
            ipRangeBlacklist.remove(new IPRangeDeny(ipRange, null));
        }

        public static void remove(String ipRange) {
            Blacklist._op(Blacklist._create(AuthzModifier.BlacklistInfo.TYPE.IP_RANGE, AuthzModifier.BlacklistInfo.OP.REMOVE).setIpRange(ipRange));
        }

        public static boolean check(String ip) {
            AtomicBoolean hit = new AtomicBoolean(false);
            ipRangeBlacklist.removeIf(v -> {
                boolean relive = v.timeMeta.relive();
                if (!relive && v.ipRange.isIPAddressInRange(new IPAddress(ip))) {
                    hit.set(true);
                }
                return relive;
            });
            return !hit.get();
        }

        public static Set<IPRangeDeny> list() {
            return Collections.unmodifiableSet(ipRangeBlacklist);
        }

        public String getValue() {
            return this.value;
        }

        public IPRange getIpRange() {
            return this.ipRange;
        }

        public TimeMeta getTimeMeta() {
            return this.timeMeta;
        }

        public String toString() {
            return "Blacklist.IPRangeDeny(value=" + this.getValue() + ", ipRange=" + this.getIpRange() + ", timeMeta=" + this.getTimeMeta() + ")";
        }
    }

    public static class IP {
        private final String ip;
        private final TimeMeta timeMeta;

        public IP(String ip, TimeMeta timeMeta) {
            this.ip = ip;
            this.timeMeta = timeMeta;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof IP)) {
                return false;
            }
            IP ip1 = (IP)o;
            return new EqualsBuilder().append((Object)this.getIp(), (Object)ip1.getIp()).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.getIp()).toHashCode();
        }

        private static void _update(String ip, long time) {
            IP _ip = new IP(ip, TimeMeta.of(time));
            ipBlacklist.remove(_ip);
            ipBlacklist.add(_ip);
            ipBlacklistBloomFilter.add((Object)ip);
        }

        private static void _update(String ip, Date endDate) {
            IP _ip = new IP(ip, TimeMeta.of(endDate));
            ipBlacklist.remove(_ip);
            ipBlacklist.add(_ip);
            ipBlacklistBloomFilter.add((Object)ip);
        }

        public static void update(String ip, long time) {
            Blacklist._op(Blacklist._create(AuthzModifier.BlacklistInfo.TYPE.IP, AuthzModifier.BlacklistInfo.OP.UPDATE).setIp(ip).setTime(time));
        }

        public static void update(String ip, Date endDate) {
            Blacklist._op(Blacklist._create(AuthzModifier.BlacklistInfo.TYPE.IP, AuthzModifier.BlacklistInfo.OP.UPDATE).setIp(ip).setDate(TimeUtils.format((Date)endDate)));
        }

        private static void _remove(String ip) {
            ipBlacklist.remove(new IP(ip, null));
            ipBlacklistBloomFilter.remove((Object)ip);
        }

        public static void remove(String ip) {
            Blacklist._op(Blacklist._create(AuthzModifier.BlacklistInfo.TYPE.IP, AuthzModifier.BlacklistInfo.OP.REMOVE).setIp(ip));
        }

        @Nullable
        public static IP get(String ip) {
            AtomicReference i = new AtomicReference();
            ipBlacklist.removeIf(o -> {
                if (o.ip.equals(ip)) {
                    i.set(o);
                }
                return o.timeMeta.relive();
            });
            return (IP)i.get();
        }

        public static boolean check(String ip) {
            if (ipBlacklistBloomFilter.contains((Object)ip)) {
                IP _ip = IP.get(ip);
                if (_ip == null) {
                    return true;
                }
                if (_ip.timeMeta.relive()) {
                    ipBlacklistBloomFilter.remove((Object)ip);
                    ipBlacklist.remove(_ip);
                    return true;
                }
                return false;
            }
            return true;
        }

        public static Set<IP> list() {
            return Collections.unmodifiableSet(ipBlacklist);
        }

        public String getIp() {
            return this.ip;
        }

        public TimeMeta getTimeMeta() {
            return this.timeMeta;
        }

        public String toString() {
            return "Blacklist.IP(ip=" + this.getIp() + ", timeMeta=" + this.getTimeMeta() + ")";
        }
    }

    public static class User {
        final Object userId;
        @Nullable
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        final String deviceType;
        @Nullable
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        final String deviceId;
        final TimeMeta timeMeta;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof User)) {
                return false;
            }
            User user = (User)o;
            return new EqualsBuilder().append(this.getUserId(), user.getUserId()).append((Object)this.getDeviceType(), (Object)user.getDeviceType()).append((Object)this.getDeviceId(), (Object)user.getDeviceId()).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append(this.getUserId()).append((Object)this.getDeviceType()).append((Object)this.getDeviceId()).toHashCode();
        }

        public User(Object userId, @Nullable String deviceType, @Nullable String deviceId, TimeMeta timeMeta) {
            this.userId = userId;
            this.deviceId = deviceId;
            this.deviceType = deviceType;
            this.timeMeta = timeMeta;
        }

        private static void _update(Object userId, @Nullable String deviceType, @Nullable String deviceId, long time) {
            User _user = new User(userId, deviceType, deviceId, TimeMeta.of(time));
            userBlacklist.remove(_user);
            userBlacklist.add(_user);
            userBlacklistBloomFilter.add((Object)userId.toString());
        }

        private static void _update(Object userId, @Nullable String deviceType, @Nullable String deviceId, Date endDate) {
            User _user = new User(userId, deviceType, deviceId, TimeMeta.of(endDate));
            userBlacklist.remove(_user);
            userBlacklist.add(_user);
            userBlacklistBloomFilter.add((Object)userId.toString());
        }

        public static void update(Object userId, @Nullable String deviceType, @Nullable String deviceId, long time) {
            Blacklist._op(User._createUser(userId, deviceType, deviceId, AuthzModifier.BlacklistInfo.OP.UPDATE).setTime(time));
        }

        public static void update(Object userId, @Nullable String deviceType, @Nullable String deviceId, Date endDate) {
            Blacklist._op(User._createUser(userId, deviceType, deviceId, AuthzModifier.BlacklistInfo.OP.UPDATE).setDate(TimeUtils.format((Date)endDate)));
        }

        private static AuthzModifier.BlacklistInfo _createUser(Object userId, @Nullable String deviceType, @Nullable String deviceId, AuthzModifier.BlacklistInfo.OP op) {
            return Blacklist._create(AuthzModifier.BlacklistInfo.TYPE.USER, op).setUserId(userId).setDeviceType(deviceType).setDeviceId(deviceId);
        }

        private static void _remove(Object userId, @Nullable String deviceType, @Nullable String deviceId) {
            userBlacklist.remove(new User(userId, deviceType, deviceId, null));
            userBlacklistBloomFilter.remove((Object)userId.toString());
        }

        public static void remove(Object userId, @Nullable String deviceType, @Nullable String deviceId) {
            Blacklist._op(Blacklist._create(AuthzModifier.BlacklistInfo.TYPE.USER, AuthzModifier.BlacklistInfo.OP.REMOVE).setUserId(userId).setDeviceType(deviceType).setDeviceId(deviceId));
        }

        @Nullable
        public static User getDevice(Object userId, @Nullable String deviceType, @Nullable String deviceId) {
            return userBlacklist.stream().filter(u -> u.userId.equals(userId) && StringUtils.equals((String)u.deviceType, (String)deviceType) && StringUtils.equals((String)u.deviceId, (String)deviceId)).findFirst().orElse(null);
        }

        public static User getUser(Object userId) {
            return User.list(userId).stream().filter(v -> v.getDeviceType() == null && v.getDeviceId() == null).findAny().orElse(null);
        }

        public static Set<User> list(Object userId) {
            HashSet<User> users = new HashSet<User>();
            userBlacklist.removeIf(u -> {
                if (u.timeMeta.relive()) {
                    return true;
                }
                if (u.userId.equals(userId)) {
                    users.add((User)u);
                }
                return false;
            });
            return users;
        }

        public static Set<User> list() {
            return Collections.unmodifiableSet(userBlacklist);
        }

        public static boolean check(@Nullable Object userId, @Nullable String deviceType, @Nullable String deviceId) {
            if (userId == null) {
                return true;
            }
            if (userBlacklistBloomFilter.contains((Object)userId.toString())) {
                Set<User> list = User.list(userId);
                boolean hit = list.stream().anyMatch(user -> {
                    if (user.timeMeta.relive()) {
                        return false;
                    }
                    if (user.deviceType == null && user.deviceId == null) {
                        return true;
                    }
                    if (user.deviceType != null && user.deviceId != null) {
                        return StringUtils.equals((String)user.deviceType, (String)deviceType) && StringUtils.equals((String)user.deviceId, (String)deviceId);
                    }
                    if (user.deviceType != null) {
                        return StringUtils.equals((String)user.deviceType, (String)deviceType);
                    }
                    return false;
                });
                for (User user2 : list) {
                    if (!user2.timeMeta.relive()) continue;
                    userBlacklist.remove(user2);
                }
                if (list.isEmpty()) {
                    userBlacklistBloomFilter.remove((Object)userId.toString());
                }
                return !hit;
            }
            return true;
        }

        public Object getUserId() {
            return this.userId;
        }

        @Nullable
        public String getDeviceType() {
            return this.deviceType;
        }

        @Nullable
        public String getDeviceId() {
            return this.deviceId;
        }

        public TimeMeta getTimeMeta() {
            return this.timeMeta;
        }

        public String toString() {
            return "Blacklist.User(userId=" + this.getUserId() + ", deviceType=" + this.getDeviceType() + ", deviceId=" + this.getDeviceId() + ", timeMeta=" + this.getTimeMeta() + ")";
        }
    }
}

