/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.ipf;

import cn.omisheep.authz.core.AuthzContext;
import cn.omisheep.authz.core.ExceptionStatus;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.ipf.Httpd;
import cn.omisheep.authz.core.config.Constants;
import cn.omisheep.authz.core.util.FormatUtils;
import cn.omisheep.web.utils.BufferedServletRequestWrapper;
import cn.omisheep.web.utils.HttpUtils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.filter.OncePerRequestFilter;

public class AuthzHttpFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(AuthzHttpFilter.class);
    private final boolean isDashboard;

    public AuthzHttpFilter(boolean isDashboard) {
        this.isDashboard = isDashboard;
    }

    public void doFilterInternal(HttpServletRequest rrequest, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        Object request = StringUtils.startsWithIgnoreCase((String)rrequest.getContentType(), (String)"multipart/") ? rrequest : new BufferedServletRequestWrapper(rrequest);
        String uri = request.getRequestURI();
        String method = request.getMethod();
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        HttpUtils.request.set(request);
        if (FormatUtils.isIgnoreSuffix(uri, Constants.SUFFIX) || this.isDashboard && (servletPath.equals("/authz-dashboard-favicon.ico") || servletPath.startsWith("/authz-api") || servletPath.startsWith("/authz-dashboard-static") || servletPath.startsWith("/authz.html"))) {
            HttpMeta httpMeta = new HttpMeta((HttpServletRequest)request, uri, null, method, uri);
            request.setAttribute("AU_HTTP_META", (Object)httpMeta);
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            AuthzContext.httpMeta.set(httpMeta);
            return;
        }
        String api = Httpd.getPattern(method, servletPath);
        HttpMeta httpMeta = new HttpMeta((HttpServletRequest)request, uri, api == null ? servletPath : api, method, servletPath);
        if (api == null) {
            httpMeta.error(ExceptionStatus.MISMATCHED_URL);
        }
        AuthzContext.httpMeta.set(httpMeta);
        request.setAttribute("AU_HTTP_META", (Object)httpMeta);
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

