/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.deviced;

import cn.omisheep.authz.AuHelper;
import cn.omisheep.authz.core.AuthzContext;
import cn.omisheep.authz.core.AuthzProperties;
import cn.omisheep.authz.core.auth.deviced.DefaultDevice;
import cn.omisheep.authz.core.auth.deviced.DefaultRequestDetails;
import cn.omisheep.authz.core.auth.deviced.Device;
import cn.omisheep.authz.core.auth.deviced.DeviceCountInfo;
import cn.omisheep.authz.core.auth.deviced.DeviceDetails;
import cn.omisheep.authz.core.auth.deviced.RequestDetails;
import cn.omisheep.authz.core.auth.deviced.UserDevicesDict;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.cache.Cache;
import cn.omisheep.authz.core.tk.AccessToken;
import cn.omisheep.authz.core.tk.GrantType;
import cn.omisheep.authz.core.tk.RefreshToken;
import cn.omisheep.authz.core.tk.TokenPair;
import cn.omisheep.commons.util.Async;
import cn.omisheep.commons.util.TimeUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDevicesDictByCache
implements UserDevicesDict {
    private static final Logger log = LoggerFactory.getLogger(UserDevicesDictByCache.class);
    private final AuthzProperties properties;
    private final Cache cache;
    private final Map<Object, CompletableFuture<Void>> cleanCache = new ConcurrentHashMap<Object, CompletableFuture<Void>>();

    public UserDevicesDictByCache(AuthzProperties properties, Cache cache) {
        this.properties = properties;
        this.cache = cache;
    }

    @Override
    public UserDevicesDict.UserStatus userStatus(AccessToken accessToken) {
        String accessTokenId = accessToken.getTokenId();
        String clientId = accessToken.getClientId();
        Device device = clientId == null ? this.cache.get(UserDevicesDict.key(accessToken), Device.class) : this.cache.get(UserDevicesDict.oauthKey(accessToken), Device.class);
        if (device == null) {
            return UserDevicesDict.UserStatus.REQUIRE_LOGIN;
        }
        if (clientId != null) {
            if (!StringUtils.equals((String)device.getClientId(), (String)clientId)) {
                return UserDevicesDict.UserStatus.REQUIRE_LOGIN;
            }
        } else if (!StringUtils.equals((String)device.getAccessTokenId(), (String)accessTokenId)) {
            return UserDevicesDict.UserStatus.LOGIN_EXCEPTION;
        }
        return UserDevicesDict.UserStatus.SUCCESS;
    }

    @Override
    public void addUser(TokenPair tokenPair, HttpMeta httpMeta) {
        Long expiredIn;
        Date expiresAt;
        if (tokenPair == null || tokenPair.getAccessToken() == null || tokenPair.getRefreshToken() == null) {
            return;
        }
        AccessToken accessToken = tokenPair.getAccessToken();
        if (GrantType.CLIENT_CREDENTIALS.equals((Object)accessToken.getGrantType())) {
            expiresAt = new Date(accessToken.getExpiresAt());
            expiredIn = accessToken.getExpiresIn();
        } else {
            RefreshToken refreshToken = tokenPair.getRefreshToken();
            expiresAt = new Date(refreshToken.getExpiresAt());
            expiredIn = refreshToken.getExpiresIn();
        }
        Device device = new DefaultDevice().setAccessTokenId(accessToken.getTokenId());
        String clientId = accessToken.getClientId();
        if (clientId != null) {
            String scope = accessToken.getScope();
            GrantType grantType = accessToken.getGrantType();
            device.setScope(scope).setGrantType(grantType).setClientId(clientId).setAuthorizedDate(httpMeta.getNow()).setExpiresDate(expiresAt);
            String key = UserDevicesDict.oauthKey(accessToken);
            this.cache.set(key, device, expiredIn);
        } else {
            String deviceType = accessToken.getDeviceType();
            String deviceId = accessToken.getDeviceId();
            String key = UserDevicesDict.key(accessToken);
            String rKey = UserDevicesDict.requestKey(accessToken);
            device.setDeviceType(deviceType).setDeviceId(deviceId);
            if (this.properties.getToken().isLogoutBeforeLogin()) {
                this.removeCurrentDevice();
            }
            this.cache.set(key, device, expiredIn);
            Object userId = accessToken.getUserId();
            Runnable run = () -> this.clean(userId, deviceType, deviceId, key, rKey);
            CompletableFuture<Void> future = this.cleanCache.get(userId);
            if (future == null || Async.isSuccessFuture(future)) {
                this.cleanCache.put(userId, Async.run((Runnable)run));
            } else {
                future.thenRun(run);
            }
        }
    }

    @Override
    public boolean refreshUser(TokenPair tokenPair) {
        if (tokenPair == null) {
            return false;
        }
        String key = UserDevicesDict.key(tokenPair.getRefreshToken());
        Device device = this.cache.get(key, Device.class);
        if (device == null) {
            return false;
        }
        AccessToken accessToken = tokenPair.getAccessToken();
        Long expiredAt = tokenPair.getRefreshToken().getExpiresAt();
        device.setAccessTokenId(accessToken.getTokenId());
        Async.run(() -> {
            this.cache.set(UserDevicesDict.key(accessToken), device, expiredAt - TimeUtils.nowTime());
            this.cache.del(key);
        });
        return true;
    }

    @Override
    public void removeAccessTokenByTid(Object userId, String tid) {
        String key = UserDevicesDict.key(userId, tid);
        Device device = this.cache.get(key, Device.class);
        if (device == null) {
            return;
        }
        device.setAccessTokenId(null);
        this.cache.set(key, device);
    }

    @Override
    public void removeDeviceById(Object userId, String id) {
        this.cache.del(UserDevicesDict.key(userId, id));
    }

    @Override
    public void removeAllDevice(Object userId) {
        Async.run(() -> this.cache.del(this.cache.keys(UserDevicesDict.key(userId, "*"))));
    }

    @Override
    public void removeCurrentDevice() {
        try {
            this.cache.del(UserDevicesDict.key(AuHelper.getToken()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean isLogin(Object userId, String id) {
        return !this.cache.notKey(UserDevicesDict.key(userId, id));
    }

    @Override
    public void removeDevice(Object userId, String deviceType, String deviceId) {
        if (deviceType == null || deviceType.equals("")) {
            return;
        }
        Map<String, Device> deviceMap = this.cache.get(this.cache.keys(UserDevicesDict.key(userId, "*")), Device.class);
        Set dels = deviceMap.entrySet().stream().filter(e -> StringUtils.equals((String)((Device)e.getValue()).getDeviceType(), (String)deviceType)).filter(e -> deviceId == null || StringUtils.equals((String)((Device)e.getValue()).getDeviceType(), (String)deviceId)).map(Map.Entry::getKey).collect(Collectors.toSet());
        Async.run(() -> this.cache.del(dels));
    }

    @Override
    public DeviceDetails getDevice(Object userId, String deviceType, String deviceId) {
        Set<String> keys = this.cache.keys(UserDevicesDict.key(userId, "*"));
        if (keys.isEmpty()) {
            return null;
        }
        Map<String, Device> deviceMap = this.cache.get(keys, Device.class);
        Optional<Map.Entry> _item = deviceMap.entrySet().stream().filter(d -> UserDevicesDict.equalsDeviceByTypeAndId((Device)d.getValue(), deviceType, deviceId)).findAny();
        if (!_item.isPresent()) {
            return null;
        }
        Supplier<RequestDetails> requestDetailsSupplier = () -> {
            String[] split = ((String)((Map.Entry)_item.get()).getKey()).split(":");
            return this.cache.get(UserDevicesDict.requestKey(userId, split[split.length - 1]), RequestDetails.class);
        };
        return new DeviceDetails().setDevice((Device)_item.get().getValue()).setSupplier(requestDetailsSupplier);
    }

    @Override
    public List<Object> listUserId() {
        Set<String> keys = this.cache.keys(UserDevicesDict.key("*", "*"));
        if (keys.isEmpty()) {
            return new ArrayList<Object>(0);
        }
        return keys.stream().map(key -> AuthzContext.createUserId(key.split(":")[4])).distinct().collect(Collectors.toList());
    }

    @Override
    public List<DeviceDetails> listDevicesByUserId(Object userId) {
        Set<String> keys = this.cache.keys(UserDevicesDict.key(userId, "*"));
        if (keys.isEmpty()) {
            return new ArrayList<DeviceDetails>(0);
        }
        Map<String, Device> deviceMap = this.cache.get(keys, Device.class);
        ArrayList<DeviceDetails> deviceDetails = new ArrayList<DeviceDetails>();
        deviceMap.forEach((k, v) -> {
            Supplier<RequestDetails> requestDetailsSupplier = () -> {
                String[] split = k.split(":");
                return this.cache.get(UserDevicesDict.requestKey(userId, split[split.length - 1]), RequestDetails.class);
            };
            deviceDetails.add(new DeviceDetails().setDevice((Device)v).setSupplier(requestDetailsSupplier));
        });
        deviceDetails.sort((v1, v2) -> v2.getLastRequestTime().compareTo(v1.getLastRequestTime()));
        return deviceDetails;
    }

    @Override
    public List<DeviceDetails> listActiveUserDevices(Object userId, long ms) {
        if ((userId + "").contains("*") || (userId + "").contains("?")) {
            return new ArrayList<DeviceDetails>();
        }
        return this._listActiveUserDevices(UserDevicesDict.requestKey(userId, "*"), ms);
    }

    @Override
    public List<DeviceDetails> listActiveUserDevices(long ms) {
        return this._listActiveUserDevices(UserDevicesDict.requestKey("*", "*"), ms);
    }

    private List<DeviceDetails> _listActiveUserDevices(String requestKey, long ms) {
        long now = TimeUtils.nowTime();
        Set<String> rKeys = this.cache.keys(requestKey);
        if (rKeys.isEmpty()) {
            return new ArrayList<DeviceDetails>(0);
        }
        Map<String, RequestDetails> requestDetailsMap = this.cache.get(rKeys, RequestDetails.class);
        return requestDetailsMap.entrySet().stream().filter(e -> now - ((RequestDetails)e.getValue()).getLastRequestTime().getTime() < ms).map(e -> {
            String[] split = ((String)e.getKey()).split(":");
            return new DeviceDetails().setId(split[5]).setUserId(split[4]).setRequest((RequestDetails)e.getValue());
        }).sorted((v1, v2) -> v2.getLastRequestTime().compareTo(v1.getLastRequestTime())).collect(Collectors.toList());
    }

    @Override
    public void request(HttpMeta httpMeta) {
        try {
            AccessToken token = httpMeta.getToken();
            if (token.getClientId() == null) {
                DefaultRequestDetails requestDetails = (DefaultRequestDetails)new DefaultRequestDetails().setLastRequestTime(httpMeta.getNow()).setIp(httpMeta.getIp()).setDeviceType(token.getDeviceType()).setDeviceId(token.getDeviceId());
                Async.run(() -> this.cache.setSneaky(UserDevicesDict.requestKey(token), requestDetails, 2L, TimeUnit.DAYS));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void deviceClean(Object userId) {
        AtomicReference<Runnable> reference = new AtomicReference<Runnable>();
        if (AuHelper.isLogin()) {
            AccessToken token = AuHelper.getToken();
            Device device = this.cache.get(UserDevicesDict.key(token), Device.class);
            if (device != null) {
                reference.set(() -> this.clean(userId, device.getDeviceType(), device.getDeviceId(), UserDevicesDict.key(token), UserDevicesDict.requestKey(token)));
            }
        } else {
            reference.set(() -> this.clean(userId, null, null, null, null));
        }
        CompletableFuture<Void> future = this.cleanCache.get(userId);
        if (future == null || Async.isSuccessFuture(future)) {
            this.cleanCache.put(userId, Async.run((Runnable)((Runnable)reference.get())));
        } else {
            future.thenRun((Runnable)reference.get());
        }
    }

    private void clean(Object userId, String deviceType, String deviceId, String key, String rKey) {
        AuthzProperties.UserConfig userConfig = usersConfig.getOrDefault(userId, this.properties.getUser());
        HashSet<String> delKeys = new HashSet<String>();
        HashSet keys = new HashSet();
        HashSet rKeys = new HashSet();
        Async.joinAndCheck((CompletableFuture)Async.combine((Runnable[])new Runnable[]{() -> keys.addAll(this.cache.keys(UserDevicesDict.key(userId, "*"))), () -> rKeys.addAll(this.cache.keys(UserDevicesDict.requestKey(userId, "*")))}));
        if (key != null && !keys.isEmpty()) {
            keys.remove(key);
        }
        if (rKey != null && !rKeys.isEmpty()) {
            rKeys.remove(rKey);
        }
        if (keys.isEmpty()) {
            return;
        }
        HashMap<String, Device> deviceMap = new HashMap<String, Device>();
        HashMap<String, RequestDetails> requestMap = new HashMap<String, RequestDetails>();
        Async.joinAndCheck((CompletableFuture)Async.combine((Runnable[])new Runnable[]{() -> deviceMap.putAll(this.cache.get(keys, Device.class)), () -> requestMap.putAll(this.cache.get(rKeys, RequestDetails.class))}));
        if (deviceMap.isEmpty()) {
            return;
        }
        if (deviceType != null && deviceId != null) {
            this.d(Integer.MIN_VALUE, deviceMap, requestMap, delKeys, e -> StringUtils.equals((String)deviceType, (String)((Device)e.getValue()).getDeviceType()) && StringUtils.equals((String)deviceId, (String)((Device)e.getValue()).getDeviceId()));
        }
        List<DeviceCountInfo> typesTotal = userConfig.getTypesTotal();
        if (userConfig.getMaximumTotalDevice() != -1 && userConfig.getMaximumTotalDevice() > 0 && deviceMap.size() > userConfig.getMaximumTotalDevice()) {
            this.d(userConfig.getMaximumTotalDevice() - 1, deviceMap, requestMap, delKeys, e -> true);
        }
        if (userConfig.getMaximumTotalSameTypeDevice() != -1 && deviceType != null && typesTotal.stream().noneMatch(v -> v.getTypes().contains(deviceType))) {
            this.d(userConfig.getMaximumTotalSameTypeDevice() - 1, deviceMap, requestMap, delKeys, e -> StringUtils.equals((String)((Device)e.getValue()).getDeviceType(), (String)deviceType));
        }
        if (typesTotal != null && !typesTotal.isEmpty()) {
            for (DeviceCountInfo deviceCountInfo : typesTotal) {
                if (deviceCountInfo.getTypes().isEmpty()) continue;
                this.d(deviceCountInfo.getTotal() - 1, deviceMap, requestMap, delKeys, e -> deviceCountInfo.getTypes().contains(((Device)e.getValue()).getDeviceType()));
            }
        }
        if (!delKeys.isEmpty()) {
            this.cache.del((Set<String>)delKeys);
            this.cache.del(UserDevicesDict.key(userId, "*"));
        }
    }

    private void d(int max, Map<String, Device> deviceMap, Map<String, RequestDetails> requestDetailsMap, Set<String> delKeys, Predicate<? super Map.Entry<String, Device>> predicate) {
        List devices;
        int deleteCount;
        if (max <= 0) {
            if (deviceMap.isEmpty()) {
                return;
            }
            delKeys.addAll(deviceMap.keySet());
        }
        if ((deleteCount = (devices = deviceMap.entrySet().stream().filter(predicate).sorted((v1, v2) -> {
            RequestDetails requestDetails1 = (RequestDetails)requestDetailsMap.get(v1.getKey());
            RequestDetails requestDetails2 = (RequestDetails)requestDetailsMap.get(v2.getKey());
            long l1 = 0L;
            long l2 = 0L;
            if (requestDetails1 != null) {
                l1 = requestDetails1.getLastRequestTimeLong();
            }
            if (requestDetails2 != null) {
                l2 = requestDetails2.getLastRequestTimeLong();
            }
            return Math.toIntExact(l1 - l2);
        }).collect(Collectors.toList())).size() - max) <= 0) {
            return;
        }
        for (Map.Entry v : devices.subList(0, Math.min(deleteCount, devices.size()))) {
            delKeys.add((String)v.getKey());
        }
    }
}

