/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.deviced;

import cn.omisheep.authz.core.AuthzProperties;
import cn.omisheep.authz.core.auth.deviced.Device;
import cn.omisheep.authz.core.auth.deviced.DeviceCountInfo;
import cn.omisheep.authz.core.auth.deviced.DeviceDetails;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.config.Constants;
import cn.omisheep.authz.core.tk.AccessToken;
import cn.omisheep.authz.core.tk.RefreshToken;
import cn.omisheep.authz.core.tk.TokenPair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang.StringUtils;

public interface UserDevicesDict {
    public static final Map<Object, AuthzProperties.UserConfig> usersConfig = new ConcurrentHashMap<Object, AuthzProperties.UserConfig>();

    public UserStatus userStatus(AccessToken var1);

    public void addUser(TokenPair var1, HttpMeta var2);

    public boolean refreshUser(TokenPair var1);

    public void removeAccessTokenByTid(Object var1, String var2);

    public void removeDeviceById(Object var1, String var2);

    public void removeDevice(Object var1, String var2, String var3);

    public void removeAllDevice(Object var1);

    public void removeCurrentDevice();

    public boolean isLogin(Object var1, String var2);

    public DeviceDetails getDevice(Object var1, String var2, String var3);

    public List<Object> listUserId();

    public List<DeviceDetails> listDevicesByUserId(Object var1);

    public List<DeviceDetails> listActiveUserDevices(long var1);

    public List<DeviceDetails> listActiveUserDevices(Object var1, long var2);

    public void request(HttpMeta var1);

    public void deviceClean(Object var1);

    default public void changeMaximumTotalSameTypeDevice(Object userId, int total) {
        AuthzProperties.UserConfig userConfig = usersConfig.computeIfAbsent(userId, r -> new AuthzProperties.UserConfig());
        userConfig.setMaximumTotalSameTypeDevice(total);
        this.deviceClean(userId);
    }

    default public void changeMaximumTotalDevice(Object userId, int count) {
        AuthzProperties.UserConfig userConfig = usersConfig.computeIfAbsent(userId, r -> new AuthzProperties.UserConfig());
        userConfig.setMaximumTotalDevice(count);
        this.deviceClean(userId);
    }

    default public void addDeviceTypesTotalLimit(Object userId, Collection<String> types, int total) {
        DeviceCountInfo deviceCountInfo = new DeviceCountInfo().setTypes(new HashSet<String>(types)).setTotal(total);
        AuthzProperties.UserConfig userConfig = usersConfig.computeIfAbsent(userId, r -> new AuthzProperties.UserConfig());
        userConfig.getTypesTotal().add(deviceCountInfo);
        this.deviceClean(userId);
    }

    default public List<DeviceCountInfo> getOrUpdateDeviceTypesTotalLimit(Object userId) {
        AuthzProperties.UserConfig userConfig = usersConfig.get(userId);
        if (userConfig == null) {
            return null;
        }
        return userConfig.getTypesTotal();
    }

    public static String requestKey(AccessToken accessToken) {
        return UserDevicesDict.requestKey(accessToken.getUserId(), accessToken.getId());
    }

    public static String requestKey(Object userId, String tid) {
        return Constants.USER_REQUEST_KEY_PREFIX.get() + userId + ":" + tid;
    }

    public static String key(AccessToken accessToken) {
        return UserDevicesDict.key(accessToken.getUserId(), accessToken.getId());
    }

    public static String key(RefreshToken refreshToken) {
        return UserDevicesDict.key(refreshToken.getUserId(), refreshToken.getId());
    }

    public static String key(Object userId, String tid) {
        return Constants.USER_DEVICE_KEY_PREFIX.get() + userId + ":" + tid;
    }

    public static String oauthKey(AccessToken accessToken) {
        return UserDevicesDict.oauthKey(accessToken.getUserId(), accessToken.getId());
    }

    public static String oauthKey(Object userId, String tid) {
        return Constants.OAUTH_USER_DEVICE_KEY_PREFIX.get() + userId + ":" + tid;
    }

    public static boolean equalsDeviceByTypeAndId(Device device, String deviceType, String deviceId) {
        if (device == null) {
            return false;
        }
        return StringUtils.equals((String)device.getDeviceType(), (String)deviceType) && StringUtils.equals((String)device.getDeviceId(), (String)deviceId);
    }

    public static enum UserStatus {
        SUCCESS,
        REQUIRE_LOGIN,
        LOGIN_EXCEPTION,
        ACCESS_TOKEN_OVERDUE;

    }
}

