/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.deviced;

import cn.omisheep.authz.core.AuthzContext;
import cn.omisheep.authz.core.auth.deviced.Device;
import cn.omisheep.authz.core.auth.deviced.RequestDetails;
import cn.omisheep.authz.core.auth.ipf.Blacklist;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.Date;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public class DeviceDetails {
    private String Id;
    private Object userId;
    private Date lastRequestTime;
    private String lastRequestIp;
    private String deviceType;
    private String deviceId;
    private Supplier<RequestDetails> supplier;
    private Set<Blacklist.User> list;

    public DeviceDetails setUserId(Object userId) {
        this.userId = AuthzContext.createUserId(userId);
        return this;
    }

    public DeviceDetails setDevice(Device device) {
        this.deviceType = device.getDeviceType();
        this.deviceId = device.getDeviceId();
        return this;
    }

    public DeviceDetails setRequest(RequestDetails request) {
        this._setRequest(request);
        this.deviceType = request.getDeviceType();
        this.deviceId = request.getDeviceId();
        return this;
    }

    private void _setRequest(RequestDetails request) {
        this.lastRequestTime = request.getLastRequestTime();
        this.lastRequestIp = request.getIp();
    }

    public Date getLastRequestTime() {
        if (this.lastRequestTime == null) {
            this._setRequest(this.supplier.get());
        }
        return this.lastRequestTime;
    }

    public String getLastRequestIp() {
        if (this.lastRequestIp == null) {
            this._setRequest(this.supplier.get());
        }
        return this.lastRequestIp;
    }

    public boolean isDenyIp() {
        return !Blacklist.IP.check(this.getLastRequestIp());
    }

    public boolean isDenyIpRange() {
        return !Blacklist.IPRangeDeny.check(this.getLastRequestIp());
    }

    public boolean isDenyUser() {
        if (this.list == null) {
            this.list = Blacklist.User.list(this.userId);
        }
        return this.list.stream().anyMatch(v -> StringUtils.equals((String)v.getDeviceType(), null) && StringUtils.equals((String)v.getDeviceId(), null));
    }

    public boolean isDenyDevice() {
        if (this.list == null) {
            this.list = Blacklist.User.list(this.userId);
        }
        return this.list.stream().anyMatch(v -> StringUtils.equals((String)v.getDeviceType(), (String)this.deviceType) && StringUtils.equals((String)v.getDeviceId(), (String)this.deviceId));
    }

    public String getId() {
        return this.Id;
    }

    public Object getUserId() {
        return this.userId;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public DeviceDetails setId(String Id) {
        this.Id = Id;
        return this;
    }

    public DeviceDetails setLastRequestTime(Date lastRequestTime) {
        this.lastRequestTime = lastRequestTime;
        return this;
    }

    public DeviceDetails setLastRequestIp(String lastRequestIp) {
        this.lastRequestIp = lastRequestIp;
        return this;
    }

    public DeviceDetails setDeviceType(String deviceType) {
        this.deviceType = deviceType;
        return this;
    }

    public DeviceDetails setDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public DeviceDetails setSupplier(Supplier<RequestDetails> supplier) {
        this.supplier = supplier;
        return this;
    }

    public DeviceDetails setList(Set<Blacklist.User> list) {
        this.list = list;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeviceDetails)) {
            return false;
        }
        DeviceDetails other = (DeviceDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$Id = this.getId();
        String other$Id = other.getId();
        if (this$Id == null ? other$Id != null : !this$Id.equals(other$Id)) {
            return false;
        }
        Object this$userId = this.getUserId();
        Object other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        Date this$lastRequestTime = this.getLastRequestTime();
        Date other$lastRequestTime = other.getLastRequestTime();
        if (this$lastRequestTime == null ? other$lastRequestTime != null : !((Object)this$lastRequestTime).equals(other$lastRequestTime)) {
            return false;
        }
        String this$lastRequestIp = this.getLastRequestIp();
        String other$lastRequestIp = other.getLastRequestIp();
        if (this$lastRequestIp == null ? other$lastRequestIp != null : !this$lastRequestIp.equals(other$lastRequestIp)) {
            return false;
        }
        String this$deviceType = this.getDeviceType();
        String other$deviceType = other.getDeviceType();
        if (this$deviceType == null ? other$deviceType != null : !this$deviceType.equals(other$deviceType)) {
            return false;
        }
        String this$deviceId = this.getDeviceId();
        String other$deviceId = other.getDeviceId();
        if (this$deviceId == null ? other$deviceId != null : !this$deviceId.equals(other$deviceId)) {
            return false;
        }
        Supplier<RequestDetails> this$supplier = this.getSupplier();
        Supplier<RequestDetails> other$supplier = other.getSupplier();
        if (this$supplier == null ? other$supplier != null : !this$supplier.equals(other$supplier)) {
            return false;
        }
        Set<Blacklist.User> this$list = this.getList();
        Set<Blacklist.User> other$list = other.getList();
        return !(this$list == null ? other$list != null : !((Object)this$list).equals(other$list));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeviceDetails;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $Id = this.getId();
        result = result * 59 + ($Id == null ? 43 : $Id.hashCode());
        Object $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        Date $lastRequestTime = this.getLastRequestTime();
        result = result * 59 + ($lastRequestTime == null ? 43 : ((Object)$lastRequestTime).hashCode());
        String $lastRequestIp = this.getLastRequestIp();
        result = result * 59 + ($lastRequestIp == null ? 43 : $lastRequestIp.hashCode());
        String $deviceType = this.getDeviceType();
        result = result * 59 + ($deviceType == null ? 43 : $deviceType.hashCode());
        String $deviceId = this.getDeviceId();
        result = result * 59 + ($deviceId == null ? 43 : $deviceId.hashCode());
        Supplier<RequestDetails> $supplier = this.getSupplier();
        result = result * 59 + ($supplier == null ? 43 : $supplier.hashCode());
        Set<Blacklist.User> $list = this.getList();
        result = result * 59 + ($list == null ? 43 : ((Object)$list).hashCode());
        return result;
    }

    public String toString() {
        return "DeviceDetails(Id=" + this.getId() + ", userId=" + this.getUserId() + ", lastRequestTime=" + this.getLastRequestTime() + ", lastRequestIp=" + this.getLastRequestIp() + ", deviceType=" + this.getDeviceType() + ", deviceId=" + this.getDeviceId() + ", supplier=" + this.getSupplier() + ", list=" + this.getList() + ")";
    }

    private Supplier<RequestDetails> getSupplier() {
        return this.supplier;
    }

    private Set<Blacklist.User> getList() {
        return this.list;
    }
}

