/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core;

import org.springframework.http.HttpStatus;

public enum ExceptionStatus {
    REQUIRE_LOGIN(-101, "Require login", true, HttpStatus.NETWORK_AUTHENTICATION_REQUIRED),
    PERM_EXCEPTION(-102, "Insufficient permissions", false, HttpStatus.NETWORK_AUTHENTICATION_REQUIRED),
    ACCESS_TOKEN_OVERDUE(-103, "AccessToken overdue", true, HttpStatus.NETWORK_AUTHENTICATION_REQUIRED),
    REFRESH_TOKEN_EXPIRED_EXCEPTION(-104, "RefreshToken expired", false, HttpStatus.NETWORK_AUTHENTICATION_REQUIRED),
    TOKEN_EXCEPTION(-104, "Token exception", true, HttpStatus.FORBIDDEN),
    REQUEST_REPEAT(-202, "Request repeat error", false, HttpStatus.TOO_MANY_REQUESTS),
    LOGIN_EXCEPTION(-203, "You are offline, or you may have logged in elsewhere", true, HttpStatus.FORBIDDEN),
    REQUEST_EXCEPTION(-204, "Request error", false, HttpStatus.FORBIDDEN),
    CONTENT_TYPE_ERROR(-301, "Content type not supported, must be json", false, HttpStatus.INTERNAL_SERVER_ERROR),
    PAGE_NOT_SUPPORT(-302, "Page not support, check database type, only mysql and oracle", false, HttpStatus.INTERNAL_SERVER_ERROR),
    WEB_ENVIRONMENT(-401, "The current thread is in a non Web Environment", false, HttpStatus.INTERNAL_SERVER_ERROR),
    PRIVILEGE_GRANT_FAILED(-500, "Grant failed, not login or client id does not exist", false, HttpStatus.OK),
    CLIENT_SECRET_ERROR(-501, "Client secret error or client id not match", false, HttpStatus.OK),
    CLIENT_NOT_EXIST(-502, "Client not exist", false, HttpStatus.OK),
    AUTHORIZATION_CODE_EXPIRED_OR_NOT_EXIST(-503, "Authorization code does not exist or expires", false, HttpStatus.OK),
    SCOPE_EXCEPTION_OR_TYPE_ERROR(-504, "Insufficient scope of authorization or GrantType error", false, HttpStatus.NETWORK_AUTHENTICATION_REQUIRED),
    MISMATCHED_URL(-88888, "URL matching failed", false, HttpStatus.NOT_FOUND),
    UNKNOWN(-99999, "unknown", false, HttpStatus.INTERNAL_SERVER_ERROR);

    private final int code;
    private final String message;
    private final boolean clearToken;
    private final HttpStatus httpStatus;

    private ExceptionStatus(int code, String message, boolean clearToken, HttpStatus httpStatus) {
        this.code = code;
        this.message = message;
        this.clearToken = clearToken;
        this.httpStatus = httpStatus;
    }

    private ExceptionStatus(int code, String message, HttpStatus httpStatus) {
        this.code = code;
        this.message = message;
        this.clearToken = false;
        this.httpStatus = httpStatus;
    }

    private ExceptionStatus(HttpStatus httpStatus) {
        this.code = httpStatus.value();
        this.message = httpStatus.getReasonPhrase();
        this.clearToken = false;
        this.httpStatus = httpStatus;
    }

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public HttpStatus getHttpStatus() {
        return this.httpStatus;
    }

    public boolean isClearToken() {
        return this.clearToken;
    }
}

