/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core;

import cn.omisheep.authz.core.NotLoginException;
import cn.omisheep.authz.core.ThreadWebEnvironmentException;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.config.AuthzAppVersion;
import cn.omisheep.authz.core.tk.AccessToken;
import cn.omisheep.web.utils.HttpUtils;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.lang.NonNull;

public class AuthzContext {
    private static final Logger log = LoggerFactory.getLogger(AuthzContext.class);
    public static final ThreadLocal<HttpMeta> httpMeta = ThreadLocal.withInitial(() -> null);
    private static ApplicationContext ctx;

    private AuthzContext() {
        throw new UnsupportedOperationException();
    }

    public static <T> T getBean(Class<T> clz) {
        return (T)ctx.getBean(clz);
    }

    public static <T> T getBean(String name, Class<T> clz) {
        return (T)ctx.getBean(name, clz);
    }

    public static <T> Map<String, T> getBeansOfType(Class<T> clz) {
        return ctx.getBeansOfType(clz);
    }

    public static void init(ApplicationContext applicationContext) {
        ctx = applicationContext;
    }

    public static ApplicationContext getCtx() {
        return ctx;
    }

    @NonNull
    public static HttpMeta getCurrentHttpMeta() throws ThreadWebEnvironmentException {
        try {
            if (httpMeta.get() != null) {
                return httpMeta.get();
            }
            HttpMeta currentHttpMeta = (HttpMeta)HttpUtils.getCurrentRequest().getAttribute("AU_HTTP_META");
            if (currentHttpMeta == null) {
                throw new ThreadWebEnvironmentException();
            }
            return currentHttpMeta;
        }
        catch (Exception e) {
            throw new ThreadWebEnvironmentException();
        }
    }

    @NonNull
    public static AccessToken getCurrentToken() throws NotLoginException {
        try {
            AccessToken accessToken = AuthzContext.getCurrentHttpMeta().getToken();
            if (accessToken == null) {
                throw new NotLoginException();
            }
            return accessToken;
        }
        catch (Exception e) {
            throw new NotLoginException();
        }
    }

    @NonNull
    public static Object createUserId(@NonNull Object userId) {
        try {
            String _userId = userId instanceof String ? (String)userId : userId + "";
            if (AuthzAppVersion.USER_ID_TYPE.equals(String.class)) {
                return _userId;
            }
            return AuthzAppVersion.USER_ID_CONSTRUCTOR.newInstance(_userId);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            return userId;
        }
    }
}

