/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz;

import cn.omisheep.authz.core.AuthzContext;
import cn.omisheep.authz.core.AuthzManager;
import cn.omisheep.authz.core.NotLoginException;
import cn.omisheep.authz.core.RefreshTokenExpiredException;
import cn.omisheep.authz.core.ThreadWebEnvironmentException;
import cn.omisheep.authz.core.TokenException;
import cn.omisheep.authz.core.auth.deviced.DeviceCountInfo;
import cn.omisheep.authz.core.auth.deviced.DeviceDetails;
import cn.omisheep.authz.core.auth.ipf.Blacklist;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.ipf.Httpd;
import cn.omisheep.authz.core.callback.AuthorizationCallback;
import cn.omisheep.authz.core.callback.RateLimitCallback;
import cn.omisheep.authz.core.codec.AuthzRSAManager;
import cn.omisheep.authz.core.helper.AuthzDeviceHelper;
import cn.omisheep.authz.core.helper.AuthzGranterHelper;
import cn.omisheep.authz.core.helper.AuthzStateHelper;
import cn.omisheep.authz.core.helper.BaseHelper;
import cn.omisheep.authz.core.helper.OpenAuthHelper;
import cn.omisheep.authz.core.msg.AuthzModifier;
import cn.omisheep.authz.core.oauth.AuthorizationException;
import cn.omisheep.authz.core.oauth.AuthorizedDeviceDetails;
import cn.omisheep.authz.core.oauth.ClientDetails;
import cn.omisheep.authz.core.tk.AccessToken;
import cn.omisheep.authz.core.tk.IssueToken;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class AuHelper
extends BaseHelper {
    @NonNull
    public static IssueToken login(@NonNull Object userId) {
        return AuthzGranterHelper.grant(userId, null, null);
    }

    @NonNull
    public static IssueToken login(@NonNull Object userId, @NonNull String deviceType) {
        return AuHelper.login(userId, deviceType, null);
    }

    @NonNull
    public static IssueToken login(@NonNull Object userId, @NonNull String deviceType, @Nullable String deviceId) {
        return AuthzGranterHelper.grant(userId, deviceType, deviceId);
    }

    @NonNull
    public static IssueToken refreshToken(@NonNull String refreshToken) throws RefreshTokenExpiredException, TokenException {
        return AuthzGranterHelper.refreshToken(refreshToken);
    }

    public static void logout() throws NotLoginException {
        AuthzGranterHelper.logout();
    }

    public static void logout(@NonNull String deviceType) throws NotLoginException {
        AuthzGranterHelper.logout(deviceType, null);
    }

    public static void logout(@NonNull String deviceType, @Nullable String deviceId) throws NotLoginException {
        AuthzGranterHelper.logout(deviceType, deviceId);
    }

    public static void logoutAll() throws NotLoginException {
        AuthzGranterHelper.logoutAll();
    }

    public static void logoutAllAt(@NonNull Object userId) {
        AuthzGranterHelper.logoutAll(userId);
    }

    public static void logoutAt(@NonNull Object userId, @NonNull String deviceType) {
        AuthzGranterHelper.logout(userId, deviceType);
    }

    public static void logoutAt(@NonNull Object userId, @NonNull String deviceType, @Nullable String deviceId) {
        AuthzGranterHelper.logout(userId, deviceType, deviceId);
    }

    public static void logoutById(String id) throws NotLoginException {
        AuthzGranterHelper.logoutById(AuHelper.getUserId(), id);
    }

    public static void logoutById(Object userId, String id) {
        AuthzGranterHelper.logoutById(userId, id);
    }

    @NonNull
    public static Map<Object, List<DeviceDetails>> getAllUserDevices() {
        return AuthzDeviceHelper.getAllUsersDevices();
    }

    @NonNull
    public static List<Object> getAllUserId() {
        return AuthzDeviceHelper.getAllUserId();
    }

    @NonNull
    public static List<DeviceDetails> getDevices(@NonNull String deviceType) throws NotLoginException {
        return AuthzDeviceHelper.getAllDeviceByUserIdAndDeviceType(AuHelper.getUserId(), deviceType);
    }

    @NonNull
    public static List<DeviceDetails> getDevices() throws NotLoginException {
        return AuthzDeviceHelper.getAllDeviceFromCurrentUser();
    }

    @Nullable
    public static DeviceDetails getDevice() throws NotLoginException {
        AccessToken token = AuHelper.getToken();
        return AuthzDeviceHelper.getDeviceByUserIdAndDeviceTypeAndDeviceId(token.getUserId(), token.getDeviceType(), token.getDeviceId());
    }

    @NonNull
    public static List<DeviceDetails> getDevicesAt(@NonNull Object userId) {
        return AuthzDeviceHelper.getAllDeviceByUserId(userId);
    }

    @NonNull
    public static List<DeviceDetails> getDevicesAt(@NonNull Object userId, @NonNull String deviceType) {
        return AuthzDeviceHelper.getAllDeviceByUserIdAndDeviceType(userId, deviceType);
    }

    @Nullable
    public static DeviceDetails getDeviceAt(@NonNull Object userId, @NonNull String deviceType, @Nullable String deviceId) {
        return AuthzDeviceHelper.getDeviceByUserIdAndDeviceTypeAndDeviceId(userId, deviceType, deviceId);
    }

    public static void addDeviceTypesTotalLimit(@NonNull Collection<String> types, int total) throws NotLoginException {
        AuthzDeviceHelper.addDeviceTypesTotalLimit(types, total);
    }

    public static void addDeviceTypesTotalLimitAt(@NonNull Object userId, @NonNull Collection<String> types, int total) {
        AuthzDeviceHelper.addDeviceTypesTotalLimitAt(userId, types, total);
    }

    public static List<DeviceCountInfo> getOrUpdateDeviceTypesTotalLimit() throws NotLoginException {
        return AuthzDeviceHelper.getOrUpdateDeviceTypesTotalLimit();
    }

    public static List<DeviceCountInfo> getOrUpdateDeviceTypesTotalLimitAt(@NonNull Object userId) {
        return AuthzDeviceHelper.getOrUpdateDeviceTypesTotalLimitAt(userId);
    }

    public static void changeMaximumDeviceTotal(int total) throws NotLoginException {
        AuthzDeviceHelper.changeMaximumTotalDevice(total);
    }

    public static void changeMaximumTotalDeviceAt(@NonNull Object userId, int total) {
        AuthzDeviceHelper.changeMaximumTotalDeviceAt(userId, total);
    }

    public static void changeMaximumTotalSameTypeDevice(int total) throws NotLoginException {
        AuthzDeviceHelper.changeMaximumTotalSameTypeDevice(total);
    }

    public static void changeMaximumTotalSameTypeDeviceAt(@NonNull Object userId, int count) {
        AuthzDeviceHelper.changeMaximumTotalSameTypeDeviceAt(userId, count);
    }

    public static boolean isLogin() {
        return AuthzStateHelper.isLogin();
    }

    public static boolean isLoginById(@NonNull String id) {
        try {
            return AuthzStateHelper.isLogin(AuHelper.getUserId(), id);
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isLoginById(@NonNull Object userId, @NonNull String id) {
        return AuthzStateHelper.isLogin(userId, id);
    }

    @NonNull
    public static HttpMeta getHttpMeta() throws ThreadWebEnvironmentException {
        return AuthzContext.getCurrentHttpMeta();
    }

    @NonNull
    public static AccessToken getToken() throws NotLoginException {
        return AuthzContext.getCurrentToken();
    }

    @NonNull
    public static Object getUserId() throws NotLoginException {
        return AuthzContext.getCurrentToken().getUserId();
    }

    @NonNull
    public static String getDeviceType() throws NotLoginException {
        return AuthzContext.getCurrentToken().getDeviceType();
    }

    @Nullable
    public static String getDeviceId() throws NotLoginException {
        return AuthzContext.getCurrentToken().getDeviceId();
    }

    @Nullable
    public static String getClientId() throws NotLoginException {
        return AuthzContext.getCurrentToken().getClientId();
    }

    public static boolean hasRole(String ... role) {
        return AuHelper.hasRoles(Arrays.asList(role));
    }

    public static boolean hasRoles(@NonNull List<String> roles) {
        return AuthzStateHelper.hasRoles(roles);
    }

    public static boolean hasPermission(String ... permission) {
        return AuHelper.hasPermissions(Arrays.asList(permission));
    }

    public static boolean hasPermissions(@NonNull List<String> permissions) {
        return AuthzStateHelper.hasPermissions(permissions);
    }

    public static boolean hasScope(String ... scope) {
        return AuthzStateHelper.hasScope(Arrays.asList(scope));
    }

    public static boolean hasScope(@NonNull List<String> scope) {
        return AuthzStateHelper.hasScope(scope);
    }

    public static boolean checkUserIsActive(@NonNull Object userId) {
        return AuHelper.checkUserIsActive(userId, 60000L);
    }

    public static boolean checkUserIsActive(@NonNull Object userId, @NonNull String time) {
        return AuthzDeviceHelper.checkUserIsActive(userId, time);
    }

    public static boolean checkUserIsActive(@NonNull Object userId, long ms) {
        return AuthzDeviceHelper.checkUserIsActive(userId, ms);
    }

    public static int getNumberOfActiveUser() {
        return AuHelper.getActiveUserIdList(60000L).size();
    }

    public static int getNumberOfActiveUser(@NonNull String time) {
        return AuHelper.getActiveUserIdList(time).size();
    }

    public static int getNumberOfActiveUser(long ms) {
        return AuHelper.getActiveUserIdList(ms).size();
    }

    @NonNull
    public static List<Object> getActiveUserIdList() {
        return AuHelper.getActiveUserIdList(60000L);
    }

    @NonNull
    public static List<Object> getActiveUserIdList(@NonNull String time) {
        return AuthzDeviceHelper.getActiveUserIdList(time);
    }

    @NonNull
    public static List<Object> getActiveUserIdList(long ms) {
        return AuthzDeviceHelper.getActiveUserIdList(ms);
    }

    @NonNull
    public static List<DeviceDetails> getActiveDevices() {
        return AuthzDeviceHelper.getActiveDevices(60000L);
    }

    @NonNull
    public static List<DeviceDetails> getActiveDevices(long ms) {
        return AuthzDeviceHelper.getActiveDevices(ms);
    }

    @NonNull
    public static List<DeviceDetails> getActiveDevices(@NonNull String time) {
        return AuthzDeviceHelper.getActiveDevices(time);
    }

    public static void denyIP(@NonNull String ip, @NonNull long ms) {
        Blacklist.IP.update(ip, ms);
    }

    public static void denyIP(@NonNull String ip, @NonNull Date endDate) {
        Blacklist.IP.update(ip, endDate);
    }

    public static void denyIPRange(@NonNull String ipRange, @NonNull long ms) {
        Blacklist.IPRangeDeny.update(ipRange, ms);
    }

    public static void denyIPRange(@NonNull String ipRange, @NonNull Date endDate) {
        Blacklist.IPRangeDeny.update(ipRange, endDate);
    }

    public static void denyUser(@NonNull Object userId, @NonNull long ms) {
        Blacklist.User.update(userId, null, null, ms);
    }

    public static void denyUser(@NonNull Object userId, @NonNull Date endDate) {
        Blacklist.User.update(userId, null, null, endDate);
    }

    public static void denyDevice(@NonNull Object userId, @NonNull String deviceType, @NonNull long ms) {
        AuHelper.denyDevice(userId, deviceType, null, ms);
    }

    public static void denyDevice(@NonNull Object userId, @NonNull String deviceType, @NonNull Date endDate) {
        AuHelper.denyDevice(userId, deviceType, null, endDate);
    }

    public static void denyDevice(@NonNull Object userId, @NonNull String deviceType, @Nullable String deviceId, @NonNull long ms) {
        Blacklist.User.update(userId, deviceType, deviceId, ms);
    }

    public static void denyDevice(@NonNull Object userId, @NonNull String deviceType, @Nullable String deviceId, @NonNull Date endDate) {
        Blacklist.User.update(userId, deviceType, deviceId, endDate);
    }

    @NonNull
    public static Set<Blacklist.IP> getAllDenyIPInfo() {
        return Blacklist.IP.list();
    }

    @Nullable
    public static Blacklist.IP getDenyIPInfo(String ip) {
        return Blacklist.IP.get(ip);
    }

    @NonNull
    public static Set<Blacklist.IPRangeDeny> getAllDenyIPRangeInfo() {
        return Blacklist.IPRangeDeny.list();
    }

    @NonNull
    public static Set<Blacklist.User> getAllDenyUserInfo() {
        return Blacklist.User.list();
    }

    @NonNull
    public static Set<Blacklist.User> getDenyUserAndDeviceInfo(@NonNull Object userId) {
        return Blacklist.User.list(userId);
    }

    @Nullable
    public static Blacklist.User getDenyUserInfo(@NonNull Object userId) {
        return Blacklist.User.getUser(userId);
    }

    @Nullable
    public static Blacklist.User getDenyDeviceInfo(@NonNull Object userId, @NonNull String deviceType, @Nullable String deviceId) {
        return Blacklist.User.getDevice(userId, deviceType, deviceId);
    }

    public static void removeDenyIP(@NonNull String ip) {
        Blacklist.IP.remove(ip);
    }

    public static void removeDenyIPRange(@NonNull String ipRange) {
        Blacklist.IPRangeDeny.remove(ipRange);
    }

    public static void removeDenyUser(@NonNull Object userId) {
        Blacklist.User.remove(userId, null, null);
    }

    public static void removeDenyDevice(@NonNull Object userId, @NonNull String deviceType) {
        Blacklist.User.remove(userId, deviceType, null);
    }

    public static void removeDenyDevice(@NonNull Object userId, @NonNull String deviceType, @NonNull String deviceId) {
        Blacklist.User.remove(userId, deviceType, deviceId);
    }

    @Nullable
    public static Object authzModify(@NonNull AuthzModifier authzModifier) {
        return AuthzManager.modify(authzModifier);
    }

    private AuHelper() {
        throw new UnsupportedOperationException();
    }

    public static class Callback {
        private Callback() {
        }

        public static void setRateLimitCallback(RateLimitCallback rateLimitCallback) {
            Httpd.setRateLimitCallback(rateLimitCallback);
        }

        public static void setAuthorizationCallback(AuthorizationCallback authorizationCallback) {
            OpenAuthHelper.setAuthorizationCallback(authorizationCallback);
        }
    }

    public static class Cache {
        private Cache() {
        }

        public <E> void set(String key, E element) {
            cache.set(key, element);
        }

        public <E> void set(String key, E element, long time, TimeUnit unit) {
            cache.set(key, element, time, unit);
        }

        public <E> void set(String key, E element, String time) {
            cache.set(key, element, time);
        }

        public void delete(String ... keys) {
            cache.del(keys);
        }

        public void delete(Collection<String> keys) {
            if (keys instanceof Set) {
                cache.del((Set)keys);
            } else {
                this.delete(new HashSet<String>(keys));
            }
        }

        public Map<String, Object> get(Collection<String> keys) {
            if (keys instanceof Set) {
                return cache.get((Set)keys);
            }
            return cache.get(new HashSet<String>(keys));
        }

        public Object get(String key) {
            return cache.get(key);
        }
    }

    public static class RSA {
        private RSA() {
        }

        @NonNull
        public static String getRSAPublicKey() {
            return AuthzRSAManager.getPublicKeyString();
        }

        @NonNull
        public static String getRSAPrivateKey() {
            return AuthzRSAManager.getPrivateKeyString();
        }

        public static String encrypt(String plaintext) {
            return AuthzRSAManager.encrypt(plaintext);
        }

        public static String decrypt(String encryptText) {
            return AuthzRSAManager.decrypt(encryptText);
        }

        public static void rsaAutoRefresh() {
            AuthzRSAManager.setAuto(true);
        }

        public static void closeRSAAutoRefreshAndSetup(String publicKey, String privateKey) {
            AuthzRSAManager.setAuKeyPair(publicKey, privateKey);
        }
    }

    public static class OpenAuth {
        @Nullable
        public static IssueToken authorizeByCode(@NonNull String clientId, @NonNull String clientSecret, @NonNull String authorizationCode) throws AuthorizationException {
            return OpenAuthHelper.authorizeByCode(clientId, clientSecret, authorizationCode);
        }

        @Nullable
        public static IssueToken authorizeByPassword(@NonNull String clientId, @NonNull String clientSecret, @NonNull String scope, @NonNull Object userId) throws AuthorizationException {
            return OpenAuthHelper.authorizeByPassword(clientId, clientSecret, scope, userId);
        }

        @Nullable
        public static IssueToken authorizeByPassword(@NonNull String clientId, @NonNull String clientSecret, @NonNull String scope) throws AuthorizationException {
            return OpenAuthHelper.authorizeByPassword(clientId, clientSecret, scope, AuHelper.getUserId());
        }

        @Nullable
        public static IssueToken authorizeByClient(@NonNull String clientId, @NonNull String clientSecret, @NonNull String scope) throws AuthorizationException {
            return OpenAuthHelper.authorizeByClient(clientId, clientSecret, scope);
        }

        @NonNull
        public static String createAuthorizationCode(@NonNull String clientId, @NonNull String scope, @NonNull String redirectUrl) throws AuthorizationException {
            if (AuHelper.isLogin() && OpenAuth.agreeAuthorize(clientId)) {
                return OpenAuthHelper.createAuthorizationCode(clientId, scope, redirectUrl, AuHelper.getUserId());
            }
            throw AuthorizationException.privilegeGrantFailed();
        }

        @NonNull
        public static String createBasicScopeAuthorizationCode(@NonNull String clientId, @NonNull String redirectUrl) throws AuthorizationException {
            if (AuHelper.isLogin() && OpenAuth.agreeAuthorize(clientId)) {
                return OpenAuthHelper.createBasicScopeAuthorizationCode(clientId, redirectUrl, AuHelper.getUserId());
            }
            throw AuthorizationException.privilegeGrantFailed();
        }

        public static boolean agreeAuthorize(@NonNull String clientId) {
            return OpenAuthHelper.findClient(clientId) != null;
        }

        @NonNull
        public static ClientDetails findClient(@NonNull String clientId) {
            return OpenAuthHelper.findClient(clientId);
        }

        @NonNull
        public static String getRedirectUrl(@NonNull String clientId) {
            return OpenAuthHelper.findClient(clientId).getRedirectUrl();
        }

        public static void removeAuthorizedDevice(@NonNull String id) throws NotLoginException {
            OpenAuth.removeAuthorizedDevice(AuHelper.getUserId(), id);
        }

        public static void removeAuthorizedDevice(@NonNull Object userId, @NonNull String id) {
            OpenAuthHelper.removeAuthorizedDevice(userId, id);
        }

        public static void removeAllAuthorizedDevice() throws NotLoginException {
            OpenAuth.removeAllAuthorizedDevice(AuHelper.getUserId());
        }

        public static void removeAllAuthorizedDevice(@NonNull Object userId) {
            OpenAuthHelper.removeAllAuthorizedDevice(userId);
        }

        @NonNull
        public static List<AuthorizedDeviceDetails> getAuthorizedDeviceDetails() throws NotLoginException {
            return OpenAuth.getAuthorizedDeviceDetailsAt(AuHelper.getUserId());
        }

        @NonNull
        public static List<AuthorizedDeviceDetails> getAuthorizedDeviceDetailsAt(@NonNull Object userId) {
            return OpenAuthHelper.getAuthorizedDeviceDetailsAt(userId);
        }

        public static void deleteClient(@NonNull String clientId) {
            OpenAuthHelper.deleteClient(clientId);
        }

        public static ClientDetails clientRegister() {
            return OpenAuthHelper.clientRegister("DefaultClientName", null);
        }

        public static ClientDetails clientRegister(@NonNull String clientName, @NonNull String redirectUrl) {
            return OpenAuthHelper.clientRegister(clientName, redirectUrl);
        }

        public static ClientDetails clientRegister(@NonNull String clientId, @NonNull String clientName, @NonNull String redirectUrl) {
            return OpenAuthHelper.clientRegister(clientId, clientName, redirectUrl);
        }

        public static ClientDetails clientRegister(@NonNull String clientId, @NonNull String clientSecret, @NonNull String clientName, @NonNull String redirectUrl) {
            return OpenAuthHelper.clientRegister(clientId, clientSecret, clientName, redirectUrl);
        }
    }
}

