package cn.omisheep.authz.core.interceptor;

import cn.omisheep.web.utils.HttpUtils;
import org.springframework.http.HttpRequest;
import org.springframework.http.client.ClientHttpRequestExecution;
import org.springframework.http.client.ClientHttpRequestInterceptor;
import org.springframework.http.client.ClientHttpResponse;

import java.io.IOException;

/**
 * restTemplate适配
 *
 * @author zhouxinchen[1269670415@qq.com]
 * @since 1.0.0
 */
public class AuthzRestTemplateInterceptor implements ClientHttpRequestInterceptor {
    @Override
    public ClientHttpResponse intercept(HttpRequest request,
                                        byte[] body,
                                        ClientHttpRequestExecution execution) throws IOException {
        HttpUtils.getCurrentRequestHeaders().forEach(request.getHeaders()::set);
        return execution.execute(request, body);
    }
}