/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.support.util;

import java.util.NoSuchElementException;

public class IPAddress
implements Cloneable {
    protected int ipAddress = 0;
    protected String ipAddressStr;

    public IPAddress(String ipAddressStr) {
        try {
            this.ipAddressStr = ipAddressStr;
            this.ipAddress = this.parseIPAddress(ipAddressStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IPAddress(int address) {
        this.ipAddress = address;
    }

    public final String getIpAddress() {
        return this.ipAddressStr;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        int temp = this.ipAddress & 0xFF;
        result.append(temp);
        result.append(".");
        temp = this.ipAddress >> 8 & 0xFF;
        result.append(temp);
        result.append(".");
        temp = this.ipAddress >> 16 & 0xFF;
        result.append(temp);
        result.append(".");
        temp = this.ipAddress >> 24 & 0xFF;
        result.append(temp);
        return result.toString();
    }

    public final boolean isClassA() {
        return (this.ipAddress & 1) == 0;
    }

    public final boolean isClassB() {
        return (this.ipAddress & 3) == 1;
    }

    public final boolean isClassC() {
        return (this.ipAddress & 7) == 3;
    }

    final int parseIPAddress(String ipAddressStr) {
        int result = 0;
        if (ipAddressStr == null) {
            throw new IllegalArgumentException();
        }
        try {
            int number;
            String tmp = ipAddressStr;
            int offset = 0;
            for (int i = 0; i < 3; ++i) {
                int index = tmp.indexOf(46);
                if (index != -1) {
                    String numberStr = tmp.substring(0, index);
                    int number2 = Integer.parseInt(numberStr);
                    if (number2 < 0 || number2 > 255) {
                        throw new IllegalArgumentException("Invalid IP Address [" + ipAddressStr + "]");
                    }
                    result += number2 << offset;
                    offset += 8;
                } else {
                    throw new IllegalArgumentException("Invalid IP Address [" + ipAddressStr + "]");
                }
                tmp = tmp.substring(index + 1);
            }
            if (tmp.length() > 0) {
                number = Integer.parseInt(tmp);
                if (number < 0 || number > 255) {
                    throw new IllegalArgumentException("Invalid IP Address [" + ipAddressStr + "]");
                }
            } else {
                throw new IllegalArgumentException("Invalid IP Address [" + ipAddressStr + "]");
            }
            this.ipAddress = result += number << offset;
        }
        catch (NumberFormatException | NoSuchElementException ex) {
            throw new IllegalArgumentException("Invalid IP Address [" + ipAddressStr + "]", ex);
        }
        return result;
    }

    public int hashCode() {
        return this.ipAddress;
    }

    public boolean equals(Object another) {
        return another instanceof IPAddress && this.ipAddress == ((IPAddress)another).ipAddress;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

