/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.support.http;

import cn.omisheep.authz.core.Authz;
import cn.omisheep.authz.core.VersionInfo;
import cn.omisheep.authz.core.auth.AuthzModifier;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.util.Utils;
import cn.omisheep.authz.support.util.IPAddress;
import cn.omisheep.authz.support.util.IPRange;
import cn.omisheep.authz.support.util.IPRangeMeta;
import cn.omisheep.authz.support.util.SupportUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SupportServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(SupportServlet.class);
    public static final String SESSION_USER_KEY = "authz-dashboard-user";
    public static final String PARAM_NAME_USERNAME = "username";
    public static final String PARAM_NAME_PASSWORD = "password";
    public static final String PARAM_NAME_ALLOW = "allow";
    public static final String PARAM_NAME_DENY = "deny";
    public static final String PARAM_REMOTE_ADDR = "remoteAddress";
    protected String username = null;
    protected String password = null;
    protected List<IPRange> allowList = new ArrayList<IPRange>();
    protected List<IPRange> denyList = new ArrayList<IPRange>();
    protected final String resourcePath;
    protected String mappings;
    protected String remoteAddressHeader = null;
    protected String baseMapping = "";

    public SupportServlet(String resourcePath, String mappings) {
        this.resourcePath = resourcePath;
        this.mappings = mappings;
    }

    public void init() throws ServletException {
        this.initAuthEnv();
        String val = this.mappings.substring(0, this.mappings.indexOf("/*"));
        this.baseMapping = !this.mappings.startsWith("/") ? val : val.substring(1);
    }

    private void initAuthEnv() {
        String msg;
        String paramRemoteAddressHeader;
        String paramPassword;
        String paramUserName = this.getInitParameter(PARAM_NAME_USERNAME);
        if (!StringUtils.isEmpty((String)paramUserName)) {
            this.username = paramUserName;
        }
        if (!StringUtils.isEmpty((String)(paramPassword = this.getInitParameter(PARAM_NAME_PASSWORD)))) {
            this.password = paramPassword;
        }
        if (!StringUtils.isEmpty((String)(paramRemoteAddressHeader = this.getInitParameter(PARAM_REMOTE_ADDR)))) {
            this.remoteAddressHeader = paramRemoteAddressHeader;
        }
        try {
            this.allowList.addAll(IPRangeMeta.parse(this.getInitParameter(PARAM_NAME_ALLOW)));
        }
        catch (Exception e) {
            msg = "initParameter config error, allow : " + this.getInitParameter(PARAM_NAME_ALLOW);
            log.error(msg, (Throwable)e);
        }
        try {
            this.denyList.addAll(IPRangeMeta.parse(this.getInitParameter(PARAM_NAME_DENY)));
        }
        catch (Exception e) {
            msg = "initParameter config error, deny : " + this.getInitParameter(PARAM_NAME_DENY);
            log.error(msg, (Throwable)e);
        }
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String contextPath = request.getContextPath();
        String servletPath = request.getServletPath();
        String requestURI = request.getRequestURI();
        response.setCharacterEncoding("utf-8");
        if (contextPath == null) {
            contextPath = "";
        }
        String uri = contextPath + servletPath;
        String path = requestURI.substring(contextPath.length() + servletPath.length());
        if (!this.isPermittedRequest(request)) {
            path = "/nopermit.html";
            this.returnResourceFile(path, uri, response);
            return;
        }
        if ("/submitLogin".equals(path)) {
            HttpMeta httpMeta = (HttpMeta)request.getAttribute("AU_HTTP_META");
            try {
                JSONObject object = JSON.parseObject((String)httpMeta.getBody());
                if (object == null) {
                    response.getWriter().print("error");
                    return;
                }
                String usernameParam = object.getString(PARAM_NAME_USERNAME);
                String passwordParam = object.getString(PARAM_NAME_PASSWORD);
                if (this.username.equals(usernameParam) && this.password.equals(passwordParam)) {
                    request.getSession().setAttribute(SESSION_USER_KEY, (Object)this.username);
                    response.getWriter().print("success");
                } else {
                    response.getWriter().print("error");
                }
                return;
            }
            catch (Exception e) {
                response.getWriter().print("error");
                return;
            }
        }
        if (!(!this.isRequireAuth() || this.ContainsUser(request) || "/login.html".equals(path) || path.startsWith("/css") || path.startsWith("/js") || path.startsWith("/img") || path.equals("/favicon.ico"))) {
            if (path.startsWith("/api")) {
                response.getWriter().println("error");
                return;
            }
            if (contextPath.equals("") || contextPath.equals("/")) {
                response.sendRedirect("/" + this.baseMapping + "/login.html");
            } else if ("".equals(path)) {
                response.sendRedirect(this.baseMapping + "/login.html");
            } else {
                response.sendRedirect("login.html");
            }
            return;
        }
        if ("".equals(path)) {
            if (contextPath.equals("") || contextPath.equals("/")) {
                response.sendRedirect("/" + this.baseMapping + "/index.html");
            } else {
                response.sendRedirect(this.baseMapping + "/index.html");
            }
            return;
        }
        if ("/".equals(path)) {
            response.sendRedirect("index.html");
            return;
        }
        if (path.startsWith("/api")) {
            this.interpretation(path.substring(4), request, response);
            return;
        }
        this.returnResourceFile(path, uri, response);
    }

    protected String getFilePath(String fileName) {
        return this.resourcePath + fileName;
    }

    public boolean isRequireAuth() {
        return this.username != null;
    }

    public boolean ContainsUser(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        return session != null && session.getAttribute(SESSION_USER_KEY) != null;
    }

    protected void interpretation(String api, HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpMeta httpMeta = (HttpMeta)request.getAttribute("AU_HTTP_META");
        response.setContentType("application/json;charset=utf-8");
        if ("/modify".equals(api)) {
            AuthzModifier authzModifier = (AuthzModifier)JSON.parseObject((String)httpMeta.getBody(), AuthzModifier.class);
            response.getWriter().println(JSON.toJSONString((Object)Authz.operate(authzModifier)));
        } else if ("/info".equals(api)) {
            response.getWriter().println(JSON.toJSONString(VersionInfo.getVersion()));
        }
    }

    protected void returnResourceFile(String fileName, String uri, HttpServletResponse response) throws IOException {
        String filePath = this.getFilePath(fileName);
        if (filePath.endsWith(".html")) {
            response.setContentType("text/html; charset=utf-8");
        }
        if (Utils.isIgnoreSuffix(fileName, ".jpg", ".png", ".gif")) {
            byte[] bytes = SupportUtils.readByteArrayFromResource(filePath);
            if (bytes != null) {
                response.getOutputStream().write(bytes);
            }
            return;
        }
        String text = SupportUtils.readFromResource(filePath);
        if (text == null) {
            response.sendRedirect(uri + "/index.html");
            return;
        }
        if (fileName.endsWith(".css")) {
            response.setContentType("text/css;charset=utf-8");
        } else if (fileName.endsWith(".js")) {
            response.setContentType("text/javascript;charset=utf-8");
        } else if (fileName.endsWith(".svg")) {
            response.setContentType("image/svg+xml");
        }
        response.getWriter().write(text);
    }

    public boolean isPermittedRequest(String remoteAddress) {
        boolean ipV6;
        boolean bl = ipV6 = remoteAddress != null && remoteAddress.indexOf(58) != -1;
        if (ipV6) {
            return "0:0:0:0:0:0:0:1".equals(remoteAddress) || this.denyList.size() == 0 && this.allowList.size() == 0;
        }
        IPAddress ipAddress = new IPAddress(remoteAddress);
        for (IPRange range : this.denyList) {
            if (!range.isIPAddressInRange(ipAddress)) continue;
            return false;
        }
        if (this.allowList.size() > 0) {
            for (IPRange range : this.allowList) {
                if (!range.isIPAddressInRange(ipAddress)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public boolean isPermittedRequest(HttpServletRequest request) {
        String remoteAddress = this.getRemoteAddress(request);
        return this.isPermittedRequest(remoteAddress);
    }

    protected String getRemoteAddress(HttpServletRequest request) {
        String remoteAddress = null;
        if (this.remoteAddressHeader != null) {
            remoteAddress = request.getHeader(this.remoteAddressHeader);
        }
        if (remoteAddress == null) {
            remoteAddress = request.getRemoteAddr();
        }
        return remoteAddress;
    }
}

