/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.util;

import cn.omisheep.authz.core.util.ArgsParser;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang.ObjectUtils;
import org.springframework.lang.NonNull;

public abstract class ValueMatcher {
    public static boolean match(Set<String> resources, String rawValue, Class<?> valueType) {
        return resources.stream().anyMatch(resource -> ValueMatcher.match(resource, rawValue, valueType));
    }

    private static boolean matchArg(Object obj, Object rawValue, Class<?> valueType) {
        if (obj instanceof Collection) {
            return ((Collection)obj).stream().anyMatch(o -> ObjectUtils.equals((Object)o, (Object)ValueMatcher.parse(rawValue.toString(), valueType)));
        }
        return ObjectUtils.equals((Object)obj, (Object)ValueMatcher.parse(rawValue.toString(), valueType));
    }

    public static boolean match(String resources, String rawValue, Class<?> valueType) {
        if (resources == null) {
            return false;
        }
        if (resources.equals("*")) {
            return true;
        }
        try {
            ValueType type = ValueMatcher.checkType(valueType);
            if (type.equals((Object)ValueType.EQUALS)) {
                return ValueMatcher.matchArg(ArgsParser.parse(resources), rawValue, valueType);
            }
            if (type.equals((Object)ValueType.RANGE)) {
                String[] split = resources.split("-");
                if (split.length > 2) {
                    return false;
                }
                if (split.length == 2) {
                    Object value = ValueMatcher.parse(rawValue, valueType);
                    Object v1 = ArgsParser.parse(split[0], () -> ValueMatcher.parse(split[0], valueType));
                    Object v2 = ArgsParser.parse(split[1], () -> ValueMatcher.parse(split[1], valueType));
                    if (v1 == null || v2 == null || v1 instanceof Collection || v2 instanceof Collection || ValueMatcher.checkType(v1) != ValueType.RANGE || ValueMatcher.checkType(v2) != ValueType.RANGE) {
                        return false;
                    }
                    Comparable left = (Comparable)v1;
                    Comparable right = (Comparable)v2;
                    if (left.compareTo(value) <= 0 && right.compareTo(value) >= 0) {
                        return true;
                    }
                } else if (split.length == 1) {
                    return ValueMatcher.matchArg(ArgsParser.parse(split[0]), ValueMatcher.parse(rawValue, valueType), valueType);
                }
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static Object parse(String value, Class<?> type) {
        if (type.equals(String.class)) {
            return value;
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE)) {
            return new Integer(value);
        }
        if (type.equals(Long.class) || type.equals(Long.TYPE)) {
            return new Long(value);
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return new Short(value);
        }
        if (type.equals(Double.class) || type.equals(Double.TYPE)) {
            return new Double(value);
        }
        if (type.equals(Float.class) || type.equals(Float.TYPE)) {
            return new Float(value);
        }
        if (type.equals(Character.class) || type.equals(Character.TYPE)) {
            return Character.valueOf(value.charAt(0));
        }
        if (type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return Boolean.valueOf(value);
        }
        return null;
    }

    public static Class<?> getType(String type) {
        if (type.equals(String.class.getTypeName())) {
            return String.class;
        }
        if (type.equals(Integer.class.getTypeName()) || type.equals(Integer.TYPE.getTypeName())) {
            return Integer.class;
        }
        if (type.equals(Long.class.getTypeName()) || type.equals(Long.TYPE.getTypeName())) {
            return Long.class;
        }
        if (type.equals(Short.class.getTypeName()) || type.equals(Short.TYPE.getTypeName())) {
            return Short.class;
        }
        if (type.equals(Double.class.getTypeName()) || type.equals(Double.TYPE.getTypeName())) {
            return Double.class;
        }
        if (type.equals(Float.class.getTypeName()) || type.equals(Float.TYPE.getTypeName())) {
            return Float.class;
        }
        if (type.equals(Character.class.getTypeName()) || type.equals(Character.TYPE.getTypeName())) {
            return Character.class;
        }
        if (type.equals(Boolean.class.getTypeName()) || type.equals(Boolean.TYPE.getTypeName())) {
            return Boolean.class;
        }
        try {
            return Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static ValueType checkType(String type) {
        try {
            return ValueMatcher.checkType(Class.forName(type));
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return ValueType.OTHER;
        }
    }

    public static ValueType checkType(@NonNull Object obj) {
        return ValueMatcher.checkType(obj.getClass());
    }

    public static ValueType checkType(Class<?> type) {
        if (type.equals(String.class) || type.equals(Boolean.class) || type.equals(Boolean.TYPE)) {
            return ValueType.EQUALS;
        }
        if (type.equals(Integer.class) || type.equals(Integer.TYPE) || type.equals(Long.class) || type.equals(Long.TYPE) || type.equals(Short.class) || type.equals(Short.TYPE) || type.equals(Double.class) || type.equals(Double.TYPE) || type.equals(Float.class) || type.equals(Float.TYPE) || type.equals(Character.class) || type.equals(Character.TYPE)) {
            return ValueType.RANGE;
        }
        return ValueType.OTHER;
    }

    public static enum ValueType {
        RANGE,
        EQUALS,
        OTHER;


        public boolean isOther() {
            return this == OTHER;
        }

        public boolean notOther() {
            return this != OTHER;
        }
    }
}

