/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.util;

import cn.omisheep.authz.core.init.AuInit;
import cn.omisheep.commons.util.StringUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Utils {
    private static final Pattern JSON_RSA_PATTERN = Pattern.compile("\\{.*\".*\".*:.*\"(.*)\".*}");

    public static String parse_RSA_JSON(String json) {
        Matcher matcher = JSON_RSA_PATTERN.matcher(json);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return "";
    }

    public static String beautifulJson(Object o) {
        try {
            return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(o);
        }
        catch (JsonProcessingException e) {
            AuInit.log.error("JsonProcessingException => {}", (Object)e.getMessage());
            return "";
        }
    }

    public static String format(String format, Object ... vals) {
        return StringUtils.format((String)format, (Object[])vals);
    }

    public static boolean isIgnoreSuffix(String uri, String ... suffix) {
        for (String s : suffix) {
            if (!uri.endsWith(s)) continue;
            return true;
        }
        return false;
    }
}

