/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class CompressDirUtil {
    public static boolean compressFileToZip(String compresspath) {
        boolean bool = false;
        try {
            ZipOutputStream zipOutput;
            File file = new File(compresspath);
            if (file.isDirectory()) {
                zipOutput = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(compresspath + ".zip")));
                CompressDirUtil.compressZip(zipOutput, file, "");
            } else {
                zipOutput = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(compresspath.substring(0, compresspath.lastIndexOf(".")) + ".zip")));
                CompressDirUtil.zipOFile(zipOutput, file);
            }
            zipOutput.closeEntry();
            zipOutput.close();
            bool = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bool;
    }

    private static void compressZip(ZipOutputStream zipOutput, File file, String suffixpath) {
        File[] listFiles = file.listFiles();
        if (listFiles == null) {
            return;
        }
        for (File fi : listFiles) {
            if (fi.isDirectory()) {
                if (suffixpath.equals("")) {
                    CompressDirUtil.compressZip(zipOutput, fi, fi.getName());
                    continue;
                }
                CompressDirUtil.compressZip(zipOutput, fi, suffixpath + File.separator + fi.getName());
                continue;
            }
            CompressDirUtil.zip(zipOutput, fi, suffixpath);
        }
    }

    public static void zip(ZipOutputStream zipOutput, File file, String suffixpath) {
        try {
            ZipEntry zEntry = null;
            zEntry = suffixpath.equals("") ? new ZipEntry(file.getName()) : new ZipEntry(suffixpath + File.separator + file.getName());
            zipOutput.putNextEntry(zEntry);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = bis.read(buffer)) != -1) {
                zipOutput.write(buffer, 0, read);
            }
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void zipOFile(ZipOutputStream zipOutput, File file) {
        try {
            ZipEntry zEntry = new ZipEntry(file.getName());
            zipOutput.putNextEntry(zEntry);
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            byte[] buffer = new byte[1024];
            int read = 0;
            while ((read = bis.read(buffer)) != -1) {
                zipOutput.write(buffer, 0, read);
            }
            bis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

