/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.slot;

import cn.omisheep.authz.annotation.RateLimit;
import cn.omisheep.authz.core.ExceptionStatus;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.ipf.Httpd;
import cn.omisheep.authz.core.auth.ipf.LimitMeta;
import cn.omisheep.authz.core.auth.ipf.RequestMeta;
import cn.omisheep.authz.core.msg.RequestMessage;
import cn.omisheep.authz.core.slot.Error;
import cn.omisheep.authz.core.slot.Order;
import cn.omisheep.authz.core.slot.Slot;
import cn.omisheep.authz.core.util.RedisUtils;
import cn.omisheep.commons.util.Async;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.boot.logging.LogLevel;
import org.springframework.web.method.HandlerMethod;

@Order(value=2)
public class RateLimitSlot
implements Slot {
    private final Httpd httpd;

    public RateLimitSlot(Httpd httpd) {
        this.httpd = httpd;
    }

    @Override
    public void chain(HttpMeta httpMeta, HandlerMethod handler, Error error) {
        RequestMeta requestMeta;
        String ip = httpMeta.getIp();
        long now = httpMeta.getNow().getTime();
        String method = httpMeta.getMethod();
        String path = httpMeta.getServletPath();
        String api = httpMeta.getApi();
        LimitMeta limitMeta = this.httpd.getLimitMetadata(method, api);
        Object userId = null;
        if (httpMeta.isHasToken()) {
            userId = httpMeta.getToken().getUserId();
        }
        if (limitMeta == null) {
            httpMeta.log("\u300c\u666e\u901a\u8bbf\u95ee\u300d \t api: [{}] ,  method: [{}] , ip : [{}] , userId : [{}] , path: [{}]  ", api, method, ip, userId, path);
            return;
        }
        RequestMessage requestMessage = new RequestMessage(method, api, ip, userId, now);
        Async.run(() -> RedisUtils.publish(RequestMessage.CHANNEL, requestMessage));
        RateLimit.CheckType checkType = limitMeta.getCheckType();
        Httpd.RequestPool ipRequestPool = (Httpd.RequestPool)((ConcurrentHashMap)this.httpd.getIpRequestPools().get(method)).get(api);
        Httpd.RequestPool userIdRequestPool = (Httpd.RequestPool)((ConcurrentHashMap)this.httpd.getUserIdRequestPools().get(method)).get(api);
        if (checkType.equals((Object)RateLimit.CheckType.USER_ID) && userId == null) {
            return;
        }
        RequestMeta requestMeta2 = requestMeta = checkType.equals((Object)RateLimit.CheckType.IP) ? (RequestMeta)ipRequestPool.get(ip) : (RequestMeta)userIdRequestPool.get(userId.toString());
        if (requestMeta != null && requestMeta.isBan()) {
            if (!requestMeta.enableRelive(now)) {
                httpMeta.log(LogLevel.WARN, "\u300c\u8bf7\u6c42\u9891\u7e41\u3001{}\u5c01\u9501(\u62d2\u7edd)\u300d \t api: [{}] , \u8ddd\u4e0a\u6b21\u8bbf\u95ee: [{}] , method: [{}] , ip : [{}] , userId : [{}] , path: [{}]  ", new Object[]{checkType, api, requestMeta.sinceLastTime(), method, ip, userId, path});
                error.error((Object)ExceptionStatus.REQUEST_REPEAT);
                requestMeta.setLastRequestTime(now);
                return;
            }
            httpMeta.log("\u300c\u89e3\u9664{}\u5c01\u7981(\u89e3\u5c01)\u300d \t api: [{}] , \u8ddd\u4e0a\u6b21\u8bbf\u95ee: [{}] , method: [{}] , ip : [{}] , userId : [{}] , path: [{}]  ", new Object[]{checkType, api, requestMeta.sinceLastTime(), method, ip, userId, path});
            this.httpd.relive(requestMeta, limitMeta, method, api);
        }
        if (requestMeta == null) {
            if (checkType.equals((Object)RateLimit.CheckType.IP)) {
                ipRequestPool.put(ip, new RequestMeta(now, ip, null));
            } else {
                userIdRequestPool.put(userId.toString(), new RequestMeta(now, null, userId));
            }
            httpMeta.log("\u300c\u666e\u901a\u8bbf\u95ee(\u9996\u6b21)\u300d \t method: [{}] , api: [{}] , ip : [{}] , userId: [{}] , path: [{}]  ", method, api, ip, userId, path);
        } else if (requestMeta.request(now, limitMeta.getMaxRequests(), limitMeta.getWindow(), limitMeta.getMinInterval())) {
            httpMeta.log("\u300c\u666e\u901a\u8bbf\u95ee(\u6b63\u5e38)\u300d \t \u8ddd\u4e0a\u6b21\u8bbf\u95ee: [{}]  api: [{}] ,  method: [{}] , ip : [{}] , userId : [{}] , path: [{}]  ", requestMeta.sinceLastTime(), api, method, ip, userId, path);
        } else {
            this.httpd.forbid(now, requestMeta, limitMeta, method, api);
            httpMeta.log(LogLevel.WARN, "\u300c\u8bf7\u6c42\u9891\u7e41\u3001{}\u5c01\u9501(\u5c01\u7981)\u300d \t api: [{}] , \u8ddd\u4e0a\u6b21\u8bbf\u95ee: [{}] , method: [{}] , ip : [{}] , userId : [{}] , path: [{}]  ", new Object[]{checkType, api, requestMeta.sinceLastTime(), method, ip, userId, path});
            error.error((Object)ExceptionStatus.REQUEST_REPEAT);
        }
    }
}

