/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.slot;

import cn.omisheep.authz.core.ExceptionStatus;
import cn.omisheep.authz.core.auth.PermLibrary;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.rpd.AuthzDefender;
import cn.omisheep.authz.core.auth.rpd.ParamMetadata;
import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.authz.core.slot.Error;
import cn.omisheep.authz.core.slot.Order;
import cn.omisheep.authz.core.slot.Slot;
import cn.omisheep.authz.core.util.ValueMatcher;
import cn.omisheep.commons.util.CollectionUtils;
import java.lang.reflect.AnnotatedElement;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;

@Order(value=400)
public class ParameterPermSlot
implements Slot {
    private final PermissionDict permissionDict;
    private final PermLibrary permLibrary;

    public ParameterPermSlot(PermissionDict permissionDict, PermLibrary permLibrary) {
        this.permissionDict = permissionDict;
        this.permLibrary = permLibrary;
    }

    @Override
    public void chain(HttpMeta httpMeta, HandlerMethod handler, Error error) {
        if (!httpMeta.isRequireProtect()) {
            return;
        }
        PermRolesMeta permRolesMeta = this.permissionDict.getRolePermission().get(httpMeta.getMethod()).get(httpMeta.getApi());
        if (permRolesMeta.getParamPermissionsMetadata() == null) {
            return;
        }
        Set<String> roles = null;
        Set<String> permissions = null;
        Map pathVariables = (Map)httpMeta.getRequest().getAttribute(HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE);
        for (MethodParameter parameter : handler.getMethodParameters()) {
            Set<String> perms;
            List<PermRolesMeta.Meta> permissionsMetaList;
            RequestParam requestParam = (RequestParam)AnnotationUtils.getAnnotation((AnnotatedElement)parameter.getParameter(), RequestParam.class);
            PathVariable pathVariable = (PathVariable)AnnotationUtils.getAnnotation((AnnotatedElement)parameter.getParameter(), PathVariable.class);
            String paramName = parameter.getParameter().getName();
            Class<?> paramType = parameter.getParameter().getType();
            ParamMetadata.ParamType type = null;
            String value = null;
            if (pathVariable != null) {
                type = ParamMetadata.ParamType.PATH_VARIABLE;
                if (!pathVariable.name().equals("")) {
                    paramName = pathVariable.name();
                }
                value = (String)pathVariables.get(paramName);
            } else if (requestParam != null) {
                type = ParamMetadata.ParamType.REQUEST_PARAM;
                if (!requestParam.name().equals("")) {
                    paramName = requestParam.name();
                }
                value = httpMeta.getRequest().getParameter(paramName);
            }
            if (type == null || value == null) continue;
            ParamMetadata paramMetadata = null;
            try {
                paramMetadata = permRolesMeta.getParamPermissionsMetadata().get((Object)type).get(paramName);
            }
            catch (Exception e) {
                continue;
            }
            if (paramMetadata == null) continue;
            List<PermRolesMeta.Meta> rolesMetaList = paramMetadata.getRolesMetaList();
            if (rolesMetaList != null && !rolesMetaList.isEmpty()) {
                Object meta22;
                if (httpMeta.getToken() == null) {
                    AuthzDefender.logs("Require Login", httpMeta, permRolesMeta);
                    error.error((Object)ExceptionStatus.REQUIRE_LOGIN);
                    return;
                }
                roles = Optional.ofNullable(httpMeta.getRoles()).orElse(this.permLibrary.getRolesByUserId(httpMeta.getToken().getUserId()));
                httpMeta.setRoles(roles);
                List resourcesMeta = rolesMetaList.stream().filter(meta -> meta.getResources() != null).collect(Collectors.toList());
                List rangeMeta = rolesMetaList.stream().filter(meta -> meta.getRange() != null).collect(Collectors.toList());
                boolean next_resources = true;
                boolean next_range = true;
                for (Object meta22 : resourcesMeta) {
                    if (!ValueMatcher.match(((PermRolesMeta.Meta)meta22).getResources(), value, paramType) || CollectionUtils.containsSub(((PermRolesMeta.Meta)meta22).getRequire(), roles)) continue;
                    next_resources = false;
                    break;
                }
                boolean flag = false;
                meta22 = rangeMeta.iterator();
                while (meta22.hasNext()) {
                    PermRolesMeta.Meta meta3 = (PermRolesMeta.Meta)meta22.next();
                    if (!CollectionUtils.containsSub(meta3.getRequire(), roles)) continue;
                    next_range = false;
                    if (!ValueMatcher.match(meta3.getRange(), value, paramType)) continue;
                    flag = true;
                }
                if (!next_resources || !next_range && (next_range || !flag)) {
                    AuthzDefender.logs("Forbid : permissions exception by request parameter", httpMeta, permRolesMeta);
                    error.error((Object)ExceptionStatus.PERM_EXCEPTION);
                    return;
                }
            }
            if ((permissionsMetaList = paramMetadata.getPermissionsMetaList()) == null || permissionsMetaList.isEmpty()) continue;
            if (httpMeta.getToken() == null) {
                AuthzDefender.logs("Require Login", httpMeta, permRolesMeta);
                error.error((Object)ExceptionStatus.REQUIRE_LOGIN);
                return;
            }
            if (roles == null) {
                roles = Optional.ofNullable(httpMeta.getRoles()).orElse(this.permLibrary.getRolesByUserId(httpMeta.getToken().getUserId()));
                httpMeta.setRoles(roles);
            }
            if ((perms = httpMeta.getPermissions()) != null) {
                permissions = perms;
            } else {
                permissions = new HashSet<String>();
                for (String role : roles) {
                    Set<String> permissionsByRole = this.permLibrary.getPermissionsByRole(role);
                    permissions.addAll(permissionsByRole);
                }
                httpMeta.setPermissions(permissions);
            }
            List resourcesMeta = permissionsMetaList.stream().filter(meta -> meta.getResources() != null).collect(Collectors.toList());
            List rangeMeta = permissionsMetaList.stream().filter(meta -> meta.getRange() != null).collect(Collectors.toList());
            boolean next_resources = true;
            boolean next_range = true;
            for (PermRolesMeta.Meta meta4 : resourcesMeta) {
                if (ValueMatcher.match(meta4.getResources(), value, paramType) || !CollectionUtils.containsSub(meta4.getRequire(), permissions)) continue;
                next_resources = false;
                break;
            }
            boolean flag = false;
            for (PermRolesMeta.Meta meta5 : rangeMeta) {
                if (!CollectionUtils.containsSub(meta5.getRequire(), permissions)) continue;
                next_range = false;
                if (!ValueMatcher.match(meta5.getRange(), value, paramType)) continue;
                flag = true;
            }
            if (next_resources && (next_range || !next_range && flag)) continue;
            AuthzDefender.logs("Forbid : permissions exception by request parameter", httpMeta, permRolesMeta);
            error.error((Object)ExceptionStatus.PERM_EXCEPTION);
            return;
        }
    }
}

