/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.slot;

import cn.omisheep.authz.core.ExceptionStatus;
import cn.omisheep.authz.core.auth.deviced.UserDevicesDict;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.rpd.AuthzDefender;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.authz.core.slot.Error;
import cn.omisheep.authz.core.slot.Order;
import cn.omisheep.authz.core.slot.Slot;
import cn.omisheep.authz.core.tk.Token;
import org.springframework.web.method.HandlerMethod;

@Order(value=100)
public class DeviceSlot
implements Slot {
    private final PermissionDict permissionDict;
    private final UserDevicesDict userDevicesDict;

    public DeviceSlot(PermissionDict permissionDict, UserDevicesDict userDevicesDict) {
        this.permissionDict = permissionDict;
        this.userDevicesDict = userDevicesDict;
    }

    @Override
    public void chain(HttpMeta httpMeta, HandlerMethod handler, Error error) {
        if (!httpMeta.isRequireLogin()) {
            return;
        }
        if (!httpMeta.isHasToken()) {
            AuthzDefender.logs("Require Login", httpMeta);
            error.error((Object)ExceptionStatus.REQUIRE_LOGIN);
            return;
        }
        Token accessToken = httpMeta.getToken();
        switch (this.userDevicesDict.userStatus(accessToken.getUserId(), accessToken.getDeviceType(), accessToken.getDeviceId(), accessToken.getTokenId())) {
            case 1: {
                AuthzDefender.logs("Forbid : expired token exception", httpMeta);
                error.error((Object)ExceptionStatus.ACCESS_TOKEN_OVERDUE);
                return;
            }
            case 2: {
                AuthzDefender.logs("Require Login", httpMeta);
                error.error((Object)ExceptionStatus.REQUIRE_LOGIN);
                return;
            }
            case 3: {
                AuthzDefender.logs("forbid : may have logged in elsewhere", httpMeta);
                error.error((Object)ExceptionStatus.LOGIN_EXCEPTION);
                return;
            }
        }
    }
}

