/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.slot;

import cn.omisheep.authz.core.AuthzException;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.authz.core.slot.Error;
import cn.omisheep.authz.core.slot.Order;
import cn.omisheep.authz.core.slot.Slot;
import cn.omisheep.authz.core.util.ExceptionUtils;
import java.util.Map;
import java.util.Set;
import org.springframework.web.method.HandlerMethod;

@Order(value=10)
public class CheckerSlot
implements Slot {
    private final PermissionDict permissionDict;

    public CheckerSlot(PermissionDict permissionDict) {
        this.permissionDict = permissionDict;
    }

    @Override
    public void chain(HttpMeta httpMeta, HandlerMethod handler, Error error) {
        if (httpMeta == null || httpMeta.isMethod("OPTIONS") || httpMeta.isIgnore()) {
            error.error(null);
            return;
        }
        AuthzException exception = ExceptionUtils.get(httpMeta.getRequest());
        if (exception != null) {
            error.error(null);
            return;
        }
        httpMeta.setRequireProtect(this.requireProtect(httpMeta));
        httpMeta.setRequireLogin(this.requireLogin(httpMeta));
        if (httpMeta.isRequireProtect() || httpMeta.isRequireLogin()) {
            return;
        }
        error.error(null);
    }

    private boolean requireProtect(HttpMeta httpMeta) {
        Map<String, PermRolesMeta> map = this.permissionDict.getRolePermission().get(httpMeta.getMethod());
        if (map == null) {
            return false;
        }
        return map.get(httpMeta.getApi()) != null;
    }

    private boolean requireLogin(HttpMeta httpMeta) {
        Set<String> list = this.permissionDict.getCertificatedMetadata().get(httpMeta.getMethod());
        if (list == null) {
            return httpMeta.isRequireProtect();
        }
        return list.contains(httpMeta.getApi()) || httpMeta.isRequireProtect();
    }
}

