/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.slot;

import cn.omisheep.authz.core.ExceptionStatus;
import cn.omisheep.authz.core.auth.PermLibrary;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.rpd.AuthzDefender;
import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.authz.core.slot.Error;
import cn.omisheep.authz.core.slot.Order;
import cn.omisheep.authz.core.slot.Slot;
import cn.omisheep.authz.core.tk.Token;
import cn.omisheep.commons.util.CollectionUtils;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.springframework.web.method.HandlerMethod;

@Order(value=300)
public class APIPermSlot
implements Slot {
    private final PermissionDict permissionDict;
    private final PermLibrary permLibrary;

    public APIPermSlot(PermissionDict permissionDict, PermLibrary permLibrary) {
        this.permissionDict = permissionDict;
        this.permLibrary = permLibrary;
    }

    @Override
    public void chain(HttpMeta httpMeta, HandlerMethod handler, Error error) {
        if (!httpMeta.isRequireProtect()) {
            return;
        }
        PermRolesMeta permRolesMeta = this.permissionDict.getRolePermission().get(httpMeta.getMethod()).get(httpMeta.getApi());
        if (permRolesMeta.non()) {
            return;
        }
        Token accessToken = httpMeta.getToken();
        Set<String> roles = null;
        boolean e1 = CollectionUtils.isEmpty(permRolesMeta.getRequireRoles());
        boolean e2 = CollectionUtils.isEmpty(permRolesMeta.getExcludeRoles());
        if (!e1 || !e2) {
            roles = this.permLibrary.getRolesByUserId(accessToken.getUserId());
            httpMeta.setRoles(roles);
            if (!e1 && !CollectionUtils.containsSub(permRolesMeta.getRequireRoles(), roles) || !e2 && CollectionUtils.containsSub(permRolesMeta.getExcludeRoles(), roles)) {
                AuthzDefender.logs("Forbid : permissions exception", httpMeta, permRolesMeta);
                error.error((Object)ExceptionStatus.PERM_EXCEPTION);
                return;
            }
        }
        boolean e3 = CollectionUtils.isEmpty(permRolesMeta.getRequirePermissions());
        boolean e4 = CollectionUtils.isEmpty(permRolesMeta.getExcludePermissions());
        if (!e3 || !e4) {
            if (e1 && e2) {
                roles = this.permLibrary.getRolesByUserId(accessToken.getUserId());
                httpMeta.setRoles(roles);
            }
            HashSet<String> perms = new HashSet<String>();
            for (String role : (Set)Optional.ofNullable(roles).orElse(new HashSet())) {
                Set<String> permissionsByRole = this.permLibrary.getPermissionsByRole(role);
                perms.addAll(permissionsByRole);
                if (e4 || !CollectionUtils.containsSub(permRolesMeta.getExcludePermissions(), permissionsByRole)) continue;
                AuthzDefender.logs("Forbid : permissions exception", httpMeta, permRolesMeta);
                error.error((Object)ExceptionStatus.PERM_EXCEPTION);
                return;
            }
            if (!e3 && !CollectionUtils.containsSub(permRolesMeta.getRequirePermissions(), perms)) {
                AuthzDefender.logs("Forbid : permissions exception", httpMeta, permRolesMeta);
                error.error((Object)ExceptionStatus.PERM_EXCEPTION);
                return;
            }
            httpMeta.setPermissions(perms);
        }
        AuthzDefender.logs("Success: API", httpMeta, permRolesMeta);
    }
}

