/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.resolver;

import cn.omisheep.authz.annotation.Decrypt;
import cn.omisheep.authz.core.codec.DecryptHandler;
import cn.omisheep.authz.core.util.Utils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice;

@ControllerAdvice
public class DecryptRequestBodyAdvice
implements RequestBodyAdvice {
    private static final Logger log = LoggerFactory.getLogger(DecryptRequestBodyAdvice.class);
    private final DecryptHandler decryptHandler;

    public DecryptRequestBodyAdvice(DecryptHandler decryptHandler) {
        this.decryptHandler = decryptHandler;
    }

    public boolean supports(MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return parameter.hasMethodAnnotation(Decrypt.class) || parameter.hasParameterAnnotation(Decrypt.class);
    }

    public Object handleEmptyBody(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) throws IOException {
        return new DecryptRequestBodyHandler(inputMessage, (Decrypt)AnnotationUtils.getAnnotation((AnnotatedElement)parameter.getParameter(), Decrypt.class));
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type targetType, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public class DecryptRequestBodyHandler
    implements HttpInputMessage {
        private final HttpHeaders headers;
        private final InputStream body;

        public DecryptRequestBodyHandler(HttpInputMessage inputMessage, Decrypt decrypt) throws IOException {
            String decryptedText;
            this.headers = inputMessage.getHeaders();
            String content = new BufferedReader(new InputStreamReader(inputMessage.getBody())).lines().collect(Collectors.joining(System.lineSeparator()));
            if (decrypt.fields().length != 0) {
                JSONObject object = JSON.parseObject((String)content);
                DecryptRequestBodyAdvice.this.decryptHandler.decryptJSON(object, decrypt);
                decryptedText = JSON.toJSONString((Object)object);
            } else {
                decryptedText = DecryptRequestBodyAdvice.this.decryptHandler.decrypt(Utils.parse_RSA_JSON(content), decrypt);
            }
            if (decryptedText == null || decryptedText == "") {
                decryptedText = "{}";
            }
            this.body = new ByteArrayInputStream(decryptedText.getBytes());
        }

        public InputStream getBody() {
            return this.body;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }
    }
}

