/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.msg;

import cn.omisheep.authz.core.msg.Message;
import cn.omisheep.commons.util.CollectionUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class CacheMessage
implements Message {
    public static String CHANNEL;
    private String id = uuid;
    private Type type;
    private String pattern;
    private Set<String> keys;

    public static CacheMessage write(String key) {
        return CacheMessage.single(key).setType(Type.WRITE);
    }

    public static CacheMessage write(String pattern, Collection<String> keys) {
        return CacheMessage.collect(keys).setType(Type.WRITE).setPattern(pattern);
    }

    public static CacheMessage delete(String key) {
        return CacheMessage.single(key).setType(Type.DELETE);
    }

    public static CacheMessage delete(Collection<String> keys) {
        return CacheMessage.collect(keys).setType(Type.DELETE);
    }

    private static CacheMessage collect(Collection<String> keys) {
        CacheMessage message = new CacheMessage();
        message.keys = keys instanceof Set ? (Set<Object>)keys : new HashSet<String>(keys);
        return message;
    }

    private static CacheMessage single(String key) {
        CacheMessage message = new CacheMessage();
        message.keys = CollectionUtils.singletonSet((String)key);
        return message;
    }

    public static boolean ignore(CacheMessage message) {
        return message == null || message.id.equals(uuid);
    }

    public String getId() {
        return this.id;
    }

    public Type getType() {
        return this.type;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Set<String> getKeys() {
        return this.keys;
    }

    public CacheMessage setId(String id) {
        this.id = id;
        return this;
    }

    public CacheMessage setType(Type type) {
        this.type = type;
        return this;
    }

    public CacheMessage setPattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public CacheMessage setKeys(Set<String> keys) {
        this.keys = keys;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CacheMessage)) {
            return false;
        }
        CacheMessage other = (CacheMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Type this$type = this.getType();
        Type other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        Set<String> this$keys = this.getKeys();
        Set<String> other$keys = other.getKeys();
        return !(this$keys == null ? other$keys != null : !((Object)this$keys).equals(other$keys));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CacheMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Type $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        Set<String> $keys = this.getKeys();
        result = result * 59 + ($keys == null ? 43 : ((Object)$keys).hashCode());
        return result;
    }

    public String toString() {
        return "CacheMessage(id=" + this.getId() + ", type=" + (Object)((Object)this.getType()) + ", pattern=" + this.getPattern() + ", keys=" + this.getKeys() + ")";
    }

    public static enum Type {
        WRITE,
        DELETE;

    }
}

