/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.interceptor;

import cn.omisheep.authz.AuHelper;
import cn.omisheep.authz.annotation.Certificated;
import cn.omisheep.authz.annotation.Perms;
import cn.omisheep.authz.annotation.Roles;
import cn.omisheep.authz.core.NotLoginException;
import cn.omisheep.authz.core.PermissionException;
import cn.omisheep.authz.core.auth.PermLibrary;
import cn.omisheep.authz.core.auth.ipf.HttpMeta;
import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.init.AuCoreInitialization;
import cn.omisheep.commons.util.CollectionUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;

@Aspect
public class AuthzMethodPermissionChecker {
    private static final Logger log = LoggerFactory.getLogger(AuthzMethodPermissionChecker.class);
    private final PermLibrary permLibrary;
    private final HashMap<String, PermRolesMeta> meta = new HashMap();

    public AuthzMethodPermissionChecker(PermLibrary permLibrary) {
        this.permLibrary = permLibrary;
    }

    @Pointcut(value="@annotation(cn.omisheep.authz.annotation.Roles)")
    public void hasRoles() {
    }

    @Pointcut(value="@annotation(cn.omisheep.authz.annotation.Perms)")
    public void hasPerms() {
    }

    @Pointcut(value="@annotation(cn.omisheep.authz.annotation.Certificated)")
    public void hasCertificated() {
    }

    @Pointcut(value="@within(org.springframework.web.bind.annotation.RequestMapping)")
    public void hasRequestMapping() {
    }

    @Before(value="!hasRequestMapping() && (hasCertificated()||hasPerms()||hasRoles()) ")
    public void around(JoinPoint joinPoint) {
        try {
            MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
            Method method = joinPoint.getSignature().getDeclaringType().getMethod(joinPoint.getSignature().getName(), methodSignature.getParameterTypes());
            Certificated mergedAnnotation = (Certificated)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, Certificated.class);
            Perms perms = (Perms)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, Perms.class);
            Roles roles = (Roles)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, Roles.class);
            PermRolesMeta permRolesMeta = this.meta.computeIfAbsent(joinPoint.getSignature().toLongString(), r -> AuCoreInitialization.generatePermRolesMeta(perms, roles));
            HttpMeta httpMeta = AuHelper.getHttpMeta();
            if (!(mergedAnnotation == null && roles == null && perms == null || AuHelper.isLogin())) {
                throw new NotLoginException();
            }
            if (roles != null || perms != null) {
                Set<String> rolesByUserId = Optional.ofNullable(httpMeta.getRoles()).orElse(this.permLibrary.getRolesByUserId(httpMeta.getUserId()));
                if (!CollectionUtils.containsSub(permRolesMeta.getRequireRoles(), rolesByUserId) || CollectionUtils.containsSub(permRolesMeta.getExcludeRoles(), rolesByUserId)) {
                    throw new PermissionException();
                }
                if (perms != null) {
                    Set permissionsByRole = Optional.ofNullable(httpMeta.getPermissions()).orElseGet(() -> {
                        HashSet p = new HashSet();
                        rolesByUserId.forEach(role -> p.addAll(this.permLibrary.getPermissionsByRole((String)role)));
                        return p;
                    });
                    if (!CollectionUtils.containsSub(permRolesMeta.getRequirePermissions(), (Set)permissionsByRole) || CollectionUtils.containsSub(permRolesMeta.getExcludePermissions(), (Set)permissionsByRole)) {
                        throw new PermissionException();
                    }
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

