/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.init;

import cn.omisheep.authz.annotation.BatchAuthority;
import cn.omisheep.authz.annotation.Certificated;
import cn.omisheep.authz.annotation.IPRangeLimit;
import cn.omisheep.authz.annotation.Perms;
import cn.omisheep.authz.annotation.RateLimit;
import cn.omisheep.authz.annotation.Roles;
import cn.omisheep.authz.core.AuthzProperties;
import cn.omisheep.authz.core.Constants;
import cn.omisheep.authz.core.Pelcron;
import cn.omisheep.authz.core.VersionInfo;
import cn.omisheep.authz.core.auth.PermLibrary;
import cn.omisheep.authz.core.auth.deviced.DeviceConfig;
import cn.omisheep.authz.core.auth.deviced.UserDevicesDict;
import cn.omisheep.authz.core.auth.ipf.Httpd;
import cn.omisheep.authz.core.auth.ipf.LimitMeta;
import cn.omisheep.authz.core.auth.rpd.AuthzDefender;
import cn.omisheep.authz.core.auth.rpd.ParamMetadata;
import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.PermissionDict;
import cn.omisheep.authz.core.cache.Cache;
import cn.omisheep.authz.core.codec.AuthzRSAManager;
import cn.omisheep.authz.core.init.AuInit;
import cn.omisheep.authz.core.init.CallbackInit;
import cn.omisheep.authz.core.msg.Message;
import cn.omisheep.authz.core.util.LogUtils;
import cn.omisheep.authz.core.util.RedisUtils;
import cn.omisheep.authz.core.util.ValueMatcher;
import cn.omisheep.authz.support.util.IPRangeMeta;
import cn.omisheep.commons.util.Async;
import cn.omisheep.commons.util.CollectionUtils;
import cn.omisheep.commons.util.TaskBuilder;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.aop.support.AopUtils;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.system.ApplicationHome;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.MethodParameter;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.AbstractHandlerMethodMapping;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;

public class AuCoreInitialization
implements ApplicationContextAware {
    private final AuthzProperties properties;
    private final Httpd httpd;
    private final UserDevicesDict userDevicesDict;
    private final PermissionDict permissionDict;
    private final PermLibrary permLibrary;
    private final Cache cache;
    private ApplicationContext ctx;

    public AuCoreInitialization(AuthzProperties properties, Httpd httpd, UserDevicesDict userDevicesDict, PermissionDict permissionDict, PermLibrary permLibrary, Cache cache) {
        this.properties = properties;
        this.httpd = httpd;
        this.userDevicesDict = userDevicesDict;
        this.permissionDict = permissionDict;
        this.cache = cache;
        this.permLibrary = permLibrary;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.ctx = applicationContext;
        this.init();
        CallbackInit.callbackInit(applicationContext);
    }

    public void init() {
        VersionInfo.init(this.properties.getApp());
        AbstractHandlerMethodMapping methodMapping = (AbstractHandlerMethodMapping)this.ctx.getBean("requestMappingHandlerMapping");
        Map mapRet = methodMapping.getHandlerMethods();
        this.initPermissionDict(this.ctx, mapRet);
        LogUtils.logDebug("PermissionDict init success \n", new Object[0]);
        this.initHttpd(this.ctx, mapRet);
        LogUtils.logDebug("Httpd init success \n", new Object[0]);
        this.initUserDevicesDict();
        LogUtils.logDebug("UserDevicesDict init success", new Object[0]);
        AuthzDefender.init(this.userDevicesDict, this.permLibrary);
        AuthzRSAManager.setTime(this.properties.getRsa().getRsaKeyRefreshWithPeriod());
        if (this.properties.getRsa().isAuto() && (this.properties.getRsa().getCustomPrivateKey() == null || this.properties.getRsa().getCustomPublicKey() == null)) {
            AuthzRSAManager.setAuto(true);
        } else {
            AuthzRSAManager.setAuto(false);
            AuthzProperties.RSAConfig rsaConfig = this.properties.getRsa();
            AuthzRSAManager.setAuKeyPair(rsaConfig.getCustomPublicKey(), rsaConfig.getCustomPrivateKey());
        }
        if (!this.properties.getCache().isEnableRedis()) {
            TaskBuilder.schedule(Pelcron::activeExpireCycle, (String)this.properties.getUserBufferRefreshWithPeriod());
        }
        TaskBuilder.schedule(Pelcron::GC, (String)this.properties.getGcPeriod());
        AuInit.log.info("Started Authz Message id: {}", (Object)Message.uuid);
        this.initVersionInfo();
        AuInit.log.info("project md5 => {}", (Object)VersionInfo.getMd5());
    }

    private void initVersionInfo() {
        try {
            VersionInfo.setProjectPath(this.getJarPath());
            VersionInfo.setMd5check(this.properties.isMd5check());
            VersionInfo.compute();
            VersionInfo.born();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String getJarPath() {
        Object o = this.ctx.getBeansWithAnnotation(SpringBootApplication.class).values().stream().findAny().orElse(null);
        if (o != null) {
            ApplicationHome home = new ApplicationHome(o.getClass());
            return home.getSource().getAbsolutePath();
        }
        return null;
    }

    private <A extends Annotation> A getAnnoatation(Object value, Class<A> clz) {
        Annotation annotation = AnnotatedElementUtils.getMergedAnnotation(value.getClass(), clz);
        try {
            if (annotation == null) {
                return (A)AnnotatedElementUtils.getMergedAnnotation(Class.forName(this.getTypeName(value)), clz);
            }
            return (A)annotation;
        }
        catch (Exception e) {
            return null;
        }
    }

    private <A extends Annotation> Set<A> getAnnoatations(Object value, Class<A> clz) {
        Set annotations = AnnotatedElementUtils.getAllMergedAnnotations(value.getClass(), clz);
        try {
            if (annotations == null || annotations.isEmpty()) {
                return AnnotatedElementUtils.getAllMergedAnnotations(Class.forName(this.getTypeName(value)), clz);
            }
            return annotations;
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getTypeName(Object value) {
        String name = value.getClass().getTypeName();
        int i = name.indexOf(36);
        if (i != -1) {
            return name.substring(0, name.indexOf("$"));
        }
        return name;
    }

    private void initPermissionDict(ApplicationContext applicationContext, Map<RequestMappingInfo, HandlerMethod> mapRet) {
        PermissionDict.setPermSeparator(",");
        HashSet toBeLoadedRoles = new HashSet();
        HashMap<String, Map<String, PermRolesMeta>> authzMetadata = new HashMap<String, Map<String, PermRolesMeta>>();
        HashMap<String, Map<String, IPRangeMeta>> ipRangeMedata = new HashMap<String, Map<String, IPRangeMeta>>();
        HashMap<String, Set<String>> certificatedMetadata = new HashMap<String, Set<String>>();
        HashMap pMap = new HashMap();
        HashMap rMap = new HashMap();
        HashMap iMap = new HashMap();
        LinkedList cList = new LinkedList();
        applicationContext.getBeansWithAnnotation(Roles.class).forEach((key, value) -> {
            String name = this.getTypeName(value);
            Roles roles = this.getAnnoatation(value, Roles.class);
            if (roles != null) {
                rMap.put(name, AuCoreInitialization.generatePermRolesMeta(null, roles));
            }
        });
        applicationContext.getBeansWithAnnotation(Perms.class).forEach((key, value) -> {
            String name = this.getTypeName(value);
            Perms perms = this.getAnnoatation(value, Perms.class);
            if (perms != null) {
                pMap.put(name, AuCoreInitialization.generatePermRolesMeta(perms, null));
            }
        });
        applicationContext.getBeansWithAnnotation(Certificated.class).forEach((key, value) -> {
            Certificated certificated = this.getAnnoatation(value, Certificated.class);
            if (certificated != null) {
                cList.add(this.getTypeName(value));
            }
        });
        applicationContext.getBeansWithAnnotation(IPRangeLimit.class).forEach((key, value) -> {
            IPRangeLimit ipRangeLimit = this.getAnnoatation(value, IPRangeLimit.class);
            iMap.put(this.getTypeName(value), new IPRangeMeta().setAllow(ipRangeLimit.allow()).setDeny(ipRangeLimit.deny()));
        });
        mapRet.forEach((key, value) -> {
            IPRangeLimit ipRangeLimit;
            IPRangeMeta iFc = (IPRangeMeta)iMap.get(value.getBeanType().getName());
            PermRolesMeta pFc = (PermRolesMeta)pMap.get(value.getBeanType().getName());
            PermRolesMeta rFc = (PermRolesMeta)rMap.get(value.getBeanType().getName());
            PermRolesMeta permRolesMeta = AuCoreInitialization.generatePermRolesMeta((Perms)value.getMethodAnnotation(Perms.class), (Roles)value.getMethodAnnotation(Roles.class));
            IPRangeMeta ipRangeMeta = new IPRangeMeta();
            Certificated certificated = (Certificated)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)value.getMethod(), Certificated.class);
            if (cList.contains(value.getBeanType().getTypeName()) || certificated != null) {
                key.getMethodsCondition().getMethods().forEach(method -> certificatedMetadata.computeIfAbsent(method.name(), r -> new HashSet()).addAll(this.getPatterns((RequestMappingInfo)key)));
            }
            if (rFc != null) {
                if (permRolesMeta == null) {
                    permRolesMeta = new PermRolesMeta();
                }
                if (rFc.getRequireRoles() != null) {
                    if (permRolesMeta.getRequireRoles() != null) {
                        permRolesMeta.getRequireRoles().addAll(rFc.getRequireRoles());
                    } else {
                        permRolesMeta.setRequireRoles(rFc.getRequireRoles());
                    }
                }
                if (rFc.getExcludeRoles() != null) {
                    if (permRolesMeta.getExcludeRoles() != null) {
                        permRolesMeta.getExcludeRoles().addAll(rFc.getExcludeRoles());
                    } else {
                        permRolesMeta.setExcludeRoles(rFc.getExcludeRoles());
                    }
                }
            }
            if (pFc != null) {
                Set<Set<String>> requirePermissions;
                if (permRolesMeta == null) {
                    permRolesMeta = new PermRolesMeta();
                }
                if ((requirePermissions = pFc.getRequirePermissions()) != null) {
                    if (permRolesMeta.getRequirePermissions() != null) {
                        permRolesMeta.getRequirePermissions().addAll(requirePermissions);
                    } else {
                        permRolesMeta.setRequirePermissions(requirePermissions);
                    }
                }
                if (pFc.getExcludePermissions() != null) {
                    Set<Set<String>> excludePermissions = pFc.getExcludePermissions();
                    if (permRolesMeta.getExcludePermissions() != null) {
                        permRolesMeta.getExcludePermissions().addAll(excludePermissions);
                    } else {
                        permRolesMeta.setExcludePermissions(excludePermissions);
                    }
                }
            }
            if (permRolesMeta != null) {
                Set<Set<String>> requireRoles = permRolesMeta.getRequireRoles();
                Set<Set<String>> excludeRoles = permRolesMeta.getExcludeRoles();
                if (requireRoles != null) {
                    requireRoles.forEach(toBeLoadedRoles::addAll);
                }
                if (excludeRoles != null) {
                    excludeRoles.forEach(toBeLoadedRoles::addAll);
                }
                PermRolesMeta finalPermRolesMeta = permRolesMeta;
                key.getMethodsCondition().getMethods().forEach(method -> this.getPatterns((RequestMappingInfo)key).forEach(patternValue -> authzMetadata.computeIfAbsent(method.toString(), r -> new HashMap()).put(patternValue, finalPermRolesMeta)));
            }
            if (iFc != null) {
                ipRangeMeta.setAllow(iFc.getAllow());
                ipRangeMeta.setDeny(iFc.getDeny());
            }
            if ((ipRangeLimit = (IPRangeLimit)value.getMethodAnnotation(IPRangeLimit.class)) != null) {
                ipRangeMeta.setAllow(ipRangeLimit.allow()).setDeny(ipRangeLimit.deny());
                if (iFc != null) {
                    ipRangeMeta.getAllow().addAll(iFc.getAllow());
                    ipRangeMeta.getDeny().addAll(iFc.getDeny());
                }
            }
            if (ipRangeMeta.getDeny() != null && !ipRangeMeta.getDeny().isEmpty() || ipRangeMeta.getAllow() != null && !ipRangeMeta.getAllow().isEmpty()) {
                key.getMethodsCondition().getMethods().forEach(method -> this.getPatterns((RequestMappingInfo)key).forEach(patternValue -> ipRangeMedata.computeIfAbsent(method.toString(), r -> new HashMap()).put(patternValue, ipRangeMeta)));
            }
            key.getMethodsCondition().getMethods().forEach(method -> this.getPatterns((RequestMappingInfo)key).forEach(patternValue -> {
                AuCoreInitialization auCoreInitialization = this;
                Map methodRawMap = auCoreInitialization.permissionDict.getRawMap().computeIfAbsent(method.toString(), r -> new HashMap());
                Map rawParamTypeMapMap = methodRawMap.computeIfAbsent(patternValue, r -> new HashMap());
                for (MethodParameter param : value.getMethodParameters()) {
                    Class<?> paramType = param.getParameter().getType();
                    if (ValueMatcher.checkType(paramType).isOther()) continue;
                    RequestParam requestParam = (RequestParam)param.getParameterAnnotation(RequestParam.class);
                    PathVariable pathVariable = (PathVariable)param.getParameterAnnotation(PathVariable.class);
                    String paramName = param.getParameter().getName();
                    ParamMetadata.ParamType type = null;
                    if (pathVariable != null) {
                        type = ParamMetadata.ParamType.PATH_VARIABLE;
                        if (!pathVariable.name().equals("")) {
                            paramName = pathVariable.name();
                        }
                    } else if (requestParam != null) {
                        type = ParamMetadata.ParamType.REQUEST_PARAM;
                        if (!requestParam.name().equals("")) {
                            paramName = requestParam.name();
                        }
                    }
                    Map rawParamMap = rawParamTypeMapMap.computeIfAbsent(type, r -> new HashMap());
                    rawParamMap.put(paramName, paramType);
                    Roles rolesByParam = (Roles)param.getParameterAnnotation(Roles.class);
                    Perms permsByParam = (Perms)param.getParameterAnnotation(Perms.class);
                    BatchAuthority batchAuthority = (BatchAuthority)param.getParameterAnnotation(BatchAuthority.class);
                    if (rolesByParam == null && permsByParam == null && batchAuthority == null) continue;
                    ArrayList<PermRolesMeta.Meta> rolesMetaList = new ArrayList<PermRolesMeta.Meta>();
                    ArrayList<PermRolesMeta.Meta> permsMetaList = new ArrayList<PermRolesMeta.Meta>();
                    PermRolesMeta.Meta vr = AuCoreInitialization.generateRolesMeta(rolesByParam);
                    PermRolesMeta.Meta vp = AuCoreInitialization.generatePermMeta(permsByParam);
                    if (vr != null) {
                        rolesMetaList.add(vr);
                    }
                    if (vp != null) {
                        permsMetaList.add(vp);
                    }
                    if (batchAuthority != null) {
                        Perms[] ps;
                        Roles[] rs;
                        for (Roles r2 : rs = batchAuthority.roles()) {
                            PermRolesMeta.Meta v = AuCoreInitialization.generateRolesMeta(r2);
                            if (v == null) continue;
                            rolesMetaList.add(v);
                            if (v.getRequire() != null) {
                                v.getRequire().forEach(toBeLoadedRoles::addAll);
                            }
                            if (v.getExclude() == null) continue;
                            v.getExclude().forEach(toBeLoadedRoles::addAll);
                        }
                        for (Perms p : ps = batchAuthority.perms()) {
                            PermRolesMeta.Meta v = AuCoreInitialization.generatePermMeta(p);
                            if (v == null) continue;
                            permsMetaList.add(v);
                        }
                    }
                    if (type == null) continue;
                    PermRolesMeta meta = authzMetadata.computeIfAbsent(method.toString(), r -> new HashMap()).computeIfAbsent(patternValue, r -> new PermRolesMeta());
                    meta.put(type, paramName, new ParamMetadata(paramType, rolesMetaList, permsMetaList));
                }
            }));
        });
        try {
            PermissionDict.initAuthzMetadata(authzMetadata);
            PermissionDict.initIPRangeMeta(ipRangeMedata);
            PermissionDict.initCertificatedMetadata(certificatedMetadata);
            PermissionDict.setGlobalAllow(IPRangeMeta.parse(this.properties.getGlobalIpRange().getAllow()));
            PermissionDict.setGlobalDeny(IPRangeMeta.parse(this.properties.getGlobalIpRange().getDeny()));
            PermissionDict.setSupportNative(this.properties.getGlobalIpRange().isSupportNative());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PermissionDict.init(this.permissionDict);
        Async.run(() -> {
            List collect = toBeLoadedRoles.stream().collect(Collectors.toList());
            List rolesPerms = RedisUtils.Obj.get(collect.stream().map(role -> Constants.PERMISSIONS_BY_ROLE_KEY_PREFIX.get() + role).collect(Collectors.toList()));
            Iterator iterator = collect.iterator();
            HashMap<String, Set> map = new HashMap<String, Set>();
            rolesPerms.forEach(perms -> map.put((String)iterator.next(), (Set)perms));
            map.forEach((role, v) -> {
                Set<String> permissions = this.permLibrary.getPermissionsByRole((String)role);
                this.cache.setSneaky(Constants.PERMISSIONS_BY_ROLE_KEY_PREFIX.get() + role, permissions, Integer.MAX_VALUE);
            });
        });
    }

    public static PermRolesMeta.Meta generatePermMeta(Perms p) {
        if (p == null) {
            return null;
        }
        PermRolesMeta.Meta permsMeta = new PermRolesMeta.Meta();
        boolean flag = false;
        if (p.require() != null && p.require().length != 0) {
            permsMeta.setRequire(CollectionUtils.splitStrValsToSets((String)",", (String[])p.require()));
            flag = true;
        }
        if (p.exclude() != null && p.exclude().length != 0) {
            permsMeta.setExclude(CollectionUtils.splitStrValsToSets((String)",", (String[])p.exclude()));
            flag = true;
        }
        if (p.paramResources().length != 0) {
            permsMeta.setResources(CollectionUtils.ofSet((Object[])p.paramResources()));
        }
        if (p.paramRange().length != 0) {
            permsMeta.setRange(CollectionUtils.ofSet((Object[])p.paramRange()));
        }
        return flag ? permsMeta : null;
    }

    public static PermRolesMeta.Meta generateRolesMeta(Roles r) {
        if (r == null) {
            return null;
        }
        PermRolesMeta.Meta rolesMeta = new PermRolesMeta.Meta();
        boolean flag = false;
        if (r.require() != null && r.require().length != 0) {
            rolesMeta.setRequire(CollectionUtils.splitStrValsToSets((String)",", (String[])r.require()));
            flag = true;
        }
        if (r.exclude() != null && r.exclude().length != 0) {
            rolesMeta.setExclude(CollectionUtils.splitStrValsToSets((String)",", (String[])r.exclude()));
            flag = true;
        }
        if (r.paramResources().length != 0) {
            rolesMeta.setResources(CollectionUtils.ofSet((Object[])r.paramResources()));
        }
        if (r.paramRange().length != 0) {
            rolesMeta.setRange(CollectionUtils.ofSet((Object[])r.paramRange()));
        }
        return flag ? rolesMeta : null;
    }

    public static PermRolesMeta generatePermRolesMeta(Perms p, Roles r) {
        PermRolesMeta prm = new PermRolesMeta();
        boolean flag = false;
        if (p != null) {
            if (p.require() != null && p.require().length != 0) {
                prm.setRequirePermissions(CollectionUtils.splitStrValsToSets((String)",", (String[])p.require()));
            }
            if (p.exclude() != null && p.exclude().length != 0) {
                prm.setExcludePermissions(CollectionUtils.splitStrValsToSets((String)",", (String[])p.exclude()));
            }
            flag = true;
        }
        if (r != null) {
            if (r.require() != null && r.require().length != 0) {
                prm.setRequireRoles(CollectionUtils.splitStrValsToSets((String)",", (String[])r.require()));
            }
            if (r.exclude() != null && r.exclude().length != 0) {
                prm.setExcludeRoles(CollectionUtils.splitStrValsToSets((String)",", (String[])r.exclude()));
            }
            flag = true;
        }
        return flag ? prm : null;
    }

    private void initHttpd(ApplicationContext applicationContext, Map<RequestMappingInfo, HandlerMethod> mapRet) {
        Map<String, Map<String, LimitMeta>> httpdLimitedMetaMap = this.httpd.getRateLimitMetadata();
        HashMap cMap = new HashMap();
        applicationContext.getBeansWithAnnotation(RateLimit.class).forEach((key, value) -> {
            Class aClass = AopUtils.getTargetClass((Object)value);
            RateLimit rateLimit = aClass.getAnnotation(RateLimit.class);
            if (rateLimit != null) {
                cMap.put(aClass.getName(), new LimitMeta(rateLimit.window(), rateLimit.maxRequests(), rateLimit.punishmentTime(), rateLimit.minInterval(), rateLimit.associatedPatterns(), rateLimit.checkType()));
            }
        });
        mapRet.forEach((key, value) -> {
            Set methods = key.getMethodsCondition().getMethods();
            RateLimit rateLimit = (RateLimit)value.getMethodAnnotation(RateLimit.class);
            if (rateLimit != null) {
                LimitMeta limitMeta = new LimitMeta(rateLimit.window(), rateLimit.maxRequests(), rateLimit.punishmentTime(), rateLimit.minInterval(), rateLimit.associatedPatterns(), rateLimit.checkType());
                methods.forEach(method -> this.getPatterns((RequestMappingInfo)key).forEach(patternValue -> httpdLimitedMetaMap.computeIfAbsent(method.toString(), r -> new HashMap()).put(patternValue, limitMeta)));
            } else {
                methods.forEach(method -> this.getPatterns((RequestMappingInfo)key).forEach(patternValue -> {
                    LimitMeta limitMeta = (LimitMeta)cMap.get(value.getBeanType().getName());
                    if (limitMeta != null) {
                        httpdLimitedMetaMap.computeIfAbsent(method.toString(), r -> new HashMap()).put(patternValue, limitMeta);
                    }
                }));
            }
            HashMap userIdRequestPool = new HashMap();
            HashMap ipRequestPool = new HashMap();
            key.getMethodsCondition().getMethods().forEach(method -> {
                this.getPatterns((RequestMappingInfo)key).forEach(patternValue -> {
                    userIdRequestPool.put(patternValue, new Httpd.RequestPool());
                    ipRequestPool.put(patternValue, new Httpd.RequestPool());
                    this.httpd.setPathPattern((String)patternValue);
                });
                this.httpd.getIpRequestPools().computeIfAbsent(method.toString(), r -> new ConcurrentHashMap()).putAll(ipRequestPool);
                this.httpd.getUserIdRequestPools().computeIfAbsent(method.toString(), r -> new ConcurrentHashMap()).putAll(userIdRequestPool);
            });
        });
        this.httpd.setIgnoreSuffix(this.properties.getIgnoreSuffix());
    }

    private void initUserDevicesDict() {
        DeviceConfig.isSupportMultiDevice = this.properties.getUser().isSupportMultiDevice();
        DeviceConfig.isSupportMultiUserForSameDeviceType = this.properties.getUser().isSupportMultiUserForSameDeviceType();
    }

    private Set<String> getPatterns(RequestMappingInfo info) {
        try {
            return info.getPatternsCondition().getPatterns();
        }
        catch (Exception e) {
            return (Set)RequestMappingInfo.class.getMethod("getPatternValues", new Class[0]).invoke((Object)info, new Object[0]);
        }
    }
}

