/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.codec;

import cn.omisheep.authz.annotation.Decrypt;
import cn.omisheep.authz.core.codec.Decryptor;
import cn.omisheep.authz.core.codec.RSADecryptor;
import cn.omisheep.authz.core.util.AUtils;
import cn.omisheep.commons.util.StringUtils;
import com.alibaba.fastjson.JSONObject;
import java.util.Arrays;

public class DecryptHandler {
    private final Class<? extends Decryptor> defaultDecryptor;

    public DecryptHandler(Class<? extends Decryptor> defaultDecryptor) {
        this.defaultDecryptor = defaultDecryptor;
    }

    public String decrypt(String decryptText, Decrypt decrypt) {
        return this.decrypt(decryptText, decrypt.decryptor());
    }

    public void decryptJSON(JSONObject obj, Decrypt decrypt) {
        for (String field : decrypt.fields()) {
            this.decryptJSON(field, obj, decrypt.decryptor());
        }
    }

    public String decrypt(String decryptText, Class<? extends Decryptor> decryptorClass) {
        Decryptor decryptor = RSADecryptor.class != decryptorClass ? AUtils.getBean(decryptorClass) : AUtils.getBean(this.defaultDecryptor);
        return decryptor.decrypt(decryptText);
    }

    public void decryptJSON(JSONObject obj, String[] fields, Class<? extends Decryptor> decryptorClass) {
        for (String field : fields) {
            this.decryptJSON(field, obj, decryptorClass);
        }
    }

    private void decryptJSON(String name, JSONObject obj, Class<? extends Decryptor> decryptorClass) {
        if (!StringUtils.hasText((String)name)) {
            return;
        }
        String[] trace = (String[])Arrays.stream(name.split("\\.")).distinct().toArray(String[]::new);
        this.decrypt(trace, obj, decryptorClass);
    }

    private void decrypt(String[] trace, JSONObject obj, Class<? extends Decryptor> decryptorClass) {
        if (obj == null) {
            return;
        }
        if (trace.length == 1) {
            if (obj.get((Object)trace[0]) instanceof String) {
                obj.put(trace[0], (Object)this.decrypt(obj.getString(trace[0]), decryptorClass));
            }
        } else if (obj.get((Object)trace[0]) instanceof JSONObject) {
            this.decrypt(Arrays.copyOfRange(trace, 1, trace.length), obj.getJSONObject(trace[0]), decryptorClass);
        }
    }
}

