/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.cache;

import cn.omisheep.authz.core.AuthzProperties;
import cn.omisheep.authz.core.Constants;
import cn.omisheep.authz.core.cache.Cache;
import cn.omisheep.authz.core.msg.CacheMessage;
import cn.omisheep.authz.core.util.LogUtils;
import cn.omisheep.authz.core.util.RedisUtils;
import cn.omisheep.commons.util.Async;
import cn.omisheep.commons.util.CollectionUtils;
import cn.omisheep.commons.util.TimeUtils;
import cn.omisheep.commons.util.Utils;
import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.Expiry;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.github.benmanes.caffeine.cache.Scheduler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class L2Cache
implements Cache {
    private final LoadingCache<String, Cache.CacheItem> cache;
    private final ConcurrentSkipListSet<String> keyPatterns = new ConcurrentSkipListSet();

    public L2Cache(AuthzProperties properties) {
        Caffeine caffeine = Caffeine.newBuilder().scheduler(Scheduler.systemScheduler()).expireAfter((Expiry)new Cache.CacheExpiry(TimeUtils.parseTimeValue((String)properties.getCache().getExpireAfterReadOrUpdateTime()), TimeUnit.MILLISECONDS));
        Long cacheMaximumSize = properties.getCache().getCacheMaximumSize();
        if (cacheMaximumSize != null) {
            caffeine.maximumSize(cacheMaximumSize.longValue());
        }
        this.cache = caffeine.build((CacheLoader)new CacheLoader<String, Cache.CacheItem>(){

            public @Nullable Cache.CacheItem load(@NonNull String key) {
                boolean b;
                Object o = RedisUtils.Obj.get(key);
                long ttl = RedisUtils.ttl(key);
                boolean bl = b = ttl != -2L;
                if (key.startsWith(Constants.USER_ROLES_KEY_PREFIX.get()) || key.startsWith(Constants.PERMISSIONS_BY_ROLE_KEY_PREFIX.get())) {
                    ttl = Integer.MAX_VALUE;
                }
                if (o != null) {
                    return new Cache.CacheItem<Object>(ttl, o);
                }
                if (b) {
                    return new Cache.CacheItem<Object>(ttl, null);
                }
                return null;
            }

            public @NonNull Map<@NonNull String, @NonNull Cache.CacheItem> loadAll(@NonNull Iterable<? extends @NonNull String> keys) {
                ArrayList<String> list = new ArrayList<String>();
                keys.forEach(list::add);
                List objects = RedisUtils.Obj.get(list);
                HashMap<String, Cache.CacheItem> map = new HashMap<String, Cache.CacheItem>();
                Iterator<? extends @NonNull String> iterator = keys.iterator();
                for (Object o : objects) {
                    boolean b;
                    String key = iterator.next();
                    long ttl = RedisUtils.ttl(key);
                    boolean bl = b = ttl != -2L;
                    if (key.startsWith(Constants.USER_ROLES_KEY_PREFIX.get()) || key.startsWith(Constants.PERMISSIONS_BY_ROLE_KEY_PREFIX.get())) {
                        ttl = Integer.MAX_VALUE;
                    }
                    if (o != null) {
                        map.put(key, new Cache.CacheItem(ttl, o));
                        continue;
                    }
                    if (!b) continue;
                    map.put(key, new Cache.CacheItem<Object>(ttl, null));
                }
                return map;
            }
        });
    }

    @Override
    public @NonNull Set<String> keys(@NonNull String pattern) {
        Cache.CacheItem cacheItem = (Cache.CacheItem)this.cache.asMap().get(pattern);
        if (cacheItem != null) {
            return (Set)cacheItem.value;
        }
        Set<String> scan = RedisUtils.scan(pattern);
        RedisUtils.publish(CacheMessage.CHANNEL, CacheMessage.write(pattern, scan));
        if (!scan.isEmpty()) {
            this.cache.put((Object)pattern, new Cache.CacheItem<Set<String>>(scan));
            this.keyPatterns.add(pattern);
        }
        return scan;
    }

    @Override
    public @NonNull Set<String> keysAndLoad(String pattern) {
        Set<String> keys = this.keys(pattern);
        Async.run(() -> this.cache.getAll((Iterable)keys));
        return keys;
    }

    @Override
    public boolean notKey(@NonNull String key) {
        return this.cache.get((Object)key) == null;
    }

    @Override
    public long ttl(@NonNull String key) {
        return RedisUtils.ttl(key);
    }

    @Override
    public <E> void set(@NonNull String key, @Nullable E element, long ttl) {
        if (this.cache.asMap().get(key) == null) {
            Async.run(() -> {
                List collect = this.keyPatterns.stream().filter(k -> Utils.stringMatch((String)k, (String)key, (boolean)false)).collect(Collectors.toList());
                this.cache.invalidateAll(collect);
            });
        }
        this.setSneaky(key, element, ttl);
        RedisUtils.publish(CacheMessage.CHANNEL, CacheMessage.write(key));
    }

    @Override
    public <E> void setSneaky(@NonNull String key, @Nullable E element, long number, @NonNull TimeUnit unit) {
        this.setSneaky(key, element, unit.toSeconds(number));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E> void setSneaky(@NonNull String key, @Nullable E element, long ttl) {
        if (ttl == 0L) {
            return;
        }
        try {
            if (ttl == -1L) {
                RedisUtils.Obj.update(key, element);
            } else if (ttl == Integer.MAX_VALUE) {
                RedisUtils.Obj.set(key, element);
            } else {
                RedisUtils.Obj.set(key, element, ttl);
            }
        }
        catch (Exception e) {
            LogUtils.logError("{}", e.getMessage());
        }
        finally {
            this.cache.put((Object)key, new Cache.CacheItem<E>(ttl, element));
        }
    }

    @Override
    public @Nullable Object get(String key) {
        Cache.CacheItem item = (Cache.CacheItem)this.cache.get((Object)key);
        return item != null ? item.value : null;
    }

    @Override
    public @NonNull Map<String, Object> get(Set<String> keys) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        this.cache.getAll(keys).forEach((k, v) -> map.put((String)k, v.value));
        return map;
    }

    @Override
    public <T> @NonNull Map<String, T> get(@NonNull Set<String> keys, @NonNull Class<T> requiredType) {
        HashMap map = new HashMap();
        Map items = this.cache.getAll(keys);
        items.forEach((k, v) -> {
            if (v.value == null) {
                map.put(k, null);
            } else {
                map.put(k, Utils.castValue((Object)v.value, (Class)requiredType));
            }
        });
        return map;
    }

    @Override
    public void del(@NonNull String key) {
        this.cache.invalidate((Object)key);
        Async.run(() -> {
            RedisUtils.Obj.del(key);
            RedisUtils.publish(CacheMessage.CHANNEL, CacheMessage.delete(key));
            List collect = this.keyPatterns.stream().filter(k -> Utils.stringMatch((String)k, (String)key, (boolean)false)).collect(Collectors.toList());
            this.cache.invalidateAll(collect);
        });
    }

    @Override
    public void del(@NonNull Set<String> keys) {
        this.cache.invalidateAll(keys);
        Async.run(() -> {
            RedisUtils.Obj.del(keys);
            RedisUtils.publish(CacheMessage.CHANNEL, CacheMessage.delete(keys));
            List collect = this.keyPatterns.stream().filter(k -> keys.stream().anyMatch(key -> Utils.stringMatch((String)k, (String)key, (boolean)false))).collect(Collectors.toList());
            this.cache.invalidateAll(collect);
        });
    }

    @Override
    public void receive(@NonNull CacheMessage message) {
        if (CacheMessage.Type.WRITE.equals((Object)message.getType())) {
            this.setSync(message);
        } else {
            this.delSync(message.getKeys());
        }
    }

    private void setSync(CacheMessage message) {
        Set<String> keys = message.getKeys();
        String pattern = message.getPattern();
        if (pattern != null) {
            this.cache.put((Object)pattern, new Cache.CacheItem<Set<String>>(keys));
        } else {
            String key = CollectionUtils.resolveSingletonSet(keys);
            Object o = RedisUtils.Obj.get(key);
            long ttl = RedisUtils.ttl(key);
            if (ttl != -2L) {
                if (this.cache.asMap().get(key) == null) {
                    List collect = this.keyPatterns.stream().filter(k -> Utils.stringMatch((String)k, (String)key, (boolean)false)).collect(Collectors.toList());
                    this.cache.invalidateAll(collect);
                }
                this.cache.put((Object)key, new Cache.CacheItem<Object>(ttl, o));
            } else {
                this.cache.invalidate((Object)key);
            }
        }
    }

    private void delSync(Set<String> keys) {
        if (keys == null || keys.isEmpty()) {
            return;
        }
        List collect = this.keyPatterns.stream().filter(k -> keys.stream().anyMatch(key -> Utils.stringMatch((String)k, (String)key, (boolean)false))).collect(Collectors.toList());
        this.cache.invalidateAll(collect);
        this.cache.invalidateAll(keys);
    }

    @Override
    public void reload() {
        this.reload(this.cache.asMap().keySet().toArray(new String[0]));
    }

    @Override
    public void reload(String ... keys) {
        for (String key : keys) {
            long ttl = RedisUtils.ttl(key);
            Object o = RedisUtils.Obj.get(key);
            if (ttl == -2L) {
                this.del(key);
                continue;
            }
            if (ttl <= -2L) continue;
            this.set(key, o, ttl);
        }
    }

    @Override
    public @NonNull Map<String, Cache.CacheItem> asMap() {
        return Collections.unmodifiableMap(this.cache.asMap());
    }
}

