/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.cache;

import cn.omisheep.authz.core.msg.CacheMessage;
import cn.omisheep.commons.util.CollectionUtils;
import cn.omisheep.commons.util.TimeUtils;
import cn.omisheep.commons.util.Utils;
import com.github.benmanes.caffeine.cache.Expiry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface Cache {
    public static final String ALL = "*";
    public static final String EMPTY = "";
    public static final String SEPARATOR = ":";
    public static final long INFINITE = Integer.MAX_VALUE;
    public static final long INHERIT = -1L;

    public @NonNull Set<String> keys(@NonNull String var1);

    default public @NonNull Set<String> keysAndLoad(String pattern) {
        return this.keys(pattern);
    }

    public boolean notKey(@NonNull String var1);

    public long ttl(@NonNull String var1);

    public <E> void set(@NonNull String var1, @Nullable E var2, long var3);

    default public <E> void setSneaky(@NonNull String key, @Nullable E element, long ttl) {
        this.set(key, element, ttl);
    }

    default public <E> void set(@NonNull String key, @Nullable E element) {
        this.set(key, element, -1L);
    }

    default public <E> void set(@NonNull String key, @Nullable E element, long number, @NonNull TimeUnit unit) {
        this.set(key, element, unit.toSeconds(number));
    }

    default public <E> void setSneaky(@NonNull String key, @Nullable E element, long number, @NonNull TimeUnit unit) {
        this.set(key, element, unit.toSeconds(number));
    }

    default public <E> void set(@NonNull String key, @Nullable E element, @NonNull String ttl) {
        this.set(key, element, TimeUtils.parseTimeValueToSecond((String)ttl));
    }

    public @Nullable Object get(String var1);

    default public <T> @Nullable T get(@NonNull String key, @NonNull Class<T> requiredType) {
        return (T)Utils.castValue((Object)this.get(key), requiredType);
    }

    default public @NonNull Map<String, Object> getByPattern(@NonNull String pattern) {
        return this.get(this.keysAndLoad(pattern));
    }

    default public <T> @NonNull Map<String, T> getByPattern(@NonNull String pattern, @NonNull Class<T> requiredType) {
        return this.get(this.keysAndLoad(pattern), requiredType);
    }

    default public List<Object> listByPattern(@NonNull String pattern) {
        return new ArrayList<Object>(this.get(this.keysAndLoad(pattern)).values());
    }

    default public <T> List<T> listByPattern(@NonNull String pattern, @NonNull Class<T> requiredType) {
        return new ArrayList<T>(this.get(this.keysAndLoad(pattern), requiredType).values());
    }

    public @NonNull Map<String, Object> get(Set<String> var1);

    public <T> @NonNull Map<String, T> get(@NonNull Set<String> var1, @NonNull Class<T> var2);

    public void del(@NonNull String var1);

    public void del(@NonNull Set<String> var1);

    default public void del(String ... keys) {
        this.del(CollectionUtils.ofSet((Object[])keys));
    }

    default public @NonNull Map<String, CacheItem> asMap() {
        return new HashMap<String, CacheItem>();
    }

    default public void receive(@NonNull CacheMessage message) {
    }

    default public void reload() {
    }

    default public void reload(String ... keys) {
    }

    default public void reload(Collection<String> ... keys) {
        this.reload((String[])Arrays.stream(keys).toArray(String[]::new));
    }

    public static class CacheExpiry
    implements Expiry<String, CacheItem> {
        private long expireAfterCreateTime;
        private long expireAfterUpdateTime;
        private long expireAfterReadTime;

        public CacheExpiry(long expireTime, TimeUnit unit) {
            this.expireAfterUpdateTime = this.expireAfterReadTime = unit.toNanos(expireTime);
            this.expireAfterCreateTime = this.expireAfterReadTime;
        }

        public CacheExpiry() {
            this(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
        }

        public long expireAfterCreate(@NonNull String s, @NonNull CacheItem eCacheItem, long currentTime) {
            return eCacheItem.expireAfterNanos(this.expireAfterCreateTime);
        }

        public long expireAfterUpdate(@NonNull String s, @NonNull CacheItem eCacheItem, long currentTime, @NonNegative long currentDuration) {
            return eCacheItem.expireAfterNanos(this.expireAfterUpdateTime);
        }

        public long expireAfterRead(@NonNull String s, @NonNull CacheItem eCacheItem, long currentTime, @NonNegative long currentDuration) {
            return eCacheItem.expireAfterNanos(this.expireAfterReadTime);
        }

        public CacheExpiry setExpireAfterCreateTime(long expireAfterCreateTime) {
            this.expireAfterCreateTime = expireAfterCreateTime;
            return this;
        }

        public CacheExpiry setExpireAfterUpdateTime(long expireAfterUpdateTime) {
            this.expireAfterUpdateTime = expireAfterUpdateTime;
            return this;
        }

        public CacheExpiry setExpireAfterReadTime(long expireAfterReadTime) {
            this.expireAfterReadTime = expireAfterReadTime;
            return this;
        }
    }

    public static class CacheItem<E> {
        protected final long expiration;
        protected Object value;

        public CacheItem(long ttl, E value) {
            this.expiration = ttl != -1L ? TimeUtils.nowTime() + ttl * 1000L : 0L;
            this.value = value;
        }

        public CacheItem(E value) {
            this(-1L, value);
        }

        public long ttl() {
            if (this.expiration == Integer.MAX_VALUE || this.expiration == -1L) {
                return this.expiration;
            }
            return TimeUnit.MILLISECONDS.toSeconds(this.expiration - TimeUtils.nowTime());
        }

        public long expireAfterNanos() {
            return this.expireAfterNanos(Long.MAX_VALUE);
        }

        public long expireAfterNanos(long expireNanos) {
            if (this.expiration == 0L) {
                return expireNanos;
            }
            return TimeUnit.MILLISECONDS.toNanos(this.expiration - TimeUtils.nowTime());
        }

        public Object getValue() {
            return this.value;
        }
    }
}

