/*
 * Decompiled with CFR 0.152.
 */
package cn.omisheep.authz.core.auth.rpd;

import cn.omisheep.authz.core.auth.AuthzModifiable;
import cn.omisheep.authz.core.auth.AuthzModifier;
import cn.omisheep.authz.core.auth.rpd.DataPermMeta;
import cn.omisheep.authz.core.auth.rpd.FieldData;
import cn.omisheep.authz.core.auth.rpd.ParamMetadata;
import cn.omisheep.authz.core.auth.rpd.PermRolesMeta;
import cn.omisheep.authz.core.auth.rpd.Rule;
import cn.omisheep.authz.core.init.AuInit;
import cn.omisheep.authz.core.util.AUtils;
import cn.omisheep.authz.core.util.LogUtils;
import cn.omisheep.authz.support.util.IPRange;
import cn.omisheep.authz.support.util.IPRangeMeta;
import cn.omisheep.web.entity.Result;
import cn.omisheep.web.entity.ResultCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class PermissionDict
implements AuthzModifiable {
    private static final Logger log = LoggerFactory.getLogger(PermissionDict.class);
    private static final AtomicInteger version = new AtomicInteger(0);
    private static PermissionDict SELF;
    private static HashSet<IPRange> globalAllow;
    private static HashSet<IPRange> globalDeny;
    private static boolean supportNative;
    private static Map<String, Map<String, PermRolesMeta>> authzMetadata;
    private static Map<String, Set<String>> certificatedMetadata;
    private static Map<String, ArgsMeta> argsMetadata;
    private static Map<String, List<DataPermMeta>> dataPermMetadata;
    private static Map<String, Map<String, FieldData>> fieldMetadata;
    private static Map<String, Map<String, IPRangeMeta>> ipRangeMeta;
    private static final Map<String, Map<String, String>> authzResourcesNameAndTemplate;
    private static final Map<String, Map<String, Map<ParamMetadata.ParamType, Map<String, Class<?>>>>> rawMap;
    private static Map<String, Map<String, PermRolesMeta>> m1;
    private static Map<String, Map<String, String>> m2;
    private static Map<String, List<DataPermMeta>> m3;
    private static Map<String, Map<String, FieldData>> m4;
    private static Map<String, ArgsMeta> m5;
    private static final Map<String, Map<String, Map<ParamMetadata.ParamType, Map<String, Class<?>>>>> m6;
    private static Map<String, Map<String, IPRangeMeta>> m7;
    private static Map<String, Set<String>> m8;
    private final ReentrantLock lock = new ReentrantLock();
    private static String permSeparator;

    public static PermissionDict self() {
        return SELF;
    }

    public boolean isSupportNative() {
        return supportNative;
    }

    public Map<String, Map<String, PermRolesMeta>> getRolePermission() {
        return m1;
    }

    public Map<String, Map<String, String>> getResourcesNameAndTemplate() {
        return m2;
    }

    public Map<String, List<DataPermMeta>> getDataPermission() {
        return m3;
    }

    public Map<String, Map<String, FieldData>> getFieldsData() {
        return m4;
    }

    public Map<String, ArgsMeta> getArgs() {
        return m5;
    }

    public Map<String, Map<String, Map<ParamMetadata.ParamType, Map<String, Class<?>>>>> getRawParamMap() {
        return m6;
    }

    public Map<String, Map<String, IPRangeMeta>> getIPRange() {
        return m7;
    }

    public Map<String, Set<String>> getCertificatedMetadata() {
        return m8;
    }

    public HashSet<IPRange> getGlobalAllow() {
        return globalAllow;
    }

    public HashSet<IPRange> getGlobalDeny() {
        return globalDeny;
    }

    @Override
    @Nullable
    public Object modify(@NonNull AuthzModifier authzModifier) {
        if (authzModifier.getTarget() == null) {
            return this.modifyParam(authzModifier);
        }
        switch (authzModifier.getTarget()) {
            case API: {
                return this.modifyAPI(authzModifier);
            }
            case PATH: 
            case PARAM: 
            case PATH_VARIABLE_PERMISSION: 
            case PATH_VAR_PERMISSION: 
            case PATH_VARIABLE_ROLE: 
            case PATH_VAR_ROLE: 
            case REQUEST_PARAM_ROLE: 
            case PARAM_ROLE: 
            case REQUEST_PARAM_PERMISSION: 
            case PARAM_PERMISSION: {
                return this.modifyParam(authzModifier);
            }
            case DATA_ROW: 
            case DATA_COL: {
                return this.modifyData(authzModifier);
            }
            case NON: {
                return null;
            }
        }
        return null;
    }

    public static List<Class<?>> argType(String argsName) {
        ArgsMeta meta = argsMetadata.get(argsName);
        if (meta == null) {
            return null;
        }
        return meta.parameterList;
    }

    public static Object argsHandle(String argName, Object ... otherArgs) {
        ArgsMeta meta = argsMetadata.get(argName);
        if (meta == null) {
            LogUtils.logError("arg {} is null", argName);
            return null;
        }
        try {
            Object bean = AUtils.getBean(meta.type);
            return meta.method.invoke(bean, otherArgs);
        }
        catch (Exception e) {
            try {
                if (Modifier.isStatic(meta.method.getModifiers())) {
                    return meta.method.invoke(null, otherArgs);
                }
                int modifiers = meta.type.getModifiers();
                if (Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers)) {
                    log.error("{} bean \u4e0d\u5b58\u5728 \u4e14\u4e0d\u80fd\u5b9e\u4f8b\u5316 \uff0c \u6216\u8005\u53c2\u6570\u4e2a\u6570\u3001\u7c7b\u578b\u4e0d\u6b63\u786e", (Object)meta.type);
                    return null;
                }
                return meta.method.invoke(meta.type.newInstance(), otherArgs);
            }
            catch (Exception ex) {
                log.error("{} \u6784\u9020\u51fd\u6570\u5f02\u5e38", (Object)meta.type);
                return null;
            }
        }
    }

    public static Map<String, String> parseTypeForTemplate(String className) {
        HashMap<String, String> typeTemplate = new HashMap<String, String>();
        try {
            Class<?> clz = Class.forName(className);
            for (Method method : clz.getMethods()) {
                String name = method.getName();
                if (!name.startsWith("get") && !name.startsWith("is") || !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || Modifier.isAbstract(method.getModifiers()) || Modifier.isNative(method.getModifiers()) || Modifier.isFinal(method.getModifiers())) continue;
                String field = name.startsWith("get") ? name.substring(3, 4).toLowerCase(Locale.ROOT) + name.substring(4) : name.substring(2, 3).toLowerCase(Locale.ROOT) + name.substring(3);
                typeTemplate.put(field, method.getReturnType().getTypeName());
            }
        }
        catch (Exception e) {
            return new HashMap<String, String>();
        }
        return typeTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object modifyAPI(AuthzModifier authzModifier) {
        this.lock.lock();
        try {
            switch (authzModifier.getOperate()) {
                case ADD: {
                    Map<String, PermRolesMeta> target = authzMetadata.get(authzModifier.getMethod());
                    PermRolesMeta build = authzModifier.build();
                    target.put(authzModifier.getApi(), build);
                    if (build.non()) {
                        certificatedMetadata.get(authzModifier.getMethod()).remove(authzModifier.getApi());
                    } else {
                        certificatedMetadata.get(authzModifier.getMethod()).add(authzModifier.getApi());
                    }
                    ResultCode resultCode = Result.SUCCESS;
                    return resultCode;
                }
                case MODIFY: 
                case UPDATE: {
                    authzMetadata.get(authzModifier.getMethod()).get(authzModifier.getApi()).merge(authzModifier.build());
                    if (authzMetadata.get(authzModifier.getMethod()).get(authzModifier.getApi()).non()) {
                        certificatedMetadata.get(authzModifier.getMethod()).remove(authzModifier.getApi());
                    } else {
                        certificatedMetadata.get(authzModifier.getMethod()).add(authzModifier.getApi());
                    }
                    ResultCode target = Result.SUCCESS;
                    return target;
                }
                case DELETE: 
                case DEL: {
                    authzMetadata.get(authzModifier.getMethod()).get(authzModifier.getApi()).removeApi();
                    certificatedMetadata.get(authzModifier.getMethod()).remove(authzModifier.getApi());
                    ResultCode target = Result.SUCCESS;
                    return target;
                }
                case GET: 
                case READ: {
                    if (authzModifier.getApi() == null && authzModifier.getMethod() == null) {
                        Map<String, Map<String, PermRolesMeta>> target = authzMetadata;
                        return target;
                    }
                    if (authzModifier.getApi() == null) {
                        Map<String, PermRolesMeta> target = authzMetadata.get(authzModifier.getMethod());
                        return target;
                    }
                    if (authzModifier.getMethod() == null) {
                        HashMap mp = new HashMap();
                        authzMetadata.forEach((k, v) -> v.entrySet().stream().map(e -> {
                            if (((String)e.getKey()).equals(authzModifier.getApi())) {
                                return (PermRolesMeta)e.getValue();
                            }
                            return null;
                        }).filter(Objects::nonNull).forEach(s -> mp.computeIfAbsent(k, r -> new ArrayList()).add(s)));
                        HashMap hashMap = mp;
                        return hashMap;
                    }
                    Map<String, PermRolesMeta> target = authzMetadata.get(authzModifier.getMethod());
                    PermRolesMeta permRolesMeta = target.get(authzModifier.getApi());
                    return permRolesMeta;
                }
            }
            ResultCode resultCode = Result.FAIL;
            return resultCode;
        }
        catch (Exception e) {
            ResultCode resultCode = Result.FAIL;
            return resultCode;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object modifyParam(AuthzModifier authzModifier) {
        this.lock.lock();
        try {
            PermRolesMeta meta = authzMetadata.get(authzModifier.getMethod()).get(authzModifier.getApi());
            AuthzModifier.Target target = authzModifier.getTarget();
            if (target == null && (authzModifier.getOperate() == AuthzModifier.Operate.GET || authzModifier.getOperate() == AuthzModifier.Operate.READ)) {
                if (authzModifier.getTarget() == null && authzModifier.getValue() == null) {
                    Map<ParamMetadata.ParamType, Map<String, ParamMetadata>> map = meta.getParamPermissionsMetadata();
                    return map;
                }
                HashMap<String, ParamMetadata> map = new HashMap<String, ParamMetadata>();
                Map<String, ParamMetadata> m1 = meta.getParamPermissionsMetadata().get((Object)ParamMetadata.ParamType.PATH_VARIABLE);
                Map<String, ParamMetadata> m2 = meta.getParamPermissionsMetadata().get((Object)ParamMetadata.ParamType.REQUEST_PARAM);
                if (m1 != null && m1.containsKey(authzModifier.getValue())) {
                    map.put("PATH_VARIABLE", m1.get(authzModifier.getValue()));
                }
                if (m2 != null && m2.containsKey(authzModifier.getValue())) {
                    map.put("REQUEST_PARAM", m2.get(authzModifier.getValue()));
                }
                HashMap<String, ParamMetadata> hashMap = map;
                return hashMap;
            }
            Object[] objects = this.getParamMetaList(meta, authzModifier);
            ParamMetadata paramMetadata = (ParamMetadata)objects[0];
            List metaList = (List)objects[1];
            if (metaList == null) {
                ResultCode resultCode = Result.FAIL;
                return resultCode;
            }
            switch (authzModifier.getOperate()) {
                case ADD: {
                    PermRolesMeta.Meta _m = authzModifier.getTarget().contains("role") ? authzModifier.build().role : authzModifier.build().permissions;
                    if (authzModifier.getIndex() != null) {
                        metaList.add(authzModifier.getIndex(), _m);
                    } else {
                        metaList.add(_m);
                    }
                    if (authzModifier.getRange() != null) {
                        _m.setRange(new HashSet<String>(authzModifier.getRange()));
                    }
                    if (authzModifier.getResources() != null) {
                        _m.setRange(new HashSet<String>(authzModifier.getResources()));
                    }
                    List list = metaList;
                    return list;
                }
                case DELETE: 
                case DEL: {
                    if (authzModifier.getIndex() != null) {
                        metaList.remove(metaList.get(authzModifier.getIndex()));
                    } else if (target == AuthzModifier.Target.PATH) {
                        meta.getParamPermissionsMetadata().get((Object)ParamMetadata.ParamType.PATH_VARIABLE).remove(authzModifier.getValue());
                    } else {
                        meta.getParamPermissionsMetadata().get((Object)ParamMetadata.ParamType.REQUEST_PARAM).remove(authzModifier.getValue());
                    }
                    PermRolesMeta permRolesMeta = meta;
                    return permRolesMeta;
                }
                case MODIFY: 
                case UPDATE: {
                    PermRolesMeta build = authzModifier.build();
                    PermRolesMeta.Meta m = (PermRolesMeta.Meta)metaList.get(authzModifier.getIndex());
                    if (authzModifier.getTarget().contains("role")) {
                        if (build.getRequireRoles() != null) {
                            m.setRequire(build.getRequireRoles());
                        }
                        if (build.getExcludeRoles() != null) {
                            m.setExclude(build.getExcludeRoles());
                        }
                    } else {
                        if (build.getRequirePermissions() != null) {
                            m.setRequire(build.getRequirePermissions());
                        }
                        if (build.getExcludePermissions() != null) {
                            m.setExclude(build.getExcludePermissions());
                        }
                    }
                    if (authzModifier.getRange() != null) {
                        m.setRange(new HashSet<String>(authzModifier.getRange()));
                    }
                    if (authzModifier.getResources() != null) {
                        m.setResources(new HashSet<String>(authzModifier.getResources()));
                    }
                    PermRolesMeta.Meta meta2 = m;
                    return meta2;
                }
                case GET: 
                case READ: {
                    if (authzModifier.getIndex() == null) {
                        ParamMetadata paramMetadata2 = paramMetadata;
                        return paramMetadata2;
                    }
                    Object e = metaList.get(authzModifier.getIndex());
                    return e;
                }
                case NON: {
                    ResultCode resultCode = Result.SUCCESS;
                    return resultCode;
                }
            }
            ParamMetadata paramMetadata3 = paramMetadata;
            return paramMetadata3;
        }
        catch (Exception e) {
            ResultCode resultCode = Result.FAIL;
            return resultCode;
        }
        finally {
            this.lock.unlock();
        }
    }

    private Object[] getParamMetaList(PermRolesMeta meta, AuthzModifier authzModifier) {
        boolean isAdd;
        boolean bl = isAdd = authzModifier.getOperate() == AuthzModifier.Operate.ADD;
        if (meta == null) {
            if (isAdd) {
                Map<ParamMetadata.ParamType, Map<String, Class<?>>> paramTypeMapMap = rawMap.get(authzModifier.getMethod()).get(authzModifier.getApi());
                switch (authzModifier.getTarget().i) {
                    case 2: 
                    case 3: {
                        Class<?> aClass1 = paramTypeMapMap.get((Object)ParamMetadata.ParamType.PATH_VARIABLE).get(authzModifier.getValue());
                        if (aClass1 != null) {
                            meta = authzMetadata.computeIfAbsent(authzModifier.getMethod(), r -> new HashMap()).computeIfAbsent(authzModifier.getApi(), r -> new PermRolesMeta());
                            ParamMetadata pmd = new ParamMetadata();
                            meta.put(ParamMetadata.ParamType.PATH_VARIABLE, authzModifier.getValue(), pmd.setParamType(aClass1));
                            break;
                        }
                        return null;
                    }
                    case 4: 
                    case 5: {
                        Class<?> aClass2 = paramTypeMapMap.get((Object)ParamMetadata.ParamType.REQUEST_PARAM).get(authzModifier.getValue());
                        if (aClass2 != null) {
                            meta = authzMetadata.computeIfAbsent(authzModifier.getMethod(), r -> new HashMap()).computeIfAbsent(authzModifier.getApi(), r -> new PermRolesMeta());
                            ParamMetadata pmd = new ParamMetadata();
                            meta.put(ParamMetadata.ParamType.REQUEST_PARAM, authzModifier.getValue(), pmd.setParamType(aClass2));
                            break;
                        }
                        return null;
                    }
                    default: {
                        return null;
                    }
                }
            } else {
                return null;
            }
        }
        switch (authzModifier.getTarget().i) {
            case 2: {
                List<PermRolesMeta.Meta> rolesMetaList;
                ParamMetadata paramMetadata = meta.getParamPermissionsMetadata().get((Object)ParamMetadata.ParamType.PATH_VARIABLE).computeIfAbsent(authzModifier.getValue(), r -> new ParamMetadata().setParamType(rawMap.get(authzModifier.getMethod()).get(authzModifier.getApi()).get((Object)ParamMetadata.ParamType.PATH_VARIABLE).get(authzModifier.getValue())));
                if (paramMetadata != null) {
                    rolesMetaList = paramMetadata.getRolesMetaList();
                    if (rolesMetaList == null && isAdd) {
                        rolesMetaList = new ArrayList<PermRolesMeta.Meta>();
                        paramMetadata.setRolesMetaList(rolesMetaList);
                    }
                    return new Object[]{paramMetadata, paramMetadata.getRolesMetaList()};
                }
                if (isAdd) {
                    paramMetadata = meta.getParamPermissionsMetadata().get((Object)ParamMetadata.ParamType.PATH_VARIABLE).computeIfAbsent(authzModifier.getValue(), r -> new ParamMetadata());
                    paramMetadata.setRolesMetaList(new ArrayList<PermRolesMeta.Meta>());
                    return new Object[]{paramMetadata, paramMetadata.getRolesMetaList()};
                }
                return null;
            }
            case 3: {
                List<PermRolesMeta.Meta> permissionsMetaList;
                ParamMetadata paramMetadata = meta.getParamPermissionsMetadata().get((Object)ParamMetadata.ParamType.PATH_VARIABLE).computeIfAbsent(authzModifier.getValue(), r -> new ParamMetadata().setParamType(rawMap.get(authzModifier.getMethod()).get(authzModifier.getApi()).get((Object)ParamMetadata.ParamType.PATH_VARIABLE).get(authzModifier.getValue())));
                if (paramMetadata != null) {
                    permissionsMetaList = paramMetadata.getPermissionsMetaList();
                    if (permissionsMetaList == null && isAdd) {
                        permissionsMetaList = new ArrayList<PermRolesMeta.Meta>();
                        paramMetadata.setPermissionsMetaList(permissionsMetaList);
                    }
                    return new Object[]{paramMetadata, paramMetadata.getPermissionsMetaList()};
                }
                if (isAdd) {
                    paramMetadata = meta.getParamPermissionsMetadata().get((Object)ParamMetadata.ParamType.PATH_VARIABLE).computeIfAbsent(authzModifier.getValue(), r -> new ParamMetadata());
                    paramMetadata.setPermissionsMetaList(new ArrayList<PermRolesMeta.Meta>());
                    return new Object[]{paramMetadata, paramMetadata.getPermissionsMetaList()};
                }
                return null;
            }
            case 4: {
                List<PermRolesMeta.Meta> rolesMetaList;
                ParamMetadata paramMetadata = meta.getParamPermissionsMetadata().get((Object)ParamMetadata.ParamType.REQUEST_PARAM).computeIfAbsent(authzModifier.getValue(), r -> new ParamMetadata().setParamType(rawMap.get(authzModifier.getMethod()).get(authzModifier.getApi()).get((Object)ParamMetadata.ParamType.REQUEST_PARAM).get(authzModifier.getValue())));
                if (paramMetadata != null) {
                    rolesMetaList = paramMetadata.getRolesMetaList();
                    if (rolesMetaList == null && isAdd) {
                        rolesMetaList = new ArrayList<PermRolesMeta.Meta>();
                        paramMetadata.setRolesMetaList(rolesMetaList);
                    }
                    return new Object[]{paramMetadata, paramMetadata.getRolesMetaList()};
                }
                if (isAdd) {
                    paramMetadata = meta.getParamPermissionsMetadata().get((Object)ParamMetadata.ParamType.REQUEST_PARAM).computeIfAbsent(authzModifier.getValue(), r -> new ParamMetadata());
                    paramMetadata.setRolesMetaList(new ArrayList<PermRolesMeta.Meta>());
                    return new Object[]{paramMetadata, paramMetadata.getRolesMetaList()};
                }
                return null;
            }
            case 5: {
                List<PermRolesMeta.Meta> permissionsMetaList;
                ParamMetadata paramMetadata = meta.getParamPermissionsMetadata().get((Object)ParamMetadata.ParamType.REQUEST_PARAM).computeIfAbsent(authzModifier.getValue(), r -> new ParamMetadata().setParamType(rawMap.get(authzModifier.getMethod()).get(authzModifier.getApi()).get((Object)ParamMetadata.ParamType.REQUEST_PARAM).get(authzModifier.getValue())));
                if (paramMetadata != null) {
                    permissionsMetaList = paramMetadata.getPermissionsMetaList();
                    if (permissionsMetaList == null && isAdd) {
                        permissionsMetaList = new ArrayList<PermRolesMeta.Meta>();
                        paramMetadata.setPermissionsMetaList(permissionsMetaList);
                    }
                    return new Object[]{paramMetadata, paramMetadata.getPermissionsMetaList()};
                }
                if (isAdd) {
                    paramMetadata = meta.getParamPermissionsMetadata().get((Object)ParamMetadata.ParamType.REQUEST_PARAM).computeIfAbsent(authzModifier.getValue(), r -> new ParamMetadata());
                    paramMetadata.setPermissionsMetaList(new ArrayList<PermRolesMeta.Meta>());
                    return new Object[]{paramMetadata, paramMetadata.getPermissionsMetaList()};
                }
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object modifyData(AuthzModifier authzModifier) {
        Object object;
        try {
            this.lock.lock();
            String className = authzModifier.getClassName();
            if (className == null) {
                if (authzModifier.getTarget() == AuthzModifier.Target.DATA_COL) {
                    Map<String, Map<String, FieldData>> map = fieldMetadata;
                    return map;
                }
                if (authzModifier.getTarget() == AuthzModifier.Target.DATA_ROW) {
                    Map<String, List<DataPermMeta>> map = dataPermMetadata;
                    return map;
                }
                ResultCode resultCode = Result.FAIL;
                return resultCode;
            }
            if (authzResourcesNameAndTemplate.get(className) == null) {
                ResultCode resultCode = Result.FAIL;
                return resultCode;
            }
            if (authzModifier.getTarget() == AuthzModifier.Target.DATA_ROW) {
                Object dataPermMeta;
                switch (authzModifier.getOperate()) {
                    case ADD: {
                        Rule rule = authzModifier.getRule();
                        dataPermMeta = rule == null ? DataPermMeta.of(authzModifier.getCondition()) : DataPermMeta.of(rule);
                        PermRolesMeta build = authzModifier.build();
                        ((DataPermMeta)dataPermMeta).setRoles(build.role);
                        ((DataPermMeta)dataPermMeta).setPermissions(build.permissions);
                        ((DataPermMeta)dataPermMeta).setArgsMap(authzModifier.getArgsMap());
                        dataPermMetadata.computeIfAbsent(className, r -> new ArrayList()).add(dataPermMeta);
                        break;
                    }
                    case MODIFY: 
                    case UPDATE: {
                        if (authzModifier.getIndex() == null) {
                            ResultCode resultCode = Result.FAIL;
                            return resultCode;
                        }
                        if (dataPermMetadata.get(className) == null) {
                            ResultCode resultCode = Result.FAIL;
                            return resultCode;
                        }
                        DataPermMeta old_data_mata = dataPermMetadata.get(className).get(authzModifier.getIndex());
                        DataPermMeta new_data_mata = null;
                        if (authzModifier.getCondition() != null) {
                            new_data_mata = DataPermMeta.of(authzModifier.getCondition());
                        }
                        if (authzModifier.getRule() != null) {
                            new_data_mata = DataPermMeta.of(authzModifier.getRule());
                        }
                        if (new_data_mata != null) {
                            old_data_mata.setRule(new_data_mata.getRule());
                            old_data_mata.setCondition(new_data_mata.getCondition());
                        }
                        PermRolesMeta build_new = authzModifier.build();
                        if (build_new.role != null) {
                            old_data_mata.setRoles(build_new.role);
                        }
                        if (build_new.permissions != null) {
                            old_data_mata.setPermissions(build_new.permissions);
                        }
                        if (authzModifier.getArgsMap() == null) break;
                        old_data_mata.setArgsMap(authzModifier.getArgsMap());
                        break;
                    }
                    case DELETE: 
                    case DEL: {
                        Integer index = authzModifier.getIndex();
                        if (dataPermMetadata.get(className) == null) {
                            ResultCode resultCode = Result.FAIL;
                            return resultCode;
                        }
                        if (index == null) {
                            dataPermMetadata.get(className).clear();
                            break;
                        }
                        dataPermMetadata.get(className).remove(index);
                        break;
                    }
                    case GET: 
                    case READ: {
                        if (dataPermMetadata.get(className) == null) {
                            Map<String, List<DataPermMeta>> map = dataPermMetadata;
                            return map;
                        }
                        if (authzModifier.getIndex() == null) {
                            List<DataPermMeta> list = dataPermMetadata.get(className);
                            return list;
                        }
                        DataPermMeta dataPermMeta2 = dataPermMetadata.get(className).get(authzModifier.getIndex());
                        return dataPermMeta2;
                    }
                    default: {
                        ResultCode resultCode = Result.FAIL;
                        return resultCode;
                    }
                }
                dataPermMeta = dataPermMetadata.get(className);
                return dataPermMeta;
            }
            switch (authzModifier.getOperate()) {
                case ADD: {
                    if (authzModifier.getFieldName() == null) {
                        ResultCode dataPermMeta = Result.FAIL;
                        return dataPermMeta;
                    }
                    Object build = authzModifier.build();
                    FieldData fieldData = new FieldData(className, build.role, build.permissions);
                    fieldMetadata.computeIfAbsent(className, r -> new HashMap()).put(authzModifier.getFieldName(), fieldData);
                }
                case MODIFY: 
                case UPDATE: {
                    Object build;
                    if (authzModifier.getFieldName() == null) {
                        build = Result.FAIL;
                        return build;
                    }
                    build = authzModifier.build();
                    FieldData fieldData = new FieldData(className, build.role, build.permissions);
                    FieldData fd = fieldMetadata.computeIfAbsent(className, r -> new HashMap()).computeIfAbsent(authzModifier.getFieldName(), r -> new FieldData(className, null, null));
                    if (fieldData.getPermissions() != null) {
                        fd.setPermissions(fieldData.getPermissions());
                    }
                    if (fieldData.getRoles() != null) {
                        fd.setRoles(fieldData.getRoles());
                    }
                }
                case GET: 
                case READ: {
                    object = fieldMetadata.get(authzModifier.getFieldName());
                    return object;
                }
                case DELETE: 
                case DEL: {
                    if (authzModifier.getFieldName() == null) {
                        fieldMetadata.remove(className);
                    } else {
                        fieldMetadata.get(className).remove(authzModifier.getFieldName());
                    }
                    ResultCode resultCode = Result.SUCCESS;
                    return resultCode;
                }
            }
            ResultCode resultCode = Result.FAIL;
            return resultCode;
        }
        catch (Exception e) {
            object = Result.FAIL;
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static void init(PermissionDict permissionDict) {
        if (SELF != null) {
            AuInit.log.error("permissionDict \u5df2\u7ecf\u521d\u59cb\u5316");
            return;
        }
        SELF = permissionDict;
    }

    public static void initAuthzMetadata(Map<String, Map<String, PermRolesMeta>> authzMetadata) {
        if (PermissionDict.authzMetadata != null) {
            AuInit.log.error("authzMetadata \u5df2\u7ecf\u521d\u59cb\u5316");
            return;
        }
        PermissionDict.authzMetadata = authzMetadata;
        m1 = Collections.unmodifiableMap(authzMetadata);
    }

    public static void addAuthzResourcesNames(Set<String> authzResourcesNames) {
        if (authzResourcesNames == null) {
            return;
        }
        HashSet<String> names = new HashSet<String>();
        for (String authzResourcesName : authzResourcesNames) {
            try {
                Map fieldMap = authzResourcesNameAndTemplate.computeIfAbsent(authzResourcesName, r -> new HashMap());
                fieldMap.putAll(PermissionDict.parseTypeForTemplate(authzResourcesName));
                names.add(authzResourcesName);
            }
            catch (Exception exception) {}
        }
        m2 = Collections.unmodifiableMap(authzResourcesNameAndTemplate);
        AuInit.log.info("authz resources add success \u2b07: \n{}", names);
    }

    public static void initDataPerm(Map<String, List<DataPermMeta>> dataPermMetadata) {
        if (PermissionDict.dataPermMetadata != null) {
            AuInit.log.error("dataPermMetadata \u5df2\u7ecf\u521d\u59cb\u5316");
            return;
        }
        PermissionDict.dataPermMetadata = dataPermMetadata;
        m3 = Collections.unmodifiableMap(dataPermMetadata);
    }

    public static void initFieldMetadata(Map<String, Map<String, FieldData>> fieldMetadata) {
        if (PermissionDict.fieldMetadata != null) {
            AuInit.log.error("fieldMetadata \u5df2\u7ecf\u521d\u59cb\u5316");
            return;
        }
        PermissionDict.fieldMetadata = fieldMetadata;
        m4 = Collections.unmodifiableMap(fieldMetadata);
    }

    public static void initArgs(Map<String, ArgsMeta> argsMetadata) {
        if (PermissionDict.argsMetadata != null) {
            AuInit.log.error("authzMetadata \u5df2\u7ecf\u521d\u59cb\u5316");
            return;
        }
        PermissionDict.argsMetadata = argsMetadata;
        m5 = Collections.unmodifiableMap(argsMetadata);
    }

    public static void initIPRangeMeta(Map<String, Map<String, IPRangeMeta>> ipRangeMeta) {
        if (PermissionDict.ipRangeMeta != null) {
            AuInit.log.error("ipRangeMeta \u5df2\u7ecf\u521d\u59cb\u5316");
            return;
        }
        PermissionDict.ipRangeMeta = ipRangeMeta;
        m7 = Collections.unmodifiableMap(ipRangeMeta);
    }

    public static void initCertificatedMetadata(Map<String, Set<String>> certificatedMetadata) {
        if (PermissionDict.certificatedMetadata != null) {
            AuInit.log.error("certificatedMetadata \u5df2\u7ecf\u521d\u59cb\u5316");
            return;
        }
        PermissionDict.certificatedMetadata = certificatedMetadata;
        m8 = Collections.unmodifiableMap(certificatedMetadata);
    }

    public static void setPermSeparator(String permSeparator) {
        PermissionDict.permSeparator = permSeparator;
    }

    public static String getPermSeparator() {
        return permSeparator;
    }

    public static void setGlobalAllow(HashSet<IPRange> globalAllow) {
        PermissionDict.globalAllow = globalAllow;
    }

    public static void setGlobalDeny(HashSet<IPRange> globalDeny) {
        PermissionDict.globalDeny = globalDeny;
    }

    public static void setSupportNative(boolean supportNative) {
        PermissionDict.supportNative = supportNative;
    }

    public static Map<String, Map<String, Map<ParamMetadata.ParamType, Map<String, Class<?>>>>> getRawMap() {
        return rawMap;
    }

    static {
        authzResourcesNameAndTemplate = new HashMap<String, Map<String, String>>();
        rawMap = new HashMap();
        m6 = Collections.unmodifiableMap(rawMap);
        permSeparator = ",";
    }

    public static class ArgsMeta {
        private final Class<?> type;
        private final Method method;
        private final List<Class<?>> parameterList;
        private final Class<?> returnType;
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        private final Map<String, String> returnTypeTemplate;

        private ArgsMeta(Class<?> type, Method method) {
            this.type = type;
            this.method = method;
            this.returnType = method.getReturnType();
            this.parameterList = Arrays.stream(method.getParameterTypes()).collect(Collectors.toList());
            this.returnTypeTemplate = PermissionDict.parseTypeForTemplate(this.returnType.getTypeName());
        }

        public String getMethod() {
            return this.method.getName();
        }

        public static ArgsMeta of(Class<?> type, Method method) {
            return new ArgsMeta(type, method);
        }

        public static ArgsMeta of(Class<?> type, String methodName, Class<?> ... args) {
            try {
                return new ArgsMeta(type, type.getMethod(methodName, args));
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                return null;
            }
        }

        public static ArgsMeta of(Object type, String methodName, Class<?> ... args) {
            return ArgsMeta.of(type.getClass(), methodName, args);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ArgsMeta)) {
                return false;
            }
            ArgsMeta meta = (ArgsMeta)o;
            return com.google.common.base.Objects.equal((Object)this.method, (Object)meta.method) && com.google.common.base.Objects.equal(this.type, meta.type);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.method, this.type});
        }

        public Class<?> getType() {
            return this.type;
        }

        public List<Class<?>> getParameterList() {
            return this.parameterList;
        }

        public Class<?> getReturnType() {
            return this.returnType;
        }

        public Map<String, String> getReturnTypeTemplate() {
            return this.returnTypeTemplate;
        }
    }
}

